<div class="modal fade" id="modal_comision" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Comisiones</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form @submit.prevent="editarGuardarComisiones" id="form-comision-modal">
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="tipo_comision">Tipo</label>:
                                <select id="tipo_comision" class="form-control">
                                    <option value="" disabled selected>Seleccione un elemento</option>
                                    <option value="1">Producto simple </option>
                                    <option value="2">Producto compuesto </option>
                                    <option value="3">Servicio tecnico</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="descripcion_comision">Descripción</label>
                                <input type="text" class="form-control" id="descripcion_comision">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="selectgroup selectgroup-secondary selectgroup-pills">
                            <label class="selectgroup-item">
                                <input type="radio" class="selectgroup-input" value="1" v-model="seleccion.selradio">
                                <span class="selectgroup-button ">General</span>
                            </label>
                            <label class="selectgroup-item">
                                <input type="radio" class="selectgroup-input" value="2" v-model="seleccion.selradio">
                                <span class="selectgroup-button">Por empleado</span>
                            </label>
                        </div>
                    </div>
                    <div class="form-group" v-show="seleccion.selradio=='1'">
                        <label for="porcentaje_comision">Porcentaje</label>
                        <input type="number" min="0.1" step="any" class="form-control" id="porcentaje_comision">
                    </div>
                    <div class="form-group">
                        <label for="form_comision">Formula</label>
                        <select id="form_comision" class="form-control">
                            <option value="" disabled selected>Seleccione un elemento</option>
                            <option value="1">(Precio Venta-Precio Costo)*Porcentaje</option>
                            <option value="2">((Precio Venta-Precio Costo)+IVA)*Porcentaje</option>
                            <option value="3">(Precio Venta)*Porcentaje</option>
                        </select>
                    </div>
                    <div class="form-group d-flex justify-content-end">
                        <button class="btn btn-primary btn-sm ">Registrar</button>
                    </div>
                </form>
                <div class="row">
                    <div class="col-12">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Comision</th>
                                    <th>Aplica</th>
                                    <th>Tipo</th>
                                    <th>Porcentaje</th>
                                    <th>Formula</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="row in comisiones" :key="row.id" @click="ver(row)" style="cursor: pointer;">
                                    <td>{{ row.comision }}</td>
                                    <td>{{ row.tipo_comision }}</td>
                                    <td>{{ row.tipo }}</td>
                                    <td class="text-right">
                                        <span v-if="row.estatus == 2">
                                            Individual
                                        </span>
                                        <span v-else>{{ row.porcentaje }} %</span>
                                    </td>
                                    <td>
                                        <small v-if="row.formula==1">(pv-pc)*%</small>
                                        <small v-if="row.formula==2">((pv-pv)+IVA)*%</small>
                                        <small v-if="row.formula==3">(pv)*%</small>
                                    </td>
                                    <td class="text-center">
                                        <div class="form-button-action">
                                            <button type="button" title="Eliminar" class="btn btn-link" @click="eliminarComision(row)">
                                                <i class="fas fa-trash text-dark"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>