<div class="container" id="appEmpleados" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Empleados</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('empleados') ?>">Empleados</a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
                <div class="btn-group" role="group" aria-label="Basic example" style="box-shadow: 2px 6px 15px 0px rgba(69, 65, 78, 0.1);">
                    <a href="#" @click.prevent="modalGuardar" class="btn btn-light"><span class="btn-label"><i class="fa fa-plus"></i></span> Nuevo Empleado</a>
                    <a href="<?= url('empleados/comisiones') ?>" class="btn btn-light"><span class="btn-label"><i class="fas fa-question-circle"></i></span> Comisiones</a>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body" :class="cargando_tabla">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable" id="tabla_empleados">
                                <thead>
                                    <tr>
                                        <th>Nombres y Apellidos</th>
                                        <th>Teléfono</th>
                                        <th>Correo</th>
                                        <th class="text-center">Estatus (usuario)</th>
                                        <th class="text-center">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in empleados">
                                        <td><a :href="'<?= ruta_base() ?>empleados/ver/' +  row.einfo_id">{{ row.einfo_nombres }} {{ row.einfo_apellidos }}</a></td>
                                        <td>{{ row.einfo_telefono_movil }}</td>
                                        <td>{{ row.einfo_email }}</td>
                                        <td class="text-center">
                                            <a href="#" title="Modificar estatus" @click.prevent="modificarEstatus(row.einfo_id, 'status'+row.einfo_id)">
                                                <i :class="row.emp_estatus == 1 ? 'fa fa-check text-success' : 'fa fa-times text-danger'" :id="'status'+row.einfo_id"></i>
                                            </a>
                                        </td>
                                        <td class="text-center">
                                            <div class="form-button-action">

                                                <button type="button" title="Eliminar" class="btn btn-link text-dark" @click="eliminar(row.einfo_id, row.einfo_nombres)">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modaleditarguardar.php'; ?>
</div>
<script src="<?= ruta_base() ?>public/assets/vue-the-mask.js"></script>
<script src="<?= ruta_base() ?>public/assetsvuejs/empleados/empleados.js"></script>