<div class="container" id="appComisiones" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Comisiones</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('empleados') ?>">Empleados</a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('empleados/comisiones') ?>">Comisiones</a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
                <a href="#" @click.prevent="modalcomision" class="btn btn-light" style="box-shadow: 2px 6px 15px 0px rgba(69, 65, 78, 0.1);"><span class="btn-label"><i class="fa fa-plus"></i></span> Nueva Comisión</a>
            </div>
        </div>
        <div class="row">
            <div class="col-12">

                <ul class="nav nav-pills nav-secondary" id="pills-tab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="pill" href="#home" role="tab" aria-controls="home" aria-selected="true">Reporte individual</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="pill" href="#global" role="tab" aria-controls="global" aria-selected="false">Reporte Global</a>
                    </li>
                </ul>

            </div>
        </div>
        <div class="tab-content mt-3">
            <div class="tab-pane fade active show mb-3" id="home">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form @submit.prevent="buscar($event)" id="form_proven_busqueda">
                                    <div class="form-row">
                                        <div class="col-sm-3">
                                            <div class="form-group form-floating-label">
                                                <input id="vdfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                                <label for="vdfecha_desde" class="placeholder">Fecha desde</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group input-group form-floating-label">
                                                <input id="vdfecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                                                <label for="vdfecha_hasta" class="placeholder">Fecha hasta</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group input-group form-floating-label">
                                                <select id="vdivisas" class="form-control input-border-bottom ">
                                                    <?php foreach ($divisas as $row) : ?>
                                                        <option value="<?= $row['id'] ?>" <?= $row['predeterminada'] ? 'selected' : '' ?>><?= $row['divisa'] ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <label for="vdivisas" class="placeholder">Divisa</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group input-group form-floating-label">
                                                <select id="vddocumento" class="form-control input-border-bottom" v-model="documento">
                                                    <option value="">Todos</option>
                                                    <option value="Empresa">Empresa</option>
                                                    <option value="Instagram">Instagram</option>
                                                    <option value="Facebook">Facebook</option>
                                                    <option value="Twitter">Twitter</option>
                                                    <option value="Woocommerce">Woocommerce</option>
                                                    <option value="Tik-Tok">Tik-Tok</option>
                                                    <option value="Whatsapp">Whatsapp</option>
                                                    <option value="Telegram">Telegram</option>
                                                    <option value="E-mail">E-mail</option>
                                                    <option value="Wechat">Wechat</option>
                                                    <option value="Otros">Otros</option>
                                                </select>
                                                <label for="vddocumento" class="placeholder">Medio</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group input-group form-floating-label">
                                                <select id="vdestatus" class="form-control input-border-bottom" v-model="estatus">
                                                    <option value="2">Todos</option>
                                                    <option value="1">Pagadas</option>
                                                    <option value="0" selected>Pendiente</option>
                                                </select>
                                                <label for="vdestatus" class="placeholder">Estatus</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group input-group form-floating-label">
                                                <select id="vdagente" class="form-control input-border-bottom" v-model="agente">
                                                    <option value="0">Todos</option>
                                                    <?php foreach ($agentes as $row) : ?>
                                                        <option value="<?= $row['einfo_id'] ?>"><?= $row['einfo_nombres'] . ' ' . $row['einfo_apellidos'] ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <label for="vdagente" class="placeholder">Agente</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group input-group form-floating-label">
                                                <select id="vdtipo" class="form-control input-border-bottom" v-model="tipo_comision">
                                                    <option value="0">Todos</option>
                                                    <?php foreach ($comisiones as $row) : ?>
                                                        <option value="<?= $row['com_id'] ?>"><?= $row['com_descripcion'] ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <label for="vdtipo" class="placeholder">Tipo comisiones</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="input-group-append">
                                                <button class="btn btn-border" type="submit"> Buscar <span class="fa fa-search"></span> </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm"></div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row row-card-no-pd">
                            <div class="col-sm-6 col-md-4">
                                <div class="card">
                                    <div class="card-body p-3 text-center">
                                        <div class="text-success">
                                            <br>
                                        </div>
                                        <div class="h2 m-0">
                                            <i class="loader loader-success" v-if="cargando"></i>
                                            <span v-else>{{pagado}} </span>
                                        </div>
                                        <div class="text-muted mb-3">Total Comisiones Pagadas</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-md-4">
                                <div class="card">
                                    <div class="card-body p-3 text-center">
                                        <div class="text-right text-success">
                                            <br>
                                        </div>
                                        <div class="h2 m-0">
                                            <i class="loader loader-success" v-if="cargando"></i>
                                            <span v-else>{{pendiente}}</span>
                                        </div>
                                        <div class="text-muted mb-3">Total Pendientes</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-md-4">
                                <div class="card">
                                    <div class="card-body p-3 text-center">
                                        <div class="text-right text-success">
                                            <br>
                                        </div>
                                        <div class="h2 m-0">
                                            <i class="loader loader-success" v-if="cargando"></i>
                                            <span v-else>{{total}}</span>
                                        </div>
                                        <div class="text-muted mb-3">Total Comisiones</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body table-responsive">
                                <table class="display table table-striped table-hover dataTable" id="tabla_historico_com">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Cliente</th>
                                            <th class="text-center">Comisión</th>
                                            <th class="text-center">Agente</th>
                                            <th class="text-center">Fecha</th>
                                            <th class="text-center">Divisa Doc.</th>
                                            <th class="text-center">Total Doc.</th>
                                            <th class="text-center">Porcentaje%</th>
                                            <th class="text-center">Divisa</th>
                                            <th class="text-center">Monto</th>
                                            <th class="text-center">Fecha de pago</th>
                                            <th class="text-center">Estatus Com.</th>
                                            <th class="text-center">Estatus Doc.</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="fn in historial_comisiones">
                                            <td>{{ fn.cliente }}</td>
                                            <td>{{ fn.com_descripcion }}</td>
                                            <td>{{ fn.agente }}</td>
                                            <td>{{ fn.fecha_reg }}</td>
                                            <td>{{ fn.divisa_factura }}</td>
                                            <td>{{ fn.total_factura_moneda }}</td>
                                            <td>{{ fn.porcentaje }} %</td>
                                            <td>{{ fn.divisa_total }}</td>
                                            <td>{{ fn.monto_moneda }}</td>
                                            <td>{{ fn.fecha_pago }}</td>
                                            <td>{{ fn.estatuscom }}</td>
                                            <td>{{ fn.idnf }} {{ fn.estatusfn }}</td>
                                            <td class="text-center">
                                                <div class="form-button-action">
                                                    <div class="input-group-append">
                                                        <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                        <div class="dropdown-menu">
                                                            <a class="dropdown-item" :href="fn.uri">Ver</a>
                                                            <a class="dropdown-item" href="#" @click.prevent="modalPendienteeditar(fn.porcentaje,fn.monto,fn.total,fn.divisa,fn.id)">Editar</a>
                                                            <a class="dropdown-item" href="#" @click.prevent="eliminarComisionPendiente(fn.id)">Eliminar</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row justify-content-center">
                            <div class="col-12">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h6 class="page-pretitle">
                                            comisiones
                                        </h6>
                                        <?php /*
                                        <h4 class="page-title">Comisiones #FDS9876KD</h4>
                                        */ ?>
                                    </div>
                                    <div class="col-auto">
                                        <a href="#" target="_blank" class="btn btn-light btn-border" id="descargarIndvComisionPendiente">
                                            Descargar
                                        </a>
                                        <?php /*
                                        <a href="#" class="btn btn-primary ml-2">
                                            Pay
                                        </a>
                                        */ ?>
                                    </div>
                                </div>
                                <div class="page-divider"></div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="card card-invoice">
                                            <div class="card-header">
                                                <div class="invoice-header">
                                                    <h3 class="invoice-title">
                                                        Comisiones <span id="estatusComisionIndv"></span>
                                                    </h3>
                                                    <?php /*
                                                    <div class="invoice-logo">
                                                        <img src="../assets/img/examples/logoinvoice.svg" alt="company logo">
                                                    </div>
                                                    */ ?>
                                                </div>
                                                <div class="invoice-desc">
                                                    <?= constant('EMP_NOMBRE') ?><br>
                                                    <p id="dataIndvFecha"></p>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div class="separator-solid"></div>
                                                <div class="row">
                                                    <?php /*
                                                    <div class="col-md-4 info-invoice">
                                                        <h5 class="sub">Fecha</h5>
                                                        <p>Dec 21, 2017</p>
                                                    </div>
                                                    <div class="col-md-4 info-invoice">
                                                        <h5 class="sub">Invoice ID</h5>
                                                        <p>#FDS9876KD</p>
                                                    </div>
                                                    <div class="col-md-4 info-invoice">
                                                        <h5 class="sub">Invoice To</h5>
                                                        <p>
                                                            Jane Smith, 1234 Main, Apt. 4B<br>Springfield, ST 54321
                                                        </p>
                                                    </div>*/ ?>
                                                </div>
                                                <div class="row">
                                                    <div class="container-full">
                                                        <div class="invoice-detail">
                                                            <div class="invoice-top">
                                                                <h3 class="title"><strong>Resumen de comisión ( <span id="tipoComisionIndv"></span> ) </strong></h3>
                                                            </div>
                                                            <div class="invoice-item">
                                                                <div class="table-responsive">
                                                                    <table class="table table-striped">
                                                                        <thead>
                                                                            <tr>
                                                                                <td><strong>Fecha</strong></td>
                                                                                <td><strong>Empleado</strong></td>
                                                                                <td><strong>Documento</strong></td>
                                                                                <td><strong>Estatus doc</strong></td>
                                                                                <td><strong>Planilla</strong></td>
                                                                                <td><strong>Observación</strong></td>
                                                                                <td><strong>%</strong></td>
                                                                                <td class="text-right"><strong>Total</strong></td>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <tr v-for="row in historial_comisiones">
                                                                                <td>{{ row.fecha_creacion }}</td>
                                                                                <td>{{ row.agente }}</td>
                                                                                <td><a :href="row.uri" target="_blank">{{ row.idnf }}</a> </td>
                                                                                <td class="text-center">{{ row.estatusfn }}</td>
                                                                                <td class="text-right"><a :href="row.uri_planilla" target="_blank">{{ row.planilla }}</a></td>
                                                                                <td class="text-left">{{ row.observacion }}</td>
                                                                                <td class="text-right">{{ row.porcentaje }}</td>
                                                                                <td class="text-right">{{ row.monto_moneda }}</td>
                                                                            </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="separator-solid  mb-3"></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-footer">
                                                <div class="row">
                                                    <?php /*
                                                    <div class="col-sm-7 col-md-5 mb-3 mb-md-0 transfer-to">
                                                        <h5 class="sub">Bank Transfer</h5>
                                                        <div class="account-transfer">
                                                            <div><span>Account Name:</span><span>Syamsuddin</span></div>
                                                            <div><span>Account Number:</span><span>1234567890934</span></div>
                                                            <div><span>Code:</span><span>BARC0032UK</span></div>
                                                        </div>
                                                    </div>
                                                    */ ?>
                                                    <div class="col-sm-5 col-md-7 transfer-total">
                                                        <h5 class="sub">Cantidad total</h5>
                                                        <div class="price" id="dataIndvCantidadTotal"></div>
                                                    </div>
                                                </div>
                                                <?php /*
                                                <div class="separator-solid"></div>
                                                <h6 class="text-uppercase mt-4 mb-3 fw-bold">
                                                    Notes
                                                </h6>
                                                <p class="text-muted mb-0">
                                                    We really appreciate your business and if there's anything else we can do, please let us know! Also, should you need us to add VAT or anything else to this order, it's super easy since this is a template, so just ask!
                                                </p> */ ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="global">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form @submit.prevent="busquedaGlobal" id="form_busqueda_global">
                                    <div class="form-row">
                                        <div class="col-sm-3">
                                            <div class="form-group form-floating-label">
                                                <input id="globFechaDesde" name="globFechaDesde" type="date" class="form-control input-border-bottom">
                                                <label for="globFechaDesde" class="placeholder">Fecha desde</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group input-group form-floating-label">
                                                <input id="globFechaHasta" name="globFechaHasta" type="date" class="form-control input-border-bottom">
                                                <label for="globFechaHasta" class="placeholder">Fecha hasta</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group input-group form-floating-label">
                                                <select id="globDivisa" name="globDivisa" class="form-control input-border-bottom ">
                                                    <?php foreach ($divisas as $row) : ?>
                                                        <option value="<?= $row['id'] ?>" <?= $row['predeterminada'] ? 'selected' : '' ?>><?= $row['divisa'] ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <label for="globDivisa" class="placeholder">Divisa</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group input-group form-floating-label">
                                                <select id="globTipoComision" name="globTipoComision" class="form-control input-border-bottom">
                                                    <option value="0">Todos</option>
                                                    <?php foreach ($comisiones as $row) : ?>
                                                        <option value="<?= $row['com_id'] ?>"><?= $row['com_descripcion'] ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <label for="globTipoComision" class="placeholder">Tipo comisiones</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group input-group form-floating-label">
                                                <select id="globEstatus" name="globEstatus" class="form-control input-border-bottom">
                                                    <option value="3">Todos</option>
                                                    <option value="1">Pagadas</option>
                                                    <option value="0" selected>Pendiente</option>
                                                </select>
                                                <label for="globEstatus" class="placeholder">Estatus</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="input-group-append">
                                                <button class="btn btn-border" type="submit"> Buscar <span class="fa fa-search"></span> </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                                <div class="row">
                                    <div class="col-12">
                                        <div class=" alert alert-warning" role="alert" v-for="row in errorFormGlobal"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row justify-content-center">
                            <div class="col-12 col-lg-10 col-xl-9">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h6 class="page-pretitle">
                                            comisiones
                                        </h6>
                                        <?php /*
                                        <h4 class="page-title">Comisiones #FDS9876KD</h4>
                                        */ ?>
                                    </div>
                                    <div class="col-auto">
                                        <a href="#" target="_blank" class="btn btn-light btn-border" id="descargarGlobComisionPendiente">
                                            Descargar
                                        </a>
                                        <?php /*
                                        <a href="#" class="btn btn-primary ml-2">
                                            Pay
                                        </a>
                                        */ ?>
                                    </div>
                                </div>
                                <div class="page-divider"></div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="card card-invoice">
                                            <div class="card-header">
                                                <div class="invoice-header">
                                                    <h3 class="invoice-title">
                                                        Comisiones <span id="estatusComisionGlob"></span>
                                                    </h3>
                                                    <?php /*
                                                    <div class="invoice-logo">
                                                        <img src="../assets/img/examples/logoinvoice.svg" alt="company logo">
                                                    </div>
                                                    */ ?>
                                                </div>
                                                <div class="invoice-desc">
                                                    <?= constant('EMP_NOMBRE') ?><br>
                                                    <p id="dataGlobFecha"></p>
                                                </div>
                                            </div>
                                            <div class="card-body">
                                                <div class="separator-solid"></div>
                                                <div class="row">
                                                    <?php /*
                                                    <div class="col-md-4 info-invoice">
                                                        <h5 class="sub">Fecha</h5>
                                                        <p>Dec 21, 2017</p>
                                                    </div>
                                                    <div class="col-md-4 info-invoice">
                                                        <h5 class="sub">Invoice ID</h5>
                                                        <p>#FDS9876KD</p>
                                                    </div>
                                                    <div class="col-md-4 info-invoice">
                                                        <h5 class="sub">Invoice To</h5>
                                                        <p>
                                                            Jane Smith, 1234 Main, Apt. 4B<br>Springfield, ST 54321
                                                        </p>
                                                    </div>*/ ?>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="invoice-detail">
                                                            <div class="invoice-top">
                                                                <h3 class="title"><strong>Resumen de comisión ( <span id="tipoComisionGlob"></span> ) </strong></h3>
                                                            </div>
                                                            <div class="invoice-item">
                                                                <div class="table-responsive">
                                                                    <table class="table table-striped">
                                                                        <thead>
                                                                            <tr>
                                                                                <td><strong>Empleado</strong></td>
                                                                                <td class="text-center"><strong>Comisiones</strong></td>
                                                                                <td class="text-right"><strong>Total</strong></td>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <tr v-for="row in comisionesGlobal">
                                                                                <td>{{ row.empleado }}</td>
                                                                                <td class="text-center">{{ row.cantidad_comision }}</td>
                                                                                <td class="text-right">{{ row.total_comision }}</td>
                                                                            </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="separator-solid  mb-3"></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-footer">
                                                <div class="row">
                                                    <?php /*
                                                    <div class="col-sm-7 col-md-5 mb-3 mb-md-0 transfer-to">
                                                        <h5 class="sub">Bank Transfer</h5>
                                                        <div class="account-transfer">
                                                            <div><span>Account Name:</span><span>Syamsuddin</span></div>
                                                            <div><span>Account Number:</span><span>1234567890934</span></div>
                                                            <div><span>Code:</span><span>BARC0032UK</span></div>
                                                        </div>
                                                    </div>
                                                    */ ?>
                                                    <div class="col-sm-5 col-md-7 transfer-total">
                                                        <h5 class="sub">Cantidad total</h5>
                                                        <div class="price" id="dataGlobCantidadTotal"></div>
                                                    </div>
                                                </div>
                                                <?php /*
                                                <div class="separator-solid"></div>
                                                <h6 class="text-uppercase mt-4 mb-3 fw-bold">
                                                    Notes
                                                </h6>
                                                <p class="text-muted mb-0">
                                                    We really appreciate your business and if there's anything else we can do, please let us know! Also, should you need us to add VAT or anything else to this order, it's super easy since this is a template, so just ask!
                                                </p> */ ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modal_comision_registro.php'; ?>
    <?php include 'app/notasdeentregaeditar/vista/modal_editar_con_agente.php'; ?>
</div>
<script src="<?= asset('assets/v-money.js') ?>"></script>
<script src="<?= asset('assets/js/plugin/moment/moment.min.js'); ?>"></script>
<script src="<?= asset('assets/vue-the-mask.js') ?>"></script>
<script src="<?= asset('assetsvuejs/empleados/comisiones.js') ?>"></script>