<?php

namespace App\Modelos;

use Core\Database;

class EmpleadoInfo extends Database
{
    protected $table    = 'app_empleados_info';
    protected $id       = 'einfo_id';

    public function empleadoDiferente($condicion)
    {
        return $this->consultar("SELECT * FROM app_empleados_info WHERE $condicion")->all();
    }

    public function empleadoInfo($id)
    {
        return $this->consultar("SELECT * FROM app_empleados_info WHERE einfo_id=$id")->row();
    }

    public function empleadosInfo()
    {
        return $this->consultar('SELECT * FROM app_empleados_info ei 
        LEFT JOIN app_empleados e ON ei.einfo_id = e.emp_edatosid 
        LEFT JOIN app_empleados_sucursales es ON es.empleado_id = e.emp_edatosid 
        LEFT JOIN app_sucursales s ON es.sucursal_id = s.su_id 
        WHERE einfo_id != 1 AND einfo_eliminado != 1')->all();
    }

    public function obtenerEmpleadosInfoId($id_empleado)
    {
        return $this->consultar("SELECT * FROM app_empleados_info aei LEFT JOIN app_empleados ae ON aei.einfo_id=ae.emp_edatosid WHERE einfo_id = $id_empleado")->row();
    }

    public function totalEmpleados()
    {
        return $this->consultar('SELECT * FROM app_empleados_info')->count();
    }
    public function agentesventa()
    { 
        return $this->consultar('SELECT * FROM app_empleados_info WHERE einfo_agente_de_venta=1')->all();
    }
}
