<?php

namespace App\Modelos;

use Core\Database;

class Empleado extends Database
{
    protected $table    = 'app_empleados';
    protected $id       = 'emp_id';

    public function empleadoDiferente($condicion)
    {
        return $this->consultar("SELECT * FROM app_empleados WHERE $condicion")->row();
    }

    public function getUserInfo(string $user)
    {
        return $this->consultar("SELECT * FROM app_empleados WHERE emp_username='$user'")->row();
    }

    public function empleado($id)
    {
        return $this->consultar("SELECT emp_id, emp_edatosid, emp_username, emp_comision_percentaje, emp_tipo, emp_balance, emp_eliminado, emp_estatus,emp_gauth,emp_googlecode FROM app_empleados WHERE emp_edatosid=$id")->row();
    }

    public function empleadosDatosCompletos()
    {
        return $this->consultar('SELECT * FROM app_empleados_info ei JOIN app_empleados e ON ei.einfo_id = e.emp_edatosid JOIN app_empleados_sucursales es ON es.empleado_id = e.emp_edatosid JOIN app_sucursales s ON es.sucursal_id = s.su_id')->all();
    }

    public function empleadosInfo()
    {
        return $this->consultar('SELECT * FROM app_empleados_info ei
        LEFT JOIN app_empleados e ON ei.einfo_id = e.emp_edatosid
        LEFT JOIN app_empleados_sucursales es ON es.empleado_id = e.emp_edatosid
        LEFT JOIN app_sucursales s ON es.sucursal_id = s.su_id
        WHERE einfo_eliminado != 1')->all();
    }

    public function obtenerEmpleadosInfoId($id_empleado)
    {
        return $this->consultar("SELECT * FROM app_empleados_info aei LEFT JOIN app_empleados ae ON aei.einfo_id=ae.emp_edatosid WHERE einfo_id = $id_empleado")->row();
    }

    public function estatus($id_empleado)
    {
        return $this->consultar("SELECT emp_estatus FROM app_empleados WHERE emp_edatosid = $id_empleado")->row();
    }

    public function modificarEstatus($id_empleado, $estatus)
    {
        return $this->consultar("UPDATE app_empleados SET emp_estatus = $estatus WHERE emp_edatosid = $id_empleado")->run();
    }

    public function eliminarEmpleado($id_empleado)
    {
        return $this->consultar("UPDATE app_empleados_info SET einfo_eliminado = 1 WHERE einfo_id = $id_empleado")->run();
    }

    public function eliminarPermiso($emp_id, $id_modulo)
    {
        return $this->consultar("DELETE FROM app_permissions WHERE emp_id=$emp_id AND module_id='$id_modulo'")->run();
    }

    public function guardarPermiso($emp_id, $id_modulo)
    {
        $this->consultar("DELETE FROM app_permissions WHERE emp_id=$emp_id AND module_id='$id_modulo'")->run();
        return $this->consultar("INSERT INTO app_permissions (module_id, emp_id) VALUES ('$id_modulo', $emp_id)")->run();
    }

    public function eliminarPermisoAccion($emp_id, $id_modulo, $id_accion)
    {
        return $this->consultar("DELETE FROM app_permissions_actions WHERE emp_id=$emp_id AND module_id='$id_modulo' AND action_id='$id_accion'")->run();
    }

    public function guardarPermisoAccion($emp_id, $id_modulo, $id_accion)
    {
        $this->consultar("DELETE FROM app_permissions_actions WHERE emp_id=$emp_id AND module_id='$id_modulo' AND action_id='$id_accion'")->run();
        return $this->consultar("INSERT INTO app_permissions_actions (module_id, action_id, emp_id) VALUES ('$id_modulo', '$id_accion', $emp_id)")->run();
    }

    public function getUserPerData($id)
    {
        return $this->consultar("SELECT * FROM app_empleados_info WHERE einfo_id=$id")->row();
    }

    public function obtenerAlamacenes()
    {
        return $this->consultar('SELECT * FROM app_almacenes')->all();
    }

    public function obtenerSeries()
    {
        return $this->consultar("SELECT * FROM app_series se JOIN app_sucursales su ON se.ser_sucursal = su.su_id")->all();
    }

    public function obtenerCuentas()
    {
        return $this->consultar("SELECT bc_id id, bc_cuenta cuenta, bc_alias alias
        FROM app_bancos_cuentas")->all();
    }

    public function obtenerCuentasSegunMetodo(int $id_metodo_divisa)
    {
        return $this->consultar("SELECT cmp_id, bc_cuenta, bc_tipo, bc_alias, b.ban_codigo, b.ban_descripcion
        FROM app_metodopago_divisa md
        JOIN app_cuentas_metodopago cmp ON cmp.cmp_mdid = md.md_id
        JOIN app_bancos_cuentas bc ON bc.bc_id = cmp.cmp_cueid
        JOIN app_bancos b ON b.ban_id = bc.bc_banid
        WHERE cmp.cmp_mdid=$id_metodo_divisa AND ban_estatus = 1 AND cmp_cueid IN (SELECT ec_bcid FROM app_empleados_cuentas WHERE ec_empid = {$_SESSION['user_data']['emp_id']})")->all();
    }
}
