<?php

namespace App\Controladores;

use App\Modelos\Empleado;
use App\Modelos\EmpleadoAlmacen;
use App\Modelos\EmpleadoCuentas;
use App\Modelos\EmpleadoDivisas;
use App\Modelos\EmpleadoInfo;
use App\Modelos\EmpleadoPagina;
use App\Modelos\EmpleadoSerie;
use App\Modelos\EmpleadoAgente;
use App\Modelos\Comisiones;
use App\Modelos\EmpleadoComisionAgente;
use App\Modelos\EmpleadoComisionDocumento;
use App\Modelos\EmpleadosComisionesEmplAgente;
use App\Modelos\EmpleadoSucursales;
use App\Modelos\Empresa;
use App\Modelos\Ingresosegresos;
use App\Modelos\MetodoPago;
use App\Modelos\MovimientoModel;
use App\Modelos\Notasdeentrega;
use App\Modelos\Ordendeentrega;
use App\Modelos\Pos;
use App\Modelos\Sucursal;
use Core\Controller;
use Core\Helpers\Documento;
use Core\Helpers\Moneda;
use Core\Librerias\GoogleAuthenticator;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Librerias\ModuleAction;
use Core\Vista;
use Verot\Upload\Upload;
use DateTime;

final class EmpleadosControlador extends Controller
{
    private $moduleAction;
    private $module;
    private $empleado;
    private $empleado_info;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->module           = new Module('empleados');
        $this->empleado         = new Empleado();
        $this->empleado_info    = new EmpleadoInfo();
        $this->moduleAction     = new ModuleAction();
    }

    public function index()
    {
        return Vista::view('empleados/index');
    }

    public function obtenerEmpleados()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response($this->empleado_info->empleadosInfo());
        }
    }

    public function guardarEmpleadoInfo()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'crear', $_SESSION['user_data']['emp_id'])) {

                $einfo_id               = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                $einfo_nombres          = filter_input(INPUT_POST, 'nombres', FILTER_SANITIZE_STRING);
                $einfo_apellidos        = filter_input(INPUT_POST, 'apellidos', FILTER_SANITIZE_STRING);
                $einfo_telefono_movil   = filter_input(INPUT_POST, 'telefono', FILTER_SANITIZE_STRING);
                $einfo_direccion_1      = filter_input(INPUT_POST, 'direccion_uno', FILTER_SANITIZE_STRING);
                $einfo_direccion_2      = filter_input(INPUT_POST, 'direccion_dos', FILTER_SANITIZE_STRING);
                $einfo_ciudad           = filter_input(INPUT_POST, 'ciudad', FILTER_SANITIZE_STRING);
                $einfo_estado           = filter_input(INPUT_POST, 'estado', FILTER_SANITIZE_STRING);
                $einfo_email            = filter_input(INPUT_POST, 'correo', FILTER_SANITIZE_EMAIL);
                $einfo_agente_de_venta  = ('true' == filter_input(INPUT_POST, 'agente_de_venta')) ? 1 : 0;

                if (empty($einfo_nombres))
                    $this->array_errors[] = "El campo Nombre es obligatorio.";
                if (empty($einfo_apellidos))
                    $this->array_errors[] = "El campo Apellidos obligatorio.";
                if (empty($einfo_telefono_movil))
                    $this->array_errors[] = "El campo Telefono movil es obligatorio.";
                if (empty($einfo_direccion_1))
                    $this->array_errors[] = "El campo Dirección es obligatorio.";
                if (empty($einfo_email))
                    $this->array_errors[] = "El campo Correo es obligatorio.";

                if (empty($this->array_errors)) {

                    $data_form = [
                        'einfo_nombres'         => $einfo_nombres,
                        'einfo_apellidos'       => $einfo_apellidos,
                        'einfo_telefono_movil'  => $einfo_telefono_movil,
                        'einfo_direccion_1'     => $einfo_direccion_1,
                        'einfo_direccion_2'     => $einfo_direccion_2,
                        'einfo_ciudad'          => $einfo_ciudad,
                        'einfo_estado'          => $einfo_estado,
                        'einfo_email'           => $einfo_email,
                        'einfo_eliminado'       => 0,
                        'einfo_agente_de_venta' => $einfo_agente_de_venta
                    ];

                    if (empty($einfo_id)) {

                        if ($this->empleado_info->where(['einfo_email' => $einfo_email])) {
                            $this->array_errors[] = "El correo $einfo_email ya se encuentra en uso por otro empleado";
                        }

                        if (empty($this->array_errors)) {
                            Http::json_response($this->empleado_info->guardar($data_form, true));
                        }
                    } else {

                        $where_correo = "einfo_email='$einfo_email' and einfo_id!=$einfo_id";

                        if ($this->empleado_info->empleadoDiferente($where_correo)) {
                            $this->array_errors[] = "El correo $einfo_email ya se encuentra en uso por otro empleado";
                        }

                        if (empty($this->array_errors)) {
                            Http::json_response($this->empleado_info->editar($einfo_id, $data_form));
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para crear empleados.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function modificarEstatus()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'editar', $_SESSION['user_data']['emp_id'])) {

                $id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);

                if ($this->empleado_info->existe('einfo_id', $id)) {

                    $estatus = $this->empleado->estatus($id);

                    if ($estatus['emp_estatus']) {
                        Http::json_response($this->empleado->modificarEstatus($id, 0));
                    } else {
                        Http::json_response($this->empleado->modificarEstatus($id, 1));
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para actualizar datos de empleados.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarSeleccionComision(){

        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'eliminar_comision', $_SESSION['user_data']['emp_id'])) {

                $newAgent = new EmpleadoComisionAgente();

                $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);

                if ($newAgent->existe('empagentipo_id', $id)) {

                    Http::json_response($newAgent->eliminarComision($id));
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para eliminar comisiones.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarEmpleado()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'eliminar', $_SESSION['user_data']['emp_id'])) {

                $id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);

                if ($this->empleado_info->existe('einfo_id', $id)) {

                    Http::json_response($this->empleado->eliminarEmpleado($id));
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para eliminar empleados.';
            }

            Http::json_response(false);
        }
    }

    public function ver(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {

            $divisas = $this->empleado->consultar('SELECT * FROM app_divisas WHERE div_status = 1')->all();

            $sucursales = new Sucursal();
            $empresa=new Empresa();
            $empre=$empresa->obtener(1);

            if ($_SESSION['user_data']['einfo_id'] == 1) {
                if ($this->empleado_info->existe('einfo_id', $id)) {
                    if ($_SESSION['user_data']['einfo_id'] == $id || $_SESSION['user_data']['einfo_id'] == 1) {
                        return Vista::view('empleados/ver', [
                            'divisas' => $divisas,
                            'emp_id' => $id,
                            'cuentas' =>  $this->empleado->obtenerCuentas(),
                            'almacenes' => $this->empleado->obtenerAlamacenes(),
                            'series' => $this->empleado->obtenerSeries(),
                            'sucursales' => $sucursales->todos(),
                            'google'=>$empre['emp_googleauth']
                        ]);
                    }
                } else {
                    Http::notFound();
                }
            } else {
                if ($_SESSION['user_data']['einfo_id'] != 1 && $id == 1) {
                    Http::exit_by_forbiden();
                } else {
                    if ($_SESSION['user_data']['einfo_id'] != 1 && $id != 1) {
                        if ($this->empleado_info->existe('einfo_id', $id)) {
                            return Vista::view('empleados/ver', [
                                'divisas' => $divisas,
                                'emp_id' => $id,
                                'cuentas' =>  $this->empleado->obtenerCuentas(),
                                'almacenes' => $this->empleado->obtenerAlamacenes(),
                                'series' => $this->empleado->obtenerSeries(),
                                'sucursales' => $sucursales->todos(),
                                'google'=>$empre['emp_googleauth']
                            ]);
                        } else {
                            Http::notFound();
                        }
                    }
                }
            }
        }
    }

    public function comisiones()
    {
        $obtener_agente = new EmpleadoInfo();
        $obtener_comisiones = new Comisiones();

        return Vista::view('empleados/comisiones', [
            'divisas'       => Moneda::obtenerDivisas(),
            'agentes'       => $obtener_agente->agentesventa(),
            'comisiones'    => $obtener_comisiones->todos(),
        ]);
    }

    public function obtenerEmpleado(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = $this->getEmpleado($id);

            if ($data) {

                if ($_SESSION['user_data']['einfo_id'] == 1) {
                    Http::json_response([
                        'info' => $data['info'],
                        'user' => $data['user'],
                        'permisos' => $data['permisos'],
                        'pagina' => $data['pagina']
                    ]);
                } else {
                    if ($_SESSION['user_data']['einfo_id'] != 1 && $id == 1) {
                        Http::exit_by_forbiden();
                    } else {
                        if ($_SESSION['user_data']['einfo_id'] != 1 && $id != 1) {
                            Http::json_response([
                                'info' => $data['info'],
                                'user' => $data['user'],
                                'permisos' => $data['permisos'],
                                'pagina' => $data['pagina']
                            ]);
                        }
                    }
                }
            } else {
                Http::json_response(false);
            }
        }
    }

    private function getEmpleado(int $id)
    {
        if ($this->empleado_info->existe('einfo_id', $id)) {

            $empleado_id = $this->empleado->empleado($id);
            $modulos = $this->module->getAllModules();
            $array_modulos = [];

            foreach ($modulos as $row) {

                if (!$empleado_id) {
                    $permiso = false;
                } else {
                    $permiso = $this->module->has_module_permission($row['module_id'], $empleado_id['emp_id']);
                }

                $acciones = $this->moduleAction->getModuleActions($row['module_id']);
                $array_acciones = [];

                if (is_countable($acciones) && count($acciones)) {

                    foreach ($acciones as $accion) {

                        if (!$empleado_id) {
                            $permiso_accion = false;
                        } else {
                            $permiso_accion = $this->module->has_module_action_permission($row['module_id'], $accion['action_id'], $empleado_id['emp_id']);
                        }

                        $array_acciones[] = [
                            'id' => $accion['action_id'],
                            'modulo' => $accion['module_id'],
                            'nombre' => $accion['action_name_key'],
                            'permiso' => $permiso_accion
                        ];
                    }
                }

                $array_modulos[] = [
                    'id' => $row['module_id'],
                    'icon' => $row['icon'],
                    'nombre' => $row['name_lang_key'],
                    'permiso' => $permiso,
                    'acciones' => $array_acciones
                ];
            }

            $pagina = '';

            if ($empleado_id) {
                $data_pagina = $this->empleado->consultar("SELECT * FROM app_empleado_pagina WHERE ep_empid =  {$empleado_id['emp_id']}")->row();
                if ($data_pagina) {
                    $pagina = $data_pagina['ep_modulo'];
                }
            }

            return [
                'info' => $this->empleado_info->empleadoInfo($id),
                'user' => $empleado_id,
                'permisos' => $array_modulos,
                'pagina' => $pagina
            ];
        }
    }

    public function guardarUsuario()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'editar', $_SESSION['user_data']['emp_id'])) {

                $emp_id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                $emp_edatosid   = filter_input(INPUT_POST, 'emp_edatosid', FILTER_SANITIZE_NUMBER_INT);
                $emp_username   = filter_input(INPUT_POST, 'nombre', FILTER_SANITIZE_STRING);
                $emp_password   = filter_input(INPUT_POST, 'password', FILTER_SANITIZE_STRING);
                $repassword     = filter_input(INPUT_POST, 'repassword', FILTER_SANITIZE_STRING);
                $obrero  = ('true' == filter_input(INPUT_POST, 'obrero')) ? 'OBRERO' : NULL;

                if ($this->empleado_info->existe('einfo_id', $emp_edatosid)) {

                    if (empty($emp_username))
                        $this->array_errors[] = "El campo Nombre de usuario es requerido";
                    if (empty($emp_password))
                        $this->array_errors[] = "El campo Contraseña es requerido";
                    if (empty($repassword))
                        $this->array_errors[] = "El campo Re-Contraseña es requerido";

                    if (empty($this->array_errors)) {

                        $emp_username = $this->solicitud->sanitize($emp_username, FILTER_SANITIZE_STRING);
                        $emp_password = $this->solicitud->sanitize($emp_password, FILTER_SANITIZE_STRING);

                        if ($emp_password !== $repassword)
                            $this->array_errors[] = "Las contraseñas no coninciden.";

                        if (empty($this->array_errors)) {

                            if ($this->empleado->existe('emp_id', $emp_id)) {
                                Http::json_response($this->empleado->editar($emp_id, [
                                    'emp_username' => trim($emp_username),
                                    'emp_password' => password_hash(trim($emp_password), PASSWORD_BCRYPT),
                                    'emp_tipo'     => $obrero
                                ]));
                            } else {
                                Http::json_response($this->empleado->guardar([
                                    'emp_edatosid' => $emp_edatosid,
                                    'emp_username' => trim($emp_username),
                                    'emp_password' => password_hash(trim($emp_password), PASSWORD_BCRYPT),
                                    'emp_tipo'     => $obrero
                                ], true));
                            }
                        }
                    }

                    $data['errors'] = $this->array_errors;
                    Http::json_response($data);
                } else {
                    Http::json_response(false);
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para actualizar datos de empleados.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function permitirModulo()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'permisos', $_SESSION['user_data']['emp_id']) || $_SESSION['user_data']['einfo_id'] == 1) {

                $id_empleado    = filter_input(INPUT_POST, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);
                $id_module      = filter_input(INPUT_POST, 'id_modulo', FILTER_SANITIZE_STRING);
                $permiso        = filter_input(INPUT_POST, 'permiso') ?? 'true';

                if ($this->empleado->existe('emp_id', $id_empleado)) {
                    if (!empty($id_module)) {
                        if ($permiso == 'true') {
                            Http::json_response($this->empleado->guardarPermiso($id_empleado, $id_module));
                        } else {
                            Http::json_response($this->empleado->eliminarPermiso($id_empleado, $id_module));
                        }
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    $this->array_errors[] = "Debe crearle al empleado un usuario de acceso para poder asignarle modulos";
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para activar modulos.';
            }

            $data['errors'] = $this->array_errors;
            Http::json_response($data);
        }
    }

    public function permitirModuloAcciones()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'permisos', $_SESSION['user_data']['emp_id']) || $_SESSION['user_data']['einfo_id'] == 1) {

                $id_empleado    = filter_input(INPUT_POST, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);
                $id_module      = filter_input(INPUT_POST, 'id_modulo', FILTER_SANITIZE_STRING);
                $id_accion      = filter_input(INPUT_POST, 'id_accion', FILTER_SANITIZE_STRING);
                $permiso        = filter_input(INPUT_POST, 'permiso') ?? 'true';

                if ($this->empleado->existe('emp_id', $id_empleado)) {
                    if (!empty($id_module) && !empty($id_accion)) {
                        if ($permiso == 'true') {
                            Http::json_response($this->empleado->guardarPermisoAccion($id_empleado, $id_module, $id_accion));
                        } else {
                            Http::json_response($this->empleado->eliminarPermisoAccion($id_empleado, $id_module, $id_accion));
                        }
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    $this->array_errors[] = "Debe crearle al empleado un usuario de acceso para poder asignarle almacenes";
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para activar modulos.';
            }

            $data['errors'] = $this->array_errors;
            Http::json_response($data);
        }
    }

    public function obtenerEmpleadoSeries()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_empleado = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);

            if ($this->empleado->existe('emp_id', $id_empleado)) {

                $empleado_serie_model = new EmpleadoSerie();

                Http::json_response($empleado_serie_model->obtenerSeries($id_empleado));
            }

            Http::json_response(false);
        }
    }

    public function obtenerEmpleadoSucursales()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_empleado = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);

            if ($this->empleado->existe('emp_id', $id_empleado)) {

                $empleado_sucursales_model = new EmpleadoSucursales();

                Http::json_response($empleado_sucursales_model->obtenerSucursales($id_empleado));
            }

            Http::json_response(false);
        }
    }

    public function guardarSerie()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'series', $_SESSION['user_data']['emp_id'])) {

                $id_empleado   = filter_input(INPUT_POST, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);
                $id_serie      = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_NUMBER_INT);

                if ($this->empleado->existe('emp_id', $id_empleado)) {

                    $empleado_serie_model = new EmpleadoSerie();
                    $empleado_sucursales = new EmpleadoSucursales();

                    if (!empty($id_serie)) {

                        $serie = $empleado_serie_model->consultar("SELECT * FROM app_series WHERE ser_id=$id_serie")->row();
                        $empleado_sucursal = $empleado_sucursales->existeSucursal($id_empleado, $serie['ser_sucursal']);

                        if ($empleado_sucursal) {
                            $empleado_serie = $empleado_serie_model->existeSerie($id_empleado, $id_serie);
                            if (!$empleado_serie) {
                                Http::json_response($empleado_serie_model->guardar([
                                    'empser_serid' => $id_serie,
                                    'empser_empid' => $id_empleado
                                ], true));
                            } else {
                                $this->array_errors[] = "Serie ya registrada.";
                            }
                        } else {
                            $this->array_errors[] = "Debe agregarle al empleado la sucursal parar poder asignarle esta serie";
                        }
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    $this->array_errors[] = "Debe crearle al empleado un usuario de acceso para poder asignarle almacenes";
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para asignar series.';
            }

            Http::json_response([
                'errors' => $this->array_errors
            ]);
        }
    }

    public function guardarSucursal()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'sucursales', $_SESSION['user_data']['emp_id'])) {

                $id_empleado   = filter_input(INPUT_POST, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);
                $id_sucursal      = filter_input(INPUT_POST, 'sucursales', FILTER_SANITIZE_NUMBER_INT);

                if ($this->empleado->existe('emp_id', $id_empleado)) {

                    $empleado_sucursales_model = new EmpleadoSucursales();

                    if (!empty($id_sucursal)) {

                        $empleado_sucursales = $empleado_sucursales_model->existeSucursal($id_empleado, $id_sucursal);

                        if (!$empleado_sucursales) {
                            Http::json_response($empleado_sucursales_model->guardar([
                                'empleado_id' => $id_empleado,
                                'sucursal_id' => $id_sucursal
                            ], true));
                        } else {
                            $this->array_errors[] = "Sucursal ya registrada.";
                        }
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    $this->array_errors[] = "Debe crearle al empleado un usuario de acceso para poder asignarle almacenes";
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para asignar sucursales.';
            }

            Http::json_response([
                'errors' => $this->array_errors
            ]);
        }
    }

    public function obtenerEmpleadoAlmacenes()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_empleado = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);

            if ($this->empleado->existe('emp_id', $id_empleado)) {

                $empleado_almacen_model = new EmpleadoAlmacen();

                Http::json_response($empleado_almacen_model->obtenerAlmacenes($id_empleado));
            }

            Http::json_response(false);
        }
    }

    public function guardarAlmacen()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'almacenes', $_SESSION['user_data']['emp_id'])) {

                $id_empleado    = filter_input(INPUT_POST, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);
                $id_almacen     = filter_input(INPUT_POST, 'almacen', FILTER_SANITIZE_NUMBER_INT);

                if ($this->empleado->existe('emp_id', $id_empleado)) {

                    $empleado_almacen_model = new EmpleadoAlmacen();

                    if (!empty($id_almacen)) {

                        $empleado_almacen = $empleado_almacen_model->existeAlmacen($id_empleado, $id_almacen);

                        if (!$empleado_almacen) {
                            Http::json_response($empleado_almacen_model->guardar([
                                'empalm_almid' => $id_almacen,
                                'empalm_empid' => $id_empleado
                            ], true));
                        } else {
                            $this->array_errors[] = "Almacen ya registrado.";
                        }
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    $this->array_errors[] = "Debe crearle al empleado un usuario de acceso para poder asignarle almacenes";
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para asignar almacenes.';
            }

            Http::json_response([
                'errors' => $this->array_errors
            ]);
        }
    }

    public function eliminarAlmacen()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'almacenes', $_SESSION['user_data']['emp_id'])) {

                $id_empleado    = filter_input(INPUT_GET, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);
                $id_almacen     = filter_input(INPUT_GET, 'id_almacen', FILTER_SANITIZE_NUMBER_INT);

                if ($this->empleado->existe('emp_id', $id_empleado)) {

                    $empleado_almacen_model = new EmpleadoAlmacen();

                    if (!empty($id_almacen)) {
                        $empleado_almacen = $empleado_almacen_model->existe('empalm_id', $id_almacen);
                        if ($empleado_almacen) {
                            Http::json_response($empleado_almacen_model->eliminar($id_almacen));
                        } else {
                            $this->array_errors[] = "Almacen no encontrado.";
                        }
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    $this->array_errors[] = "Debe crearle al empleado un usuario de acceso para poder asignarle almacenes";
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para eliminar almacenes.';
            }

            Http::json_response([
                'errors' => $this->array_errors
            ]);
        }
    }

    public function eliminarSerie()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'series', $_SESSION['user_data']['emp_id'])) {

                $id_empleado    = filter_input(INPUT_GET, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);
                $id_serie       = filter_input(INPUT_GET, 'id_serie', FILTER_SANITIZE_NUMBER_INT);

                if ($this->empleado->existe('emp_id', $id_empleado)) {

                    $empleado_serie_model = new EmpleadoSerie();

                    if (!empty($id_serie)) {
                        $empleado_serie = $empleado_serie_model->existe('empser_id', $id_serie);
                        if ($empleado_serie) {
                            Http::json_response($empleado_serie_model->eliminar($id_serie));
                        } else {
                            $this->array_errors[] = "Serie no encontrado.";
                        }
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    $this->array_errors[] = "Debe crearle al empleado un usuario de acceso para poderle asignar una serie.";
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para eliminar series.';
            }

            Http::json_response([
                'errors' => $this->array_errors
            ]);
        }
    }

    public function predeterminadoSucursal()
    {

        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);
            $empleado = filter_input(INPUT_GET, 'empleado', FILTER_SANITIZE_NUMBER_INT);

            $empleado_sucursales = new EmpleadoSucursales();

            $sucursal=$empleado_sucursales->consultar("SELECT * FROM app_empleados_sucursales WHERE empleado_id=$empleado AND sucursal_id=$id")->row();
            if ($sucursal) {

                $sucursales = $empleado_sucursales->obtenerSucursales($empleado);

                foreach ($sucursales as $row) {
                    if ($row['sucursal_id'] == $id) {
                        $empleado_sucursales->editar($row['empsuc_id'], [
                            'sucursal_predeterminado' => ($sucursal['sucursal_predeterminado']==1) ? 0 : 1
                        ]);
                    } else {
                        $empleado_sucursales->editar($row['empsuc_id'], [
                            'sucursal_predeterminado' => 0
                        ]);
                    }
                }

                Http::json_response(true);
            }

            Http::json_response(false);
        }
    }

    public function predeterminadoSerie()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);
            $empleado = filter_input(INPUT_GET, 'empleado', FILTER_SANITIZE_NUMBER_INT);

            $empleado_series = new EmpleadoSerie();

            $serie=$empleado_series->consultar("SELECT * FROM app_empleados_serie WHERE empser_empid=$empleado AND empser_serid=$id")->row();
            
            if ($serie) {

                $series = $empleado_series->obtenerSeries($empleado);

                foreach ($series as $row) {
                    if ($row['empser_serid'] == $id) {
                        $empleado_series->editar($row['empser_id'], [
                            'empser_predeterminado' => ($serie['empser_predeterminado']==1) ? 0 : 1
                        ]);
                    } else {
                        $empleado_series->editar($row['empser_id'], [
                            'empser_predeterminado' => 0
                        ]);
                    }
                }

                Http::json_response(true);
            }

            Http::json_response(false);
        }
    }

    public function predeterminadoAlmacen()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);
            $empleado = filter_input(INPUT_GET, 'empleado', FILTER_SANITIZE_NUMBER_INT);
    
            $empleado_almacen = new EmpleadoAlmacen();
    
            $almacen=$empleado_almacen->consultar("SELECT * FROM app_empleados_almacen WHERE empalm_almid=$id AND empalm_empid=$empleado")->row();
            
            if ($almacen) {
    
                $almacenes = $empleado_almacen->obtenerAlmacenes($empleado);
    
                foreach ($almacenes as $row) {
                    if ($row['empalm_almid'] == $id) {
                        $empleado_almacen->editar($row['empalm_id'], [
                            'empalm_predeterminado' => ($almacen['empalm_predeterminado']==1) ? 0 : 1
                        ]);
                    } else {
                        $empleado_almacen->editar($row['empalm_id'], [
                            'empalm_predeterminado' => 0
                        ]);
                    }
                }
    
                Http::json_response(true);
            }
    
            Http::json_response(false);
        }
    }

    public function eliminarSucursales()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'sucursales', $_SESSION['user_data']['emp_id'])) {

                $id_empleado    = filter_input(INPUT_GET, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);
                $id_sucursal       = filter_input(INPUT_GET, 'id_sucursal', FILTER_SANITIZE_NUMBER_INT);

                if ($this->empleado->existe('emp_id', $id_empleado)) {

                    $empleado_sucursal_model = new EmpleadoSucursales();

                    if (!empty($id_sucursal)) {
                        $empleado_sucursal = $empleado_sucursal_model->existe('empsuc_id', $id_sucursal);
                        if ($empleado_sucursal) {
                            Http::json_response($empleado_sucursal_model->eliminar($id_sucursal));
                        } else {
                            $this->array_errors[] = "Sucursal no encontrado.";
                        }
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    $this->array_errors[] = "Debe crearle al empleado un usuario de acceso para poderle asignar una sucursal.";
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para eliminar Sucursales.';
            }

            Http::json_response([
                'errors' => $this->array_errors
            ]);
        }
    }

    public function guardarCuentas()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'cuentas', $_SESSION['user_data']['emp_id'])) {

                $id_empleado   = filter_input(INPUT_POST, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);
                $id_cuenta     = filter_input(INPUT_POST, 'cuenta', FILTER_SANITIZE_NUMBER_INT);

                if ($this->empleado->existe('emp_id', $id_empleado)) {

                    $empleado_cuentas_model = new EmpleadoCuentas();

                    if (!empty($id_cuenta)) {

                        $empleado_cuenta = $empleado_cuentas_model->existeCuenta($id_empleado, $id_cuenta);

                        if (!$empleado_cuenta) {
                            Http::json_response($empleado_cuentas_model->guardar([
                                'ec_bcid' => $id_cuenta,
                                'ec_empid' => $id_empleado
                            ], true));
                        } else {
                            $this->array_errors[] = "Cuenta ya registrada.";
                        }
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    $this->array_errors[] = "Debe crearle al empleado un usuario de acceso para poder asignarle almacenes";
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para asignar cuentas.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerEmpleadoCuentas(int $id_empleado)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_empleado = filter_var($id_empleado, FILTER_SANITIZE_NUMBER_INT);

            if ($this->empleado->existe('emp_id', $id_empleado)) {

                $empleado_cuentas_model = new EmpleadoCuentas();
                Http::json_response($empleado_cuentas_model->obtenerCuentas($id_empleado));
            }
        }
    }

    public function eliminarCuenta(int $id_cuenta)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'cuentas', $_SESSION['user_data']['emp_id'])) {

                $id_cuenta = filter_var($id_cuenta, FILTER_SANITIZE_NUMBER_INT);

                $empleado_cuentas_model = new EmpleadoCuentas();

                if ($empleado_cuentas_model->existe('ec_id', $id_cuenta)) {
                    Http::json_response($empleado_cuentas_model->eliminar($id_cuenta));
                } else {
                    $this->array_errors[] = "Cuenta no encontrado.";
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para eliminar cuentas.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function imagenPerfil()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_empleado = filter_input(INPUT_POST, 'id_empleado', FILTER_SANITIZE_NUMBER_INT);

            if ($this->empleado_info->existe('einfo_id', $id_empleado)) {

                $empleado = $this->empleado_info->obtener($id_empleado);

                if (empty($_FILES['imagen']))
                    $this->array_errors[] = "La imagen es obligatorio.";

                if (empty($this->array_errors)) {

                    $fileTmpPath    = $_FILES['imagen']['tmp_name'];
                    $fileName       = $_FILES['imagen']['name'];
                    $fileSize       = $_FILES['imagen']['size'];
                    $extenciones    = array('jpg', 'jpeg', 'png', 'gif');

                    if ($_FILES['imagen']['error'] === UPLOAD_ERR_OK) {

                        $handle = new Upload($_FILES['imagen']);

                        $fileNameCmps = explode(".", basename($_FILES['imagen']['name']));
                        $fileExtension = strtolower(end($fileNameCmps));

                        if ($fileSize < 1048576) {

                            if (in_array($fileExtension, $extenciones)) {

                                if ($handle->uploaded) {

                                    $handle->file_new_name_body = 'emp' . $empleado['einfo_id'];
                                    $file_img                   = 'emp' . $empleado['einfo_id'] . '.gif';
                                    $handle->image_resize       = true;
                                    $handle->image_convert      = 'gif';
                                    $handle->image_x            = 150;
                                    $handle->image_ratio_y      = true;

                                    if (file_exists(constant('UPLOADS_URI') . 'empleados/' . $file_img)) {
                                        unlink(constant('UPLOADS_URI') . 'empleados/' . $file_img);
                                    }

                                    $handle->process(constant('UPLOADS_URI') . 'empleados');

                                    if ($handle->processed) {
                                        if ($this->empleado_info->editar($id_empleado, [
                                            'einfo_imagen' => $file_img
                                        ], true)) {
                                            $_SESSION['user_data']['einfo_imagen'] = $file_img;
                                            Http::json_response(true);
                                        } else {
                                            unlink(constant('UPLOADS_URI') . 'empleados/' . $file_img);
                                            $this->array_errors[] = "Se produjo un error al cargar el archivo";
                                        }
                                        $handle->clean();
                                    } else {
                                        $this->array_errors[] = "Se produjo un error al d el archivo";
                                    }
                                }
                            } else {
                                $this->array_errors[] = "Solo archivos con formato PNG, JPG, JPEG, o GIF";
                            }
                        } else {
                            $this->array_errors[] = "EL archivo supera el limite de 1MB";
                        }
                    } else {
                        $this->array_errors[] = "EL archivo supera el limite de 1MB";
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerPermisosDeInicio(int $id_empleado)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $array_modulos = [];

            if (!empty($id_empleado) && $this->empleado->existe('emp_id', $id_empleado)) {
                $modulos = $this->module->getAllModules();

                $array_modulos[]=[
                    'id' => 'miperfil',
                    'icon' =>'ds',
                    'descripcion' => 'Perfil'
                ];

                foreach ($modulos as $row) {

                    if ($this->module->has_module_permission($row['module_id'], $id_empleado)) {

                        $array_modulos[] = [
                            'id' => $row['module_id'],
                            'icon' => $row['icon'],
                            'descripcion' => $row['name_lang_key']
                        ];
                    }
                }
            }

            Http::json_response($array_modulos);
        }
    }

    public function establecerPaginaDeInicio()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'permisos', $_SESSION['user_data']['emp_id'])) {

                if (!empty($_GET['id_empleado'])) {

                    $id_modulo = $this->solicitud->sanitize($_GET['id_modulo'], FILTER_SANITIZE_STRING);
                    $id_empleado = $this->solicitud->sanitize($_GET['id_empleado'], FILTER_SANITIZE_NUMBER_INT);

                    if ($this->empleado->existe('emp_id', $id_empleado)) {

                        $newEmpPag = new EmpleadoPagina();

                        if (empty($_GET['id_modulo'])) {
                            $res = $newEmpPag->consultar("DELETE FROM app_empleado_pagina WHERE ep_empid = $id_empleado")->run();
                            Http::json_response($res);
                        } else {

                            $data_modulo = $this->module->getModuleName($id_modulo);

                            if ($data_modulo) {

                                $existe = $newEmpPag->consultar("SELECT * FROM app_empleado_pagina WHERE ep_empid = $id_empleado")->row();

                                if ($existe) {
                                    $res = $newEmpPag->consultar("UPDATE app_empleado_pagina SET ep_modulo = '$id_modulo' WHERE ep_empid = $id_empleado")->run();
                                } else {
                                    $res = $newEmpPag->guardar([
                                        'ep_empid' => $id_empleado,
                                        'ep_modulo' => $id_modulo
                                    ]);
                                }

                                Http::json_response($res);
                            }else{
                                if($id_modulo=='miperfil'){
                                    $existe = $newEmpPag->consultar("SELECT * FROM app_empleado_pagina WHERE ep_empid = $id_empleado")->row();
                                    if ($existe) {
                                        $res = $newEmpPag->consultar("UPDATE app_empleado_pagina SET ep_modulo = '$id_modulo' WHERE ep_empid = $id_empleado")->run();
                                    } else {
                                        $res = $newEmpPag->guardar([
                                            'ep_empid' => $id_empleado,
                                            'ep_modulo' => $id_modulo
                                        ]);
                                    }
                                    Http::json_response($res);
                                }
                            }
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para asignar pagina de inicio.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerDivisas(int $id_empleado)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_empleado = filter_var($id_empleado, FILTER_SANITIZE_NUMBER_INT);
            $newED = new EmpleadoDivisas();
            Http::json_response($newED->obtenerDivisasDiferenteEmpleado($id_empleado));
        }
    }

    public function obtenerDivisasEmpleado(int $id_empleado)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_empleado = filter_var($id_empleado, FILTER_SANITIZE_NUMBER_INT);
            $newED = new EmpleadoDivisas();
            Http::json_response($newED->obtenerDivisasEmpleado($id_empleado));
        }
    }

    public function establecerDivisa()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('empleados', 'permisos', $_SESSION['user_data']['emp_id'])) {

                if (!empty($_GET['id_empleado'])) {

                    $id_divisa = $_GET['id_divisa'] ? $_GET['id_divisa'] : NULL;
                    $id_empleado = $this->solicitud->sanitize($_GET['id_empleado'], FILTER_SANITIZE_NUMBER_INT);

                    if ($this->empleado->existe('emp_id', $id_empleado)) {

                        $newED = new EmpleadoDivisas();

                        $existe = $newED->consultar("SELECT * FROM app_empleados_divisas WHERE ed_empid = $id_empleado AND ed_divid = $id_divisa")->row();

                        if ($existe) {
                            $this->array_errors[] = 'Acción prohibida';
                        } else {
                            Http::json_response($newED->guardar([
                                'ed_empid' => $id_empleado,
                                'ed_divid' => $id_divisa
                            ], true));
                        }
                    }
                } else {
                    Http::json_response(false);
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarDivisa(int $id_divisa)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            if ($this->module->has_module_action_permission('empleados', 'permisos', $_SESSION['user_data']['emp_id'])) {
                $newED = new EmpleadoDivisas();
                Http::json_response($newED->eliminar($id_divisa));
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerClienteAgente(int $id_empleado)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newcli = new EmpleadoAgente();

            if ($newcli->existe('empagent_empid', $id_empleado)) {
                Http::json_response($newcli->obtenerClienteAgente($id_empleado));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function eliminarCliente(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newAgent = new EmpleadoAgente();

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($newAgent->existe('empagent_clientid', $id)) {
                Http::json_response($newAgent->eliminarAgente($id));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function obtenerComisionesId()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $fecha_desde    = filter_input(INPUT_POST, 'fecha_desde', FILTER_SANITIZE_STRING);
            $fecha_hasta    = filter_input(INPUT_POST, 'fecha_hasta', FILTER_SANITIZE_STRING);
            $select_doc     = filter_input(INPUT_POST, 'documento', FILTER_SANITIZE_STRING);
            $estatus        = filter_input(INPUT_POST, 'estatus', FILTER_SANITIZE_NUMBER_INT);
            $agente         = filter_input(INPUT_POST, 'agente', FILTER_SANITIZE_NUMBER_INT);
            $id_comision    = filter_input(INPUT_POST, 'comision', FILTER_SANITIZE_NUMBER_INT);
            $id_divisa      = filter_input(INPUT_POST, 'divisa', FILTER_SANITIZE_NUMBER_INT);

            if (empty($id_divisa))
                Http::json_response(['errors' => ['La divisa es obligatoria']]);

            if (empty($fecha_desde))
                $fecha_desde = (new DateTime())->modify('first day of this month')->format('Y-m-d');

            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (empty($this->array_errors)) {

                if (!validateDate($fecha_desde, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha desde es incorrecta.';
                if (!validateDate($fecha_hasta, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha hasta es incorrecta.';

                Http::json_response($this->obtenerComisionesIndividuales($fecha_desde, $fecha_hasta, $id_divisa, $id_comision, $estatus, $select_doc, $agente));
            } else {
                Http::json_response(['errors' => $this->array_errors]);
            }
        } else {
            Http::json_response('Error');
        }
    }
    public function obtenerComisionesIndividuales(string $fecha_desde, string $fecha_hasta, int $id_divisa, int $id_comision, int $estatus, String $select_doc, int $agente)
    {
        $newCom = new EmpleadosComisionesEmplAgente();
        $divisa = Moneda::obtenerDivisa($id_divisa);

        $array_total = [];
        $total_pagada = 0;
        $total_pendiente = 0;

        if ($estatus == 2) {
            $estatusText = 'todas';
        } else {
            $estatusText = $estatus == 1 ? 'pagadas' : 'pendientes';
        }

        if (!empty($id_comision)) {

            $data_comision = $newCom->consultar("SELECT * FROM app_comision WHERE com_id = $id_comision")->row();
            $tipo_comision = $data_comision['com_descripcion'];

            if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && !empty($agente)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
            }

            $facturas = $newCom->obtenerComisionesFacturasId($where_f);
            $notas = $newCom->obtenerComisionesNotasId($where_n);
            $ordenes = $newCom->obtenerComisionesOrdenesId($where_o);
        } else {

            $tipo_comision = 'Todas';

            if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
            }

            $facturas = $newCom->obtenerComisionesFacturasId($where_f);
            $notas = $newCom->obtenerComisionesNotasId($where_n);
            $ordenes = $newCom->obtenerComisionesOrdenesId($where_o);
        }

        if (is_countable($notas) && count($notas)) {

            $documento = $newCom->obtenerDocumento(1);

            foreach ($notas as $row) {

                if ($row['comagentefn_estatus'] == 0) {
                    $total_pendiente += $row['comagentefn_monto'];
                } else {
                    $total_pagada += $row['comagentefn_monto'];
                }

                $array_total[] = [
                    'id'              => $row['comagentefn_id'],
                    'com_descripcion' => $row['com_descripcion'],
                    'uri'             => ruta_base() .  'notasdeentregaeditar/verFactura/' . $row['ne_id'],
                    'agente'          => $row['einfo_nombres'] . " " . $row['einfo_apellidos'],
                    'idnf'            => $documento['doc_prefijo'] . $row['ne_correlativo'],
                    'fecha_reg'       => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'divisa_factura'  => $row['div_nombre'],
                    'total_factura'   => $row['ne_total'],
                    'total_factura_moneda' => Moneda::moneda($row['ne_total'], $row['div_locale'], $row['div_simbolo'], $row['div_decimal'], $divisa['precision']),
                    'total'           => $row['comagentefn_fntotal'],
                    'total_moneda'    => Moneda::moneda($row['comagentefn_fntotal'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'cliente'         => $row['cli_razon_social'],
                    'porcentaje'      => round($row['comagentefn_porcentaje'], 2),
                    'estatuscom'      => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                    'estatusfn'       => $row['ne_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                    'monto'           => $row['comagentefn_monto'],
                    'monto_moneda'    => Moneda::moneda($row['comagentefn_monto'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'fecha_creacion'  => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d/m/Y', strtotime($row['comagentefn_fechapago'])) : '',
                    'uri_planilla'      => '',
                    'planilla'          => '',
                    'observacion'       => ''
                ];
            }
        }

        if (is_countable($ordenes) && count($ordenes)) {

            $documento = $newCom->obtenerDocumento(12);

            foreach ($ordenes as $row) {

                $planilla = $newCom->consultar("SELECT pre_id, pre_correlativo 
                        FROM app_planilla_orden_de_entrega 
                        JOIN app_preorden_master ON po_preid = pre_id 
                        WHERE po_nid = {$row['n_id']}")->row();

                $uri_planilla = '';
                $serv = 'GLOBAL';
                $planilla_id = '';

                if ($planilla) {
                    $planilla_id = $planilla['pre_correlativo'];
                    $uri_planilla = ruta_base() . 'planilla/orden/' . $planilla['pre_id'];
                    if ($row['comagentefn_planilla_servid']) {
                        $data_serv = $newCom->consultar("SELECT pro_descripcion FROM app_productos WHERE pro_id = {$row['comagentefn_planilla_servid']}")->row();
                        $serv = $data_serv['pro_descripcion'];
                    }
                }

                if ($row['comagentefn_estatus'] == 0) {
                    $total_pendiente += $row['comagentefn_monto'];
                } else {
                    $total_pagada += $row['comagentefn_monto'];
                }

                $array_total[] = [
                    'id'              => $row['comagentefn_id'],
                    'com_descripcion' => $row['com_descripcion'],
                    'uri'             => ruta_base() .  'ordendeentregaeditar/verFactura/' . $row['n_id'],
                    'agente'          => $row['einfo_nombres'] . " " . $row['einfo_apellidos'],
                    'idnf'            => $documento['doc_prefijo'] . $row['n_correlativo'],
                    'fecha_reg'       => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'divisa_factura'  => $row['div_nombre'],
                    'total_factura'   => $row['n_total'],
                    'total_factura_moneda' => Moneda::moneda($row['n_total'], $row['div_locale'], $row['div_simbolo'], $row['div_decimal'], $divisa['precision']),
                    'total'           => $row['comagentefn_fntotal'],
                    'total_moneda'    => Moneda::moneda($row['comagentefn_fntotal'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'cliente'         => $row['cli_razon_social'],
                    'porcentaje'      => round($row['comagentefn_porcentaje'], 2),
                    'estatuscom'      => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                    'estatusfn'       => $row['n_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                    'monto'           => $row['comagentefn_monto'],
                    'monto_moneda'    => Moneda::moneda($row['comagentefn_monto'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'fecha_creacion'  => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d/m/Y', strtotime($row['comagentefn_fechapago'])) : '',
                    'uri_planilla'      => $uri_planilla,
                    'planilla'          => $planilla_id,
                    'observacion'       => $serv
                ];
            }
        }

        if (is_countable($facturas) && count($facturas)) {

            $documento = $newCom->obtenerDocumento(2);

            foreach ($facturas as $row) {

                if ($row['comagentefn_estatus'] == 0) {
                    $total_pendiente += $row['comagentefn_monto'];
                } else {
                    $total_pagada += $row['comagentefn_monto'];
                }

                $array_total[] = [
                    'id'              => $row['comagentefn_id'],
                    'uri'             => ruta_base() .  'poseditar/verFactura/' . $row['fm_id'],
                    'com_descripcion' => $row['com_descripcion'],
                    'agente'          => $row['einfo_nombres'] . " " . $row['einfo_apellidos'],
                    'idnf'            => $documento['doc_prefijo'] . $row['fm_correlativo'],
                    'fecha_reg'       => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'divisa_factura'  => $row['div_nombre'],
                    'total_factura'   => $row['fm_total'],
                    'total_factura_moneda' => Moneda::moneda($row['fm_total'], $row['div_simbolo'], $row['div_decimal'], $divisa['precision']),
                    'total'             => $row['comagentefn_fntotal'],
                    'total_moneda'      => Moneda::moneda($row['comagentefn_fntotal'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'cliente'           => $row['cli_razon_social'],
                    'porcentaje'        => round($row['comagentefn_porcentaje'], 2),
                    'estatuscom'        => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                    'estatusfn'         => $row['fm_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                    'monto'             => $row['comagentefn_monto'],
                    'monto_moneda'      => Moneda::moneda($row['comagentefn_monto'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'fecha_creacion'    => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'fecha_pago'        => $row['comagentefn_fechapago'] ? date('d/m/Y', strtotime($row['comagentefn_fechapago'])) : '',
                    'uri_planilla'      => '',
                    'planilla'          => '',
                    'observacion'       => ''
                ];
            }
        }

        return [
            'total_pendiente'   => Moneda::moneda($total_pendiente, $divisa['locale'], $divisa['symbol'], $divisa['precision']),
            'total_pagado'      => Moneda::moneda($total_pagada, $divisa['locale'], $divisa['symbol'], $divisa['precision']),
            'total'             => Moneda::moneda($total_pendiente + $total_pagada, $divisa['locale'], $divisa['symbol'], $divisa['precision']),
            'comisiones'        => $array_total,
            'fecha_desde'       => $fecha_desde,
            'fecha_hasta'       => $fecha_hasta,
            'select_doc'        => $select_doc,
            'agente'            => $agente,
            'divisa'            => $divisa['id'],
            'comision'          => $id_comision,
            'estatus'           => $estatus,
            'estatusText'       => $estatusText,
            'tipo_comision'     => $tipo_comision
        ];
    }

    public function descargarIndvComisionPendiente()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {

            $fecha_desde    = filter_input(INPUT_GET, 'fd', FILTER_SANITIZE_STRING);
            $fecha_hasta    = filter_input(INPUT_GET, 'fh', FILTER_SANITIZE_STRING);
            $id_comision    = filter_input(INPUT_GET, 'c', FILTER_SANITIZE_NUMBER_INT);
            $id_divisa      = filter_input(INPUT_GET, 'd', FILTER_SANITIZE_NUMBER_INT);
            $estatus        = filter_input(INPUT_GET, 'e', FILTER_SANITIZE_NUMBER_INT) ?? 0;
            $select_doc     = filter_input(INPUT_GET, 'sd', FILTER_SANITIZE_STRING) ?? '';
            $agente         = filter_input(INPUT_GET, 'a', FILTER_SANITIZE_NUMBER_INT) ?? 0;

            if (empty($id_divisa)) {
                header('HTTP/1.1 403 Forbidden');
                return require "public/errores/403.php";
                exit();
            }

            if (empty($fecha_desde)) {
                header('HTTP/1.1 403 Forbidden');
                return require "public/errores/403.php";
                exit();
                $fecha_desde = (new DateTime())->modify('first day of this month')->format('Y-m-d');
            }

            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (!validateDate($fecha_desde, 'Y-m-d')) {
                header('HTTP/1.1 403 Forbidden');
                return require "public/errores/403.php";
                exit();
            }
            if (!validateDate($fecha_hasta, 'Y-m-d')) {
                header('HTTP/1.1 403 Forbidden');
                return require "public/errores/403.php";
                exit();
            }

            $data_comision = $this->obtenerComisionesIndividuales($fecha_desde, $fecha_hasta, $id_divisa, $id_comision, $estatus, '', $agente);

            $mpdf = new \Mpdf\Mpdf([
                'mode'              => 'utf-8',
                'margin_left'       => 15,
                'margin_right'      => 15,
                'margin_top'        => 50,
                'margin_bottom'     => 15,
                'margin_header'     => 15,
                'margin_footer'     => 15,
                'default_font_size' => 8,
                'default_font'      => 'helvetica'
            ]);

            $mpdf->SetTitle('Comision pendiente');
            $mpdf->SetAuthor(constant('EMP_NOMBRE'));
            $mpdf->SetCreator(constant('EMP_NOMBRE'));
            $mpdf->SetSubject('comision pendiente');

            $html_header = Vista::viewPDF('empleados/pdfreportecomision/individual/header', $data_comision);

            $mpdf->SetHTMLHeader($html_header);

            $html_body = Vista::viewPDF('empleados/pdfreportecomision/individual/body', $data_comision);

            $mpdf->WriteHTML($html_body);

            $mpdf->Output("COMISION", \Mpdf\Output\Destination::INLINE);
            exit;
        } else {
            header('HTTP/1.0 404 Not Found');
            return require "public/errores/404.php";
            exit();
        }
    }

    public function obtenerComisiones()
    {
        $new_comisiones = new Comisiones();
        $comisiones = $new_comisiones->todos();
        $lista = [];

        if (is_countable($comisiones) && count($comisiones)) {

            foreach ($comisiones as $row) {

                if ($row['com_tipo'] == 1) {
                    $tipo_comision = 'Producto simple';
                } else if ($row['com_tipo'] == 2) {
                    $tipo_comision = 'Producto simple';
                } else {
                    $tipo_comision = 'Servicio tecnico';
                }

                $lista[] = [
                    'id' => $row['com_id'],
                    'comision' => $row['com_descripcion'],
                    'porcentaje' => $row['com_porcentaje'],
                    'estatus' => $row['com_estatus'],
                    'tipo' => $row['com_estatus'] == 1 ? 'General' : 'Empleado',
                    'id_tipo_comision' => $row['com_tipo'],
                    'tipo_comision' => $tipo_comision,
                    'formula'=> $row['com_formula'],
                ];
            }
        }

        Http::json_response($lista);
    }

    public function editarGuardarComisiones()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $new_com = new Comisiones();

            if (empty($_POST['descripcion']))
                $this->array_errors[] = 'El campo descripcion es obligatorio';
            //if (empty($_POST['porcentaje']))
            //$this->array_errors[] = 'El campo porcentaje es obligatorio';
            if (empty($_POST['tipo_comision']))
                $this->array_errors[] = 'El campo Tipo es obligatorio';
            if (empty($_POST['tipo']))
                $this->array_errors[] = 'Debe especificar si es general o empleado';

            $descripcion  = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
            $porcentaje  = filter_input(INPUT_POST, 'porcentaje');
            $id  = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $tipo = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);
            $tipo_comision = filter_input(INPUT_POST, 'tipo_comision', FILTER_SANITIZE_NUMBER_INT);
            $formula = filter_input(INPUT_POST, 'formula', FILTER_SANITIZE_NUMBER_INT);

            if ($tipo == 1) {
                if (empty($porcentaje) || $porcentaje == 0 || !is_numeric($porcentaje)) {
                    $this->array_errors[] = 'El campo porcentaje debe ser numerico';
                } else {
                    $porcentaje = convertir_a_float($porcentaje);
                }
            }

            if ($new_com->existe('com_id', $id)) {
                if (empty($this->array_errors)) {
                    if ($new_com->editar($id, [
                        'com_descripcion' => $descripcion,
                        'com_porcentaje' => $porcentaje,
                        'com_tipo' => $tipo_comision,
                        'com_estatus' => $tipo,
                        'com_formula'=>$formula
                    ], true)) {
                        Http::json_response(true);
                    } else {
                        $this->array_errors[] = "Error de operacion.";
                    }
                }
            } else {
                if (!$new_com->existe('com_descripcion', $descripcion)) {
                    if (empty($this->array_errors)) {
                        if ($new_com->guardar([
                            'com_descripcion' => $descripcion,
                            'com_porcentaje' => $porcentaje,
                            'com_tipo' => $tipo_comision,
                            'com_estatus' => $tipo,
                            'com_formula'=>$formula
                        ], true)) {
                            Http::json_response(true);
                        } else {
                            $this->array_errors[] = "Error de operacion.";
                        }
                    }
                } else {
                    $this->array_errors[] = "Ya existe una comision con ese mismo nombre.";
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function editarpendiente()
    {
        $new_comempl = new EmpleadosComisionesEmplAgente();

        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $porcentaje  = filter_input(INPUT_POST, 'porcentaje', FILTER_SANITIZE_STRING ?? 0);
            $monto  = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING ?? 0);

            $monto = convertir_a_float($monto);
            $porcentaje = convertir_a_float($porcentaje);

            if ($monto <= 0) {
                $this->array_errors[] = 'EL monto no puede ser 0';
            } else {
                if ($new_comempl->existe('comagentefn_id', $id)) {
                    if (empty($this->array_errors)) {
                        if ($new_comempl->editar($id, [
                            'comagentefn_monto' => $monto,
                            'comagentefn_porcentaje'  => $porcentaje,
                        ], true)) {
                            Http::json_response(true);
                        } else {
                            Http::json_response(false);
                        }
                    }
                } else {
                    $this->array_errors[] = "Error, No se pudo modificar.";
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarComisionPendiente(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $new_comis = new EmpleadosComisionesEmplAgente();

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($new_comis->existe('comagentefn_id', $id)) {
                Http::json_response($new_comis->eliminar($id));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function obtenerComisionesEmpAgentePagadas(int $id_empleado)
    {
        $new_comempl = new EmpleadosComisionesEmplAgente();

        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_empleado = filter_var($id_empleado, FILTER_SANITIZE_NUMBER_INT);

            $facturas = $new_comempl->obtenerComisionesAgenteFacturasPagadas($id_empleado);
            $notas = $new_comempl->obtenerComisionesAgenteNotasPagadas($id_empleado);
            $ordenes = $new_comempl->obtenerComisionesAgenteOrdenPagadas($id_empleado);
            $array_total     = [];

            if (is_countable($notas) && count($notas)) {

                $documento = Documento::obtener(1);

                foreach ($notas as $row) {

                    if (!empty($row['comagentefn_divid'])) {
                        $divisa_pagada = Moneda::obtenerDivisa($row['comagentefn_divid']);
                    } else {
                        $divisa_pagada = [
                            'locale' => $row['div_locale'],
                            'symbol' => $row['div_simbolo']
                        ];
                    }

                    $array_total[] = [
                        'id'              => $row['comagentefn_id'],
                        'com_descripcion' => $row['com_descripcion'],
                        'uri'             => ruta_base() .  'notasdeentregaeditar/verFactura/' . $row['ne_id'],
                        'idnf'            => $documento['prefijo'] . $row['ne_correlativo'],
                        'fecha_reg'       => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                        'total'           => $row['comagentefn_fntotal'],
                        'total_moneda'    => Moneda::moneda($row['comagentefn_fntotal'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                        'cliente'         => $row['cli_razon_social'],
                        'porcentaje'      => round($row['comagentefn_porcentaje'], 2),
                        'estatuscom'      => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                        'estatusfn'       => $row['ne_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                        'monto'           => $row['comagentefn_monto'],
                        'monto_moneda'    => Moneda::moneda($row['comagentefn_monto'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                        'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : ''
                    ];
                }
            }

            if (is_countable($ordenes) && count($ordenes)) {

                $documento = Documento::obtener(12);

                foreach ($ordenes as $row) {

                    if (!empty($row['comagentefn_divid'])) {
                        $divisa_pagada = Moneda::obtenerDivisa($row['comagentefn_divid']);
                    } else {
                        $divisa_pagada = [
                            'locale' => $row['div_locale'],
                            'symbol' => $row['div_simbolo']
                        ];
                    }

                    $array_total[] = [
                        'id'              => $row['comagentefn_id'],
                        'com_descripcion' => $row['com_descripcion'],
                        'uri'             => ruta_base() .  'ordendeentregaeditar/verFactura/' . $row['n_id'],
                        'idnf'            => $documento['prefijo'] . $row['n_correlativo'],
                        'fecha_reg'       => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                        'total'           => $row['comagentefn_fntotal'],
                        'total_moneda'    => Moneda::moneda($row['comagentefn_fntotal'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                        'cliente'         => $row['cli_razon_social'],
                        'porcentaje'      => round($row['comagentefn_porcentaje'], 2),
                        'estatuscom'      => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                        'estatusfn'       => $row['n_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                        'monto'           => $row['comagentefn_monto'],
                        'monto_moneda'    => Moneda::moneda($row['comagentefn_monto'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                        'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : ''
                    ];
                }
            }

            if (is_countable($facturas) && count($facturas)) {

                $documento = Documento::obtener(2);

                foreach ($facturas as $row) {

                    if (!empty($row['comagentefn_divid'])) {
                        $divisa_pagada = Moneda::obtenerDivisa($row['comagentefn_divid']);
                    } else {
                        $divisa_pagada = [
                            'locale' => $row['div_locale'],
                            'symbol' => $row['div_simbolo']
                        ];
                    }

                    $array_total[] = [
                        'id'              => $row['comagentefn_id'],
                        'uri'             => ruta_base() .  'poseditar/verFactura/' . $row['fm_id'],
                        'com_descripcion' => $row['com_descripcion'],
                        'idnf'            => $documento['prefijo'] . $row['fm_correlativo'],
                        'fecha_reg'       => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                        'total'           => $row['comagentefn_fntotal'],
                        'total_moneda'    => Moneda::moneda($row['comagentefn_fntotal'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                        'cliente'         => $row['cli_razon_social'],
                        'porcentaje'      => round($row['comagentefn_porcentaje'], 2),
                        'estatuscom'      => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                        'estatusfn'       => $row['fm_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                        'monto'           => $row['comagentefn_monto'],
                        'monto_moneda'    => Moneda::moneda($row['comagentefn_monto'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                        'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : ''
                    ];
                }
            }

            Http::json_response($array_total);
        }
    }

    public function obtenerComisionesEmpAgentePendiente(int $id_empleado)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $new_comempl = new EmpleadosComisionesEmplAgente();

            $id_empleado = filter_var($id_empleado, FILTER_SANITIZE_NUMBER_INT);
            $facturas = $new_comempl->obtenerComisionesAgenteFacturasPendientes($id_empleado);
            $notas = $new_comempl->obtenerComisionesAgenteNotasPendientes($id_empleado);
            $ordenes = $new_comempl->obtenerComisionesAgenteOrdenPendientes($id_empleado);
            $id_divisas = [];
            $lista_por_divisas = [];

            if (is_countable($notas) && count($notas)) {

                $documento = Documento::obtener(1);

                foreach ($notas as $row) {

                    $divisa_pagada = Moneda::obtenerDivisa($row['comagentefn_divid']);

                    $data = [
                        'id'                => $row['comagentefn_id'],
                        'com_descripcion'   => $row['com_descripcion'],
                        'uri'               => ruta_base() .  'notasdeentregaeditar/verFactura/' . $row['ne_id'],
                        'idnf'              => $documento['prefijo'] . $row['ne_correlativo'],
                        'fecha_reg'         => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                        'total'             => $row['comagentefn_fntotal'],
                        'total_moneda'      => Moneda::moneda($row['comagentefn_fntotal'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                        'cliente'           => $row['cli_razon_social'],
                        'porcentaje'        => round($row['comagentefn_porcentaje'], 2),
                        'estatuscom'        => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                        'estatusfn'         => $row['ne_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                        'monto'             => $row['comagentefn_monto'],
                        'monto_moneda'      => Moneda::moneda($row['comagentefn_monto'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                        'fecha_pago'        => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : '',
                        'checked'           => false
                    ];

                    if (in_array($row['comagentefn_divid'], $id_divisas)) {
                        $lista_por_divisas[$row['comagentefn_divid']]['pendientes'][] = $data;
                    } else {
                        $id_divisas[] = $row['comagentefn_divid'];
                        $lista_por_divisas[$row['comagentefn_divid']] = [
                            'divisa' => $divisa_pagada['divisa']
                        ];
                        $lista_por_divisas[$row['comagentefn_divid']]['pendientes'][] = $data;
                    }
                }
            }

            if (is_countable($ordenes) && count($ordenes)) {

                $documento = Documento::obtener(12);

                foreach ($ordenes as $row) {

                    $divisa_pagada = Moneda::obtenerDivisa($row['comagentefn_divid']);

                    $data = [
                        'id'                => $row['comagentefn_id'],
                        'com_descripcion'   => $row['com_descripcion'],
                        'uri'               => ruta_base() .  'ordendeentregaeditar/verFactura/' . $row['n_id'],
                        'idnf'              => $documento['prefijo'] . $row['n_correlativo'],
                        'fecha_reg'         => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                        'total'             => $row['comagentefn_fntotal'],
                        'total_moneda'      => Moneda::moneda($row['comagentefn_fntotal'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                        'cliente'           => $row['cli_razon_social'],
                        'porcentaje'        => round($row['comagentefn_porcentaje'], 2),
                        'estatuscom'        => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                        'estatusfn'         => $row['n_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                        'monto'             => $row['comagentefn_monto'],
                        'monto_moneda'      => Moneda::moneda($row['comagentefn_monto'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                        'fecha_pago'        => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : '',
                        'checked'           => false
                    ];

                    if (in_array($row['comagentefn_divid'], $id_divisas)) {
                        $lista_por_divisas[$row['comagentefn_divid']]['pendientes'][] = $data;
                    } else {
                        $id_divisas[] = $row['comagentefn_divid'];
                        $lista_por_divisas[$row['comagentefn_divid']] = [
                            'divisa' => $divisa_pagada['divisa']
                        ];
                        $lista_por_divisas[$row['comagentefn_divid']]['pendientes'][] = $data;
                    }
                }
            }

            if (is_countable($facturas) && count($facturas)) {

                $documento = Documento::obtener(2);

                foreach ($facturas as $row) {

                    $divisa_pagada = Moneda::obtenerDivisa($row['comagentefn_divid']);

                    $data = [
                        'id'                => $row['comagentefn_id'],
                        'uri'               => ruta_base() .  'poseditar/verFactura/' . $row['fm_id'],
                        'com_descripcion'   => $row['com_descripcion'],
                        'idnf'              => $documento['prefijo'] . $row['fm_correlativo'],
                        'fecha_reg'         => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                        'total'             => $row['comagentefn_fntotal'],
                        'total_moneda'      => Moneda::moneda($row['comagentefn_fntotal'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                        'cliente'           => $row['cli_razon_social'],
                        'porcentaje'        => round($row['comagentefn_porcentaje'], 2),
                        'estatuscom'        => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                        'estatusfn'         => $row['fm_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                        'monto'             => $row['comagentefn_monto'],
                        'monto_moneda'      => Moneda::moneda($row['comagentefn_monto'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                        'fecha_pago'        => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : '',
                        'checked'           => false
                    ];

                    if (in_array($row['comagentefn_divid'], $id_divisas)) {
                        $lista_por_divisas[$row['comagentefn_divid']]['pendientes'] = $data;
                    } else {
                        $id_divisas[] = $row['comagentefn_divid'];
                        $lista_por_divisas[$row['comagentefn_divid']] = [
                            'divisa' => $divisa_pagada['divisa']
                        ];
                        $lista_por_divisas[$row['comagentefn_divid']]['pendientes'][] = $data;
                    }
                }
            }

            Http::json_response($lista_por_divisas);
        }
    }

    public function obtenerComisionesAgente(int $id_empleado)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newAgent = new EmpleadoComisionAgente();
            $lista = [];
            if ($newAgent->existe('empagentipo_agente', $id_empleado)) {
                $comisiones = $newAgent->obtenerComisionesAgente($id_empleado);
                if (is_countable($comisiones) && count($comisiones)) {
                    foreach ($comisiones as $row) {
                        $lista[] = [
                            'id' => $row['empagentipo_id'],
                            'comision' => $row['com_descripcion'],
                            'porcentaje' => $row['com_estatus'] == 1 ? $row['com_porcentaje'] : $row['empagentipo_porcentaje'],
                            'estatus' => $row['empagentipo_estatus']
                        ];
                    }
                }
            }
            Http::json_response($lista);
        }
    }

    public function cambiarEstatusAgenteComision(int $id_comision_agente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newAgent = new EmpleadoComisionAgente();
            if ($newAgent->existe('empagentipo_id', $id_comision_agente)) {
                $comision = $newAgent->obtener($id_comision_agente);
                Http::json_response($newAgent->editar($id_comision_agente, [
                    'empagentipo_estatus' => $comision['empagentipo_estatus'] == 1 ? 0 : 1
                ]));
            } else {
                Http::json_response(['errors' => ['Acción prohibida']]);
            }
        }
    }

    public function obtenerComisionesactivas()
    {
        $new_comisiones = new Comisiones();
        $comisiones = $new_comisiones->obtenerComisionesactivas();
        Http::json_response($comisiones);
    }

    public function guardarComisiones()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $new_com = new Comisiones();
            $new_com_agente = new EmpleadoComisionAgente();

            $idagente  = filter_input(INPUT_POST, 'idagente', FILTER_SANITIZE_NUMBER_INT);
            $idcomision  = filter_input(INPUT_POST, 'idcomision', FILTER_SANITIZE_NUMBER_INT);
            $porcentaje  = filter_input(INPUT_POST, 'porcentaje');

            if (empty($idagente))
                $this->array_errors[] = 'Error al identificar el agente.';
            if (empty($idcomision))
                $this->array_errors[] = 'Debe seleccionar una comision.';

            if (empty($this->array_errors)) {

                $data_comsision = $new_com->obtener($idcomision);

                if ($data_comsision['com_estatus'] == 2) {
                    if (empty($porcentaje) || $porcentaje == 0 || !is_numeric($porcentaje)) {
                        Http::json_response(['errors' => ['El campo porcentaje debe ser numerico']]);
                    } else {
                        $porcentaje = convertir_a_float($porcentaje);
                    }
                } else {
                    $porcentaje = 0;
                }

                if ($new_com_agente->where(['empagentipo_comid' => $idcomision, 'empagentipo_agente' => $idagente], true))
                    Http::json_response(['errors' => ['Ya tiene esta comision.']]);

                if (constant('EMP_FIGURA_AGENTE') == true) {
                    $data_agente = $this->empleado_info->obtener($idagente);
                    if ($data_agente['einfo_agente_de_venta'] != 1) {
                        Http::json_response(['errors' => ['Los siento el empleado debe ser agente']]);
                    }
                }

                Http::json_response($new_com_agente->guardar([
                    'empagentipo_agente' => $idagente,
                    'empagentipo_comid'  => $idcomision,
                    'empagentipo_porcentaje' => $porcentaje
                ], true));
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarComisionAgente(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $new_comis = new EmpleadoComisionAgente();
            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);
            if ($new_comis->existe('empagentipo_id', $id)) {
                Http::json_response($new_comis->eliminar($id));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function obtenerMetodoPagoComisiones(int $divisa)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $divisa = filter_var($divisa, FILTER_SANITIZE_NUMBER_INT);

            if (empty($divisa))
                $this->array_errors[] = 'Debe una divisa';

            if (empty($this->array_errors)) {
                $metodopago = new MetodoPago();
                $data = $metodopago->obtenerMetodoPagoComisiones($divisa);
                if ($data) {
                    Http::json_response($data);
                } else {
                    $this->array_errors[] = 'Lo siento no hay metodos relacionados a esta divisa';
                }

                Http::json_response(['errors' => $this->array_errors]);
            }
        }
    }

    public function obtenerCuentasSegunMetodo(int $id_metodo_divisa)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_metodo_divisa = filter_var($id_metodo_divisa, FILTER_SANITIZE_NUMBER_INT);

            if (empty($id_metodo_divisa))
                $this->array_errors[] = 'Debe seleccionar un metodo';

            if (empty($this->array_errors)) {
                $data = $this->empleado->obtenerCuentasSegunMetodo($id_metodo_divisa);
                if ($data) {
                    Http::json_response($data);
                } else {
                    $this->array_errors[] = 'Lo siento no hay cuentas registradas para este metoto de pago';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerPagoDivisa()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['id_divisa']) || empty($_GET['id_comision']))
                Http::json_response(['errors' => ['Acción prohibida']]);

            $id_divisa  = filter_input(INPUT_GET, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_com_age = filter_input(INPUT_GET, 'id_comision', FILTER_SANITIZE_NUMBER_INT);

            $newEmpCom  = new EmpleadosComisionesEmplAgente();

            $data_comision  = $newEmpCom->obtener($id_com_age);
            $div_original   = Moneda::obtenerDivisa($data_comision['comagentefn_divid']);
            $div_deseada    = Moneda::obtenerDivisa($id_divisa);

            $total_sin_conversion = $data_comision['comagentefn_monto'];

            if ($data_comision['comagentefn_divid'] == $id_divisa) {
                $total = $data_comision['comagentefn_monto'];
            } else {
                $div_fact = Moneda::obtenerFactor($data_comision['comagentefn_divid'], $id_divisa);
                if ($div_fact) {
                    $total = $data_comision['comagentefn_monto'] * $div_fact['df_factor'];
                } else {
                    $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa seleccionada y la divisa en que se registró la comision.';
                }
            }

            if (empty($this->array_errors)) {
                Http::json_response([
                    'total_sin_conversion' => Moneda::moneda($total_sin_conversion, $div_original['locale'], $div_original['symbol'], $div_original['precision']),
                    'total_con_conversion' => Moneda::moneda($total, $div_deseada['locale'], $div_deseada['symbol'], $div_deseada['precision'])
                ]);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function pagarComision()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_divisa  = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_metodo  = filter_input(INPUT_POST, 'id_metodo', FILTER_SANITIZE_NUMBER_INT);
            $id_cuenta  = filter_input(INPUT_POST, 'id_cuenta', FILTER_SANITIZE_NUMBER_INT);
            $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);

            if (empty($id_divisa))
                $this->array_errors[] = 'El campo Divisa el obligatorio.';
            if (empty($id_metodo))
                $this->array_errors[] = 'El campo Metodo el obligatorio.';
            if (empty($id_cuenta))
                $this->array_errors[] = 'El campo Cuenta el obligatorio.';

            if ($id && empty($this->array_errors)) {

                $movimiento_model   = new MovimientoModel();
                $new_comempl        = new EmpleadosComisionesEmplAgente();
                $newFACV            = new Pos();
                $newNEV             = new Notasdeentrega();
                $newOrden           = new Ordendeentrega();
                $divisa_master      = Moneda::Predeterminada();

                $factor_master = $factor = 1;
                $total = 0;

                if ($id) {

                    $data_comision = $new_comempl->obtener($id);
                    $div_format = Moneda::obtenerDivisa($id_divisa);

                    if ($data_comision['comagentefn_divid'] == $id_divisa) {
                        $factor = 1;
                        $total = $data_comision['comagentefn_monto'];
                    } else {
                        $div_fact = Moneda::obtenerFactor($data_comision['comagentefn_divid'], $id_divisa);
                        if ($div_fact) {
                            $factor = $div_fact['df_factor'];
                            $total = $data_comision['comagentefn_monto'] * $factor;
                        } else {
                            $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa seleccionada y la divisa en que se registró la comision.';
                        }
                    }

                    if ($divisa_master['id'] != $id_divisa) {
                        $data_factor = Moneda::obtenerFactor($divisa_master['id'], $id_divisa);
                        if ($data_factor) {
                            $factor_master = $data_factor['df_factor'];
                        } else {
                            $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa predeterminada y la divisa a pagar';
                        }
                    }

                    $cuenta = $movimiento_model->consultar("SELECT cmp_saldo, cmp_cueid FROM app_cuentas_metodopago WHERE cmp_id = $id_cuenta")->row();
                    $saldo = $movimiento_model->consultar("SELECT bc_saldo FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();

                    if ($saldo['bc_saldo'] < $total) {
                        $this->array_errors[] = 'Saldo insuficiente';
                    }

                    if (empty($this->array_errors)) {

                        $fecha_de_pago = date('Y-m-d H:i:s');

                        if ($data_comision['comagentefn_fntipo'] == 1) {

                            $nota = $newNEV->obtener($data_comision['comagentefn_fnid']);
                            $doc_ = Documento::obtener(1);

                            try {

                                $movimiento_model->transactionBegin();

                                $movimiento_model->guardar([
                                    'fab_idgenerico'        => $data_comision['comagentefn_id'],
                                    'fab_doc'               => 13,
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo,
                                    'fab_cmpid'             => $id_cuenta,
                                    'fab_monto'             => $total * (-1),
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $data_comision['comagentefn_monto'] * (-1),
                                    'fab_divid_conversion'  => $data_comision['comagentefn_divid'],
                                    'fab_factor_master'     => $factor_master,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'comision',
                                    'fab_retiro'            => 1,
                                    'fab_descripcion'       => 'Pago Comision',
                                    'fab_observacion'       => "Pago Comision {$doc_['prefijo']} # {$nota['ne_correlativo']} {$nota['ne_env_nombres']} Monto: " . Moneda::moneda($total, $div_format['locale'], $div_format['symbol']),
                                    'fab_saldo_anterior'    => $saldo['bc_saldo'],
                                    'fab_categoria'         => 3
                                ]);

                                $movimiento_model->pagarCuenta($cuenta['cmp_cueid'], ($saldo['bc_saldo'] - $total));
                                $movimiento_model->pagarCuentaMetodo($id_cuenta, ($cuenta['cmp_saldo'] - $total));
                                $movimiento_model->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_estatus=1, comagentefn_fechapago = '$fecha_de_pago' WHERE comagentefn_id= {$data_comision['comagentefn_id']}")->run();

                                $movimiento_model->transactionCommit();
                            } catch (\Throwable $th) {
                                $movimiento_model->transactionRollBack();
                                $this->array_errors[] = $th;
                            }
                        } elseif ($data_comision['comagentefn_fntipo'] == 2) {

                            $factura = $newFACV->obtener($data_comision['comagentefn_fnid']);
                            $doc_ = Documento::obtener(2);

                            try {

                                $movimiento_model->transactionBegin();

                                $movimiento_model->guardar([
                                    'fab_idgenerico'        => $factura['comagentefn_id'],
                                    'fab_doc'               => 13,
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo,
                                    'fab_cmpid'             => $id_cuenta,
                                    'fab_monto'             => $total * (-1),
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $data_comision['comagentefn_monto'] * (-1),
                                    'fab_divid_conversion'  => $factura['fm_divid'],
                                    'fab_factor_master'     => $factor_master,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'comision',
                                    'fab_retiro'            => 1,
                                    'fab_descripcion'       => 'Pago Comision',
                                    'fab_observacion'       => "Pago Comision {$doc_['prefijo']} # {$factura['fm_correlativo']} {$factura['ne_env_nombres']} Monto: " . Moneda::moneda($total, $div_format['locale'], $div_format['symbol']),
                                    'fab_saldo_anterior'    => $saldo['bc_saldo'],
                                    'fab_categoria'         => 3
                                ]);

                                $movimiento_model->pagarCuenta($cuenta['cmp_cueid'], ($saldo['bc_saldo'] - $total));
                                $movimiento_model->pagarCuentaMetodo($id_cuenta, ($cuenta['cmp_saldo'] - $total));
                                $movimiento_model->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_estatus=1, comagentefn_fechapago = '$fecha_de_pago' WHERE comagentefn_id= {$data_comision['comagentefn_id']}")->run();

                                $movimiento_model->transactionCommit();
                            } catch (\Throwable $th) {
                                $movimiento_model->transactionRollBack();
                                $this->array_errors[] = $th;
                            }
                        } elseif ($data_comision['comagentefn_fntipo'] == 12) {

                            $orden = $newOrden->obtener($data_comision['comagentefn_fnid']);
                            $doc_ = Documento::obtener(12);

                            try {

                                $movimiento_model->transactionBegin();

                                $movimiento_model->guardar([
                                    'fab_idgenerico'        => $data_comision['comagentefn_id'],
                                    'fab_doc'               => 13,
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo,
                                    'fab_cmpid'             => $id_cuenta,
                                    'fab_monto'             => $total * (-1),
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $data_comision['comagentefn_monto'] * (-1),
                                    'fab_divid_conversion'  => $data_comision['comagentefn_divid'],
                                    'fab_factor_master'     => $factor_master,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'comision',
                                    'fab_retiro'            => 1,
                                    'fab_descripcion'       => 'Pago Comision',
                                    'fab_observacion'       => "Pago Comision {$doc_['prefijo']} # {$orden['n_correlativo']} {$orden['n_env_nombres']} Monto: " . Moneda::moneda($total, $div_format['locale'], $div_format['symbol']),
                                    'fab_saldo_anterior'    => $saldo['bc_saldo'],
                                    'fab_categoria'         => 3
                                ]);

                                $movimiento_model->pagarCuenta($cuenta['cmp_cueid'], ($saldo['bc_saldo'] - $total));
                                $movimiento_model->pagarCuentaMetodo($id_cuenta, ($cuenta['cmp_saldo'] - $total));
                                $movimiento_model->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_estatus=1, comagentefn_fechapago = '$fecha_de_pago' WHERE comagentefn_id= {$data_comision['comagentefn_id']}")->run();

                                $movimiento_model->transactionCommit();
                            } catch (\Throwable $th) {
                                $movimiento_model->transactionRollBack();
                                $this->array_errors[] = $th;
                            }
                        }
                    }

                    if (empty($this->array_errors)) {
                        Http::json_response(true);
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerMontoApagarDeComisionesSeleccionadas()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_divisa']))
                Http::json_response(['errors' => ['Debe seleccionar la divisa y alguna comision']]);

            $id_divisa  = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_comisiones = json_decode($_POST['id_comisiones'], true);

            if (is_countable($id_comisiones) && count($id_comisiones)) {

                $newEmpCom  = new EmpleadosComisionesEmplAgente();

                $data_comision_referencia = $newEmpCom->obtener($id_comisiones[0]);
                $divisa_original = Moneda::obtenerDivisa($data_comision_referencia['comagentefn_divid']);
                $div_deseada = Moneda::obtenerDivisa($id_divisa);
                $total_con_conversion = 0;
                $total_sin_conversion = 0;

                foreach ($id_comisiones as $row) {

                    $data_comision  = $newEmpCom->obtener($row);

                    $total_sin_conversion += $data_comision['comagentefn_monto'];

                    if ($data_comision['comagentefn_divid'] == $id_divisa) {
                        $total_con_conversion += $data_comision['comagentefn_monto'];
                    } else {
                        $div_fact = Moneda::obtenerFactor($data_comision['comagentefn_divid'], $id_divisa);
                        if ($div_fact) {
                            $total_con_conversion += $data_comision['comagentefn_monto'] * $div_fact['df_factor'];
                        } else {
                            $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa seleccionada y la divisa en que se registró la comision.';
                        }
                    }
                }

                if (empty($this->array_errors)) {
                    Http::json_response([
                        'total_sin_conversion' => Moneda::moneda($total_sin_conversion, $divisa_original['locale'], $divisa_original['symbol'], $divisa_original['precision']),
                        'total_con_conversion' => Moneda::moneda($total_con_conversion, $div_deseada['locale'], $div_deseada['symbol'], $div_deseada['precision'])
                    ]);
                }
            } else {
                $this->array_errors[]  = 'Acción prohibida';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function pagarComisiones()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_divisa  = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_metodo  = filter_input(INPUT_POST, 'id_metodo', FILTER_SANITIZE_NUMBER_INT);
            $id_cuenta  = filter_input(INPUT_POST, 'id_cuenta', FILTER_SANITIZE_NUMBER_INT);

            if (empty($id_divisa))
                $this->array_errors[] = 'El campo Divisa el obligatorio.';
            if (empty($id_metodo))
                $this->array_errors[] = 'El campo Metodo el obligatorio.';
            if (empty($id_cuenta))
                $this->array_errors[] = 'El campo Cuenta el obligatorio.';

            $id_comisiones = json_decode($_POST['id_comisiones'], true);

            if (is_countable($id_comisiones) && count($id_comisiones)) {

                $movimiento_model   = new MovimientoModel();
                $new_comempl        = new EmpleadosComisionesEmplAgente();
                $newFACV            = new Pos();
                $newNEV             = new Notasdeentrega();
                $newOrden           = new Ordendeentrega();
                $divisa_master      = Moneda::Predeterminada();

                $factor_master = $factor = 1;
                $total = 0;

                foreach ($id_comisiones as $id_comision) {

                    $data_comision = $new_comempl->obtener($id_comision);
                    $div_format = Moneda::obtenerDivisa($id_divisa);

                    if ($data_comision['comagentefn_divid'] == $id_divisa) {
                        $factor = 1;
                        $total = $data_comision['comagentefn_monto'];
                    } else {
                        $div_fact = Moneda::obtenerFactor($data_comision['comagentefn_divid'], $id_divisa);
                        if ($div_fact) {
                            $factor = $div_fact['df_factor'];
                            $total = $data_comision['comagentefn_monto'] * $factor;
                        } else {
                            $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa seleccionada y la divisa en que se registró la comision.';
                        }
                    }

                    if ($divisa_master['id'] != $id_divisa) {
                        $data_factor = Moneda::obtenerFactor($divisa_master['id'], $id_divisa);
                        if ($data_factor) {
                            $factor_master = $data_factor['df_factor'];
                        } else {
                            $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa predeterminada y la divisa a pagar';
                        }
                    }

                    $cuenta = $movimiento_model->consultar("SELECT cmp_saldo, cmp_cueid FROM app_cuentas_metodopago WHERE cmp_id = $id_cuenta")->row();
                    $saldo = $movimiento_model->consultar("SELECT bc_saldo FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();

                    if ($saldo['bc_saldo'] < $total) {
                        $this->array_errors[] = 'Saldo insuficiente';
                    }

                    if (empty($this->array_errors)) {

                        $fecha_de_pago = date('Y-m-d H:i:s');

                        if ($data_comision['comagentefn_fntipo'] == 1) {

                            $nota = $newNEV->obtener($data_comision['comagentefn_fnid']);
                            $doc_ = Documento::obtener(1);

                            try {

                                $movimiento_model->transactionBegin();

                                $movimiento_model->guardar([
                                    'fab_idgenerico'        => $data_comision['comagentefn_id'],
                                    'fab_doc'               => 13,
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo,
                                    'fab_cmpid'             => $id_cuenta,
                                    'fab_monto'             => $total * (-1),
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $data_comision['comagentefn_monto'] * (-1),
                                    'fab_divid_conversion'  => $data_comision['comagentefn_divid'],
                                    'fab_factor_master'     => $factor_master,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'comision',
                                    'fab_retiro'            => 1,
                                    'fab_descripcion'       => 'Pago Comision',
                                    'fab_observacion'       => "Pago Comision {$doc_['prefijo']} # {$nota['ne_correlativo']} {$nota['ne_env_nombres']} Monto: " . Moneda::moneda($total, $div_format['locale'], $div_format['symbol']),
                                    'fab_saldo_anterior'    => $saldo['bc_saldo'],
                                    'fab_categoria'         => 3
                                ]);

                                $movimiento_model->pagarCuenta($cuenta['cmp_cueid'], ($saldo['bc_saldo'] - $total));
                                $movimiento_model->pagarCuentaMetodo($id_cuenta, ($cuenta['cmp_saldo'] - $total));
                                $movimiento_model->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_estatus=1, comagentefn_fechapago = '$fecha_de_pago' WHERE comagentefn_id= {$data_comision['comagentefn_id']}")->run();

                                $movimiento_model->transactionCommit();
                            } catch (\Throwable $th) {
                                $movimiento_model->transactionRollBack();
                                $this->array_errors[] = 'Error en transacción';
                            }
                        } elseif ($data_comision['comagentefn_fntipo'] == 2) {

                            $factura = $newFACV->obtener($data_comision['comagentefn_fnid']);
                            $doc_ = Documento::obtener(2);

                            try {

                                $movimiento_model->transactionBegin();

                                $movimiento_model->guardar([
                                    'fab_idgenerico'        => $factura['comagentefn_id'],
                                    'fab_doc'               => 13,
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo,
                                    'fab_cmpid'             => $id_cuenta,
                                    'fab_monto'             => $total * (-1),
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $data_comision['comagentefn_monto'] * (-1),
                                    'fab_divid_conversion'  => $factura['fm_divid'],
                                    'fab_factor_master'     => $factor_master,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'comision',
                                    'fab_retiro'            => 1,
                                    'fab_descripcion'       => 'Pago Comision',
                                    'fab_observacion'       => "Pago Comision {$doc_['prefijo']} # {$factura['fm_correlativo']} {$factura['ne_env_nombres']} Monto: " . Moneda::moneda($total, $div_format['locale'], $div_format['symbol']),
                                    'fab_saldo_anterior'    => $saldo['bc_saldo'],
                                    'fab_categoria'         => 3
                                ]);

                                $movimiento_model->pagarCuenta($cuenta['cmp_cueid'], ($saldo['bc_saldo'] - $total));
                                $movimiento_model->pagarCuentaMetodo($id_cuenta, ($cuenta['cmp_saldo'] - $total));
                                $movimiento_model->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_estatus=1, comagentefn_fechapago = '$fecha_de_pago' WHERE comagentefn_id= {$data_comision['comagentefn_id']}")->run();

                                $movimiento_model->transactionCommit();
                            } catch (\Throwable $th) {
                                $movimiento_model->transactionRollBack();
                                $this->array_errors[] = 'Error en transacción';
                            }
                        } else if ($data_comision['comagentefn_fntipo'] == 12) {

                            $orden = $newOrden->obtener($data_comision['comagentefn_fnid']);
                            $doc_ = Documento::obtener(12);

                            try {

                                $movimiento_model->transactionBegin();

                                $movimiento_model->guardar([
                                    'fab_idgenerico'        => $data_comision['comagentefn_id'],
                                    'fab_doc'               => 13,
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo,
                                    'fab_cmpid'             => $id_cuenta,
                                    'fab_monto'             => $total * (-1),
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $data_comision['comagentefn_monto'] * (-1),
                                    'fab_divid_conversion'  => $data_comision['comagentefn_divid'],
                                    'fab_factor_master'     => $factor_master,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'comision',
                                    'fab_retiro'            => 1,
                                    'fab_descripcion'       => 'Pago Comision',
                                    'fab_observacion'       => "Pago Comision {$doc_['prefijo']} # {$orden['n_correlativo']} {$orden['n_env_nombres']} Monto: " . Moneda::moneda($total, $div_format['locale'], $div_format['symbol']),
                                    'fab_saldo_anterior'    => $saldo['bc_saldo'],
                                    'fab_categoria'         => 3
                                ]);

                                $movimiento_model->pagarCuenta($cuenta['cmp_cueid'], ($saldo['bc_saldo'] - $total));
                                $movimiento_model->pagarCuentaMetodo($id_cuenta, ($cuenta['cmp_saldo'] - $total));
                                $movimiento_model->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_estatus=1, comagentefn_fechapago = '$fecha_de_pago' WHERE comagentefn_id= {$data_comision['comagentefn_id']}")->run();

                                $movimiento_model->transactionCommit();
                            } catch (\Throwable $th) {
                                $movimiento_model->transactionRollBack();
                                $this->array_errors[] = 'Error en transacción';
                            }
                        }
                    }
                }

                if (empty($this->array_errors)) {
                    Http::json_response(true);
                }
            } else {
                Http::json_response(['errors' => ['Debe seleccionar alguna comision']]);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarComision(int $id_comision)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newComision = new Comisiones();

            if ($newComision->obtener($id_comision)) {
                if ($newComision->consultar("SELECT * FROM app_comisiones_agente_fn WHERE comagentefn_com = $id_comision")->row()) {
                    Http::json_response(['errors' => ['La siento la comision ya fue usada']]);
                }
                Http::json_response($newComision->eliminar($id_comision));
            } else {
                Http::json_response(['errors' => ['Acción prohibida']]);
            }
        }
    }

    public function editarPorcentajeComisionAgente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_comision_agente']))
                Http::json_response(['errors' => ['Acción prohibida']]);
            if (empty($_POST['porcentaje']))
                Http::json_response(['errors' => ['EL campo porcentaje es obligatorio']]);

            $id_comision_agente = filter_var($_POST['id_comision_agente'], FILTER_VALIDATE_INT);
            $porcentaje         = filter_var($_POST['porcentaje']);

            if (!is_numeric($porcentaje)) {
                Http::json_response(['errors' => ['EL campo porcentaje debe ser numerico']]);
            }

            if (empty($this->array_errors)) {

                $porcentaje = convertir_a_float($porcentaje);

                $newComisionAgente  = new EmpleadoComisionAgente();
                $newComision        = new Comisiones();

                $comision_agente = $newComisionAgente->obtener($id_comision_agente);

                if ($comision_agente) {
                    $comision = $newComision->obtener($comision_agente['empagentipo_comid']);
                    if ($comision['com_estatus'] == 1)
                        Http::json_response(['errors' => ['Lo siento La comisión es global y no aplica por empleado']]);
                } else {
                    Http::json_response(['errors' => ['Acción prohibida']]);
                }

                Http::json_response($newComisionAgente->editar($id_comision_agente, [
                    'empagentipo_porcentaje' => $porcentaje
                ]));
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerDocumentosSegunComisionAgente(int $id_com_emp)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_com_emp = filter_var($id_com_emp, FILTER_SANITIZE_NUMBER_INT);
            $newEmpComDoc = new EmpleadoComisionDocumento();
            $data =  $newEmpComDoc->obtenerComisionDocumentos($id_com_emp);
            Http::json_response([
                'documentos' => $newEmpComDoc->obtenerDocumentos($id_com_emp),
                'doc_asignados' => $data
            ]);
        }
    }

    public function guardarComisionEmpleadoDocumento()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_com_emp']) || empty($_POST['documentos']) || empty($_POST['documentoFijo']))
                Http::json_response(['errors' => ['Acción prohibida']]);

            $id_com_emp = filter_input(INPUT_POST, 'id_com_emp', FILTER_SANITIZE_NUMBER_INT);
            $id_documento = filter_input(INPUT_POST, 'documentos', FILTER_SANITIZE_NUMBER_INT);
            $fijo = filter_input(INPUT_POST, 'documentoFijo', FILTER_SANITIZE_NUMBER_INT);

            if ($fijo != 1) {
                $fijo = 0;
            }

            $newEmpComDoc = new EmpleadoComisionDocumento();

            if (empty($_POST['doc_asig'])) {

                if ($newEmpComDoc->where(['ecd_empagentipoid' => $id_com_emp, 'ecd_docid' => $id_documento], true))
                    Http::json_response(['errors' => ['Acción prohibida']]);

                Http::json_response($newEmpComDoc->guardar([
                    'ecd_empagentipoid' => $id_com_emp,
                    'ecd_docid' => $id_documento,
                    'ecd_fijo' => $fijo
                ], true));
            } else {

                $doc_asig = filter_var($_POST['doc_asig'], FILTER_SANITIZE_NUMBER_INT);

                if ($newEmpComDoc->where(['ecd_id!=' => $doc_asig, 'ecd_empagentipoid' => $id_com_emp, 'ecd_docid' => $id_documento], true))
                    Http::json_response(['errors' => ['Acción prohibida']]);

                Http::json_response($newEmpComDoc->editar($doc_asig, [
                    'ecd_docid' => $id_documento,
                    'ecd_fijo' => $fijo
                ], true));
            }
        }
    }

    public function eliminarDocAsignado(int $ecd_id)
    {
        $ecd_id = filter_var($ecd_id, FILTER_SANITIZE_NUMBER_INT);
        $newEmpComDoc = new EmpleadoComisionDocumento();
        Http::json_response($newEmpComDoc->eliminar($ecd_id));
    }

    private function obtenerComisionesGlobales(string $fecha_desde, string $fecha_hasta, int $id_divisa, int $id_comision, int $estatus)
    {
        $newCom = new EmpleadosComisionesEmplAgente();
        $divisa = Moneda::obtenerDivisa($id_divisa);
        $empleados = [];
        $lista_comision = [];
        $total_pendiente = 0;

        if ($estatus == 3) {
            $estatus = '';
            $estatusText = 'todas';
        } else {
            $estatusText = $estatus == 1 ? 'pagadas' : 'pendientes';
            $estatus = "AND fn.comagentefn_estatus=$estatus";
        }

        if (!empty($id_comision)) {
            $data_comision = $newCom->consultar("SELECT * FROM app_comision WHERE com_id = $id_comision")->row();
            $tipo_comision = $data_comision['com_descripcion'];
            $facturas   = $newCom->obtenerComisionesFacturas("fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa $estatus");
            $notas      = $newCom->obtenerComisionesNotas("fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa $estatus");
            $ordenes    = $newCom->obtenerComisionesOrdenes("fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa $estatus");
        } else {
            $tipo_comision = 'Todas';
            $facturas   = $newCom->obtenerComisionesFacturas("fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa $estatus");
            $notas      = $newCom->obtenerComisionesNotas("fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa $estatus");
            $ordenes    = $newCom->obtenerComisionesOrdenes("fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa $estatus");
        }

        if (is_countable($facturas) && count($facturas)) {
            foreach ($facturas as $row) {
                $total_pendiente += $row['monto'];
                if (!in_array($row['comagentefn_fnempagente'], $empleados)) {
                    $empleados[] = $row['comagentefn_fnempagente'];
                    $lista_comision[$row['comagentefn_fnempagente']] = [
                        'empleado' => $row['einfo_nombres'] . ' ' . $row['einfo_apellidos'],
                        'cantidad_comision' => $row['registro'],
                        'total_comision' => $row['monto']
                    ];
                } else {
                    $lista_comision[$row['comagentefn_fnempagente']]['cantidad_comision'] += 1;
                    $lista_comision[$row['comagentefn_fnempagente']]['total_comision'] += $row['monto'];
                }
            }
        }

        if (is_countable($notas) && count($notas)) {
            foreach ($notas as $row) {
                $total_pendiente += $row['monto'];
                if (!in_array($row['comagentefn_fnempagente'], $empleados)) {
                    $empleados[] = $row['comagentefn_fnempagente'];
                    $lista_comision[$row['comagentefn_fnempagente']] = [
                        'empleado' => $row['einfo_nombres'] . ' ' . $row['einfo_apellidos'],
                        'cantidad_comision' => $row['registro'],
                        'total_comision' => $row['monto']
                    ];
                } else {
                    $lista_comision[$row['comagentefn_fnempagente']]['cantidad_comision'] += 1;
                    $lista_comision[$row['comagentefn_fnempagente']]['total_comision'] += $row['monto'];
                }
            }
        }

        if (is_countable($ordenes) && count($ordenes)) {
            foreach ($ordenes as $row) {
                $total_pendiente += $row['monto'];
                if (!in_array($row['comagentefn_fnempagente'], $empleados)) {
                    $empleados[] = $row['comagentefn_fnempagente'];
                    $lista_comision[$row['comagentefn_fnempagente']] = [
                        'empleado' => $row['einfo_nombres'] . ' ' . $row['einfo_apellidos'],
                        'cantidad_comision' => $row['registro'],
                        'total_comision' => $row['monto']
                    ];
                } else {
                    $lista_comision[$row['comagentefn_fnempagente']]['cantidad_comision'] += 1;
                    $lista_comision[$row['comagentefn_fnempagente']]['total_comision'] += $row['monto'];
                }
            }
        }

        foreach ($lista_comision as $key => $row) {
            $lista_comision[$key]['total_comision'] = Moneda::moneda($row['total_comision'], $divisa['locale'], $divisa['symbol'], $divisa['precision']);
        }

        return  [
            'total_pendiente' => Moneda::moneda($total_pendiente, $divisa['locale'], $divisa['symbol'], $divisa['precision']),
            'comisiones' => $lista_comision,
            'fecha_desde' => $fecha_desde,
            'fecha_hasta' => $fecha_hasta,
            'divisa' => $divisa['id'],
            'comision' => $id_comision,
            'estatus' => $estatus,
            'estatusText' => $estatusText,
            'tipo_comision' => $tipo_comision
        ];
    }

    public function busquedaGlobal()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $fecha_desde    = filter_input(INPUT_POST, 'globFechaDesde', FILTER_SANITIZE_STRING);
            $fecha_hasta    = filter_input(INPUT_POST, 'globFechaHasta', FILTER_SANITIZE_STRING);
            $id_comision    = filter_input(INPUT_POST, 'globTipoComision', FILTER_SANITIZE_NUMBER_INT);
            $id_divisa      = filter_input(INPUT_POST, 'globDivisa', FILTER_SANITIZE_NUMBER_INT);
            $estatus        = filter_input(INPUT_POST, 'globEstatus', FILTER_SANITIZE_NUMBER_INT) ?? 0;

            if (empty($id_divisa))
                Http::json_response(['errors' => ['El campo Divisa es obligatorio']]);

            if (empty($fecha_desde))
                $fecha_desde = (new DateTime())->modify('first day of this month')->format('Y-m-d');

            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (!validateDate($fecha_desde, 'Y-m-d'))
                Http::json_response(['errors' => ['La Fecha desde es incorrecta']]);
            if (!validateDate($fecha_hasta, 'Y-m-d'))
                Http::json_response(['errors' => ['La Fecha hasta es incorrecta']]);


            Http::json_response($this->obtenerComisionesGlobales($fecha_desde, $fecha_hasta, $id_divisa, $id_comision, $estatus));
        } else {
            Http::json_response('Error');
        }
    }

    public function descargarComisionGlobalPendiente()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {

            $fecha_desde    = filter_input(INPUT_GET, 'fd', FILTER_SANITIZE_STRING);
            $fecha_hasta    = filter_input(INPUT_GET, 'fh', FILTER_SANITIZE_STRING);
            $id_comision    = filter_input(INPUT_GET, 'c', FILTER_SANITIZE_NUMBER_INT);
            $id_divisa      = filter_input(INPUT_GET, 'd', FILTER_SANITIZE_NUMBER_INT);
            $estatus        = filter_input(INPUT_GET, 'e', FILTER_SANITIZE_NUMBER_INT) ?? 0;

            if (empty($id_divisa)) {
                header('HTTP/1.1 403 Forbidden');
                return require "public/errores/403.php";
                exit();
            }

            if (empty($fecha_desde)) {
                header('HTTP/1.1 403 Forbidden');
                return require "public/errores/403.php";
                exit();
                $fecha_desde = (new DateTime())->modify('first day of this month')->format('Y-m-d');
            }

            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (!validateDate($fecha_desde, 'Y-m-d')) {
                header('HTTP/1.1 403 Forbidden');
                return require "public/errores/403.php";
                exit();
            }
            if (!validateDate($fecha_hasta, 'Y-m-d')) {
                header('HTTP/1.1 403 Forbidden');
                return require "public/errores/403.php";
                exit();
            }

            $data_comision = $this->obtenerComisionesGlobales($fecha_desde, $fecha_hasta, $id_divisa, $id_comision, $estatus);

            $mpdf = new \Mpdf\Mpdf([
                'mode'              => 'utf-8',
                'margin_left'       => 15,
                'margin_right'      => 15,
                'margin_top'        => 50,
                'margin_bottom'     => 15,
                'margin_header'     => 15,
                'margin_footer'     => 15,
                'default_font_size' => 8,
                'default_font'      => 'helvetica'
            ]);

            $mpdf->SetTitle('Comision pendiente');
            $mpdf->SetAuthor(constant('EMP_NOMBRE'));
            $mpdf->SetCreator(constant('EMP_NOMBRE'));
            $mpdf->SetSubject('comision pendiente');

            $html_header = Vista::viewPDF('empleados/pdfreportecomision/global/header', $data_comision);

            $mpdf->SetHTMLHeader($html_header);

            $html_body = Vista::viewPDF('empleados/pdfreportecomision/global/body', $data_comision);

            $mpdf->WriteHTML($html_body);

            $mpdf->Output("COMISION", \Mpdf\Output\Destination::INLINE);
            exit;
        } else {
            header('HTTP/1.0 404 Not Found');
            return require "public/errores/404.php";
            exit();
        }
    }
}
