<?php

namespace App\Modelos;

use Core\Database;

class Ejercicio extends Database
{
    protected $table = 'app_ejercicios';
    protected $id = 'ej_id';

    public function ejercicios()
    {
        return $this->consultar('SELECT ej_id, ej_codigo, ej_nombre, ej_fechainicio, ej_fechafin, DATE_FORMAT(ej_fechainicio, "%d-%m-%Y") as fechainicio, DATE_FORMAT(ej_fechafin, "%d-%m-%Y") as fechafin, ej_estatus, ej_eliminado FROM app_ejercicios WHERE ej_eliminado !=1')->all();
    }

    public function obtenerEjercicio($ej_id)
    {
        return $this->consultar("SELECT * FROM app_ejercicios  WHERE ej_id=$ej_id")->row();
    }

    public function ejerciciosActivos()
    {
        return $this->consultar('SELECT * FROM app_ejercicios WHERE ej_eliminado !=1 and ej_estatus=1')->row();
    }

    public function chequearAniosFiscales($fecha_ini)
    {
        return $this->consultar("SELECT * FROM app_ejercicios WHERE YEAR(ej_fechainicio)=YEAR('$fecha_ini')")->all();
    }

    public function chequearEjerciciosFiscalesDiferente($condicion)
    {
        return $this->consultar("SELECT * FROM app_ejercicios WHERE $condicion")->all();
    }
}
