<?php

namespace App\Controladores;

use App\Modelos\Ejercicio;
use Core\Controller;
use Core\Vista;

final class EjerciciosControlador extends Controller
{
    private $ejercicio;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->ejercicio = new Ejercicio();
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            return Vista::viewAJAX('ejercicios/index');
        }
    }

    public function obtenerEjercicios()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->ejercicio->ejercicios());
            exit;
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($_SESSION['user_data']['emp_id'] == 1) {

                $ej_codigo      = filter_input(INPUT_POST, 'ej_codigo', FILTER_SANITIZE_STRING);
                $ej_nombre      = filter_input(INPUT_POST, 'ej_nombre', FILTER_SANITIZE_STRING);
                $ej_fechainicio = filter_input(INPUT_POST, 'ej_fechainicio', FILTER_SANITIZE_STRING);
                $ej_fechafin    = filter_input(INPUT_POST, 'ej_fechafin', FILTER_SANITIZE_STRING);

                if (empty($ej_codigo))
                    $this->array_errors[] = "El campo Codigo es obligatorio.";
                if (empty($ej_nombre))
                    $this->array_errors[] = "El campo Nombre es obligatorio";
                if (empty($ej_fechainicio))
                    $this->array_errors[] = "El campo Fecha de inicio es obligatorio";
                if (empty($ej_fechafin))
                    $this->array_errors[] = "El campo Fecha de fin es obligatorio";

                if (empty($this->array_errors)) {

                    if ($this->ejercicio->ejerciciosActivos()) {
                        $this->ejercicio->ej_estatus = 0;
                    }

                    if (empty($_POST['ej_id'])) {
                        if ($this->ejercicio->where(['ej_estatus' => 1], true))
                            $this->array_errors[] = "Lo siento ya existe un ejercicio fiscal abierto";
                        if ($this->ejercicio->where(['ej_codigo' => $ej_codigo], true))
                            $this->array_errors[] = "El código $ej_codigo ya se encuentra en uso";
                        if ($this->ejercicio->chequearAniosFiscales("$ej_fechainicio"))
                            $this->array_errors[] = "Lo siento ya existe un ejercio fiscal en el mismo año";
                    } else {

                        $ej_id = filter_input(INPUT_POST, 'ej_id', FILTER_SANITIZE_NUMBER_INT);

                        $where_anio = "YEAR(ej_fechainicio)=YEAR('$ej_fechainicio') and ej_id!={$ej_id}";

                        if ($this->ejercicio->where(['ej_codigo' => $ej_codigo, 'ej_id!=' => $ej_id], true))
                            $this->array_errors[] = "El código $ej_codigo ya se encuentra en uso";
                        if ($this->ejercicio->where(['ej_estatus' => 1, 'ej_id!=' => $ej_id], true))
                            $this->array_errors[] = "Lo siento ya existe un ejercicio fiscal abierto";
                        if ($this->ejercicio->chequearEjerciciosFiscalesDiferente($where_anio))
                            $this->array_errors[] = "Lo siento ya existe un ejercio fiscal en el mismo año";
                    }

                    if (empty($this->array_errors)) {
                        if (empty($_POST['ej_id'])) {
                            header('Content-Type: application/json', true);
                            echo json_encode($this->ejercicio->guardar([
                                'ej_codigo'         => $ej_codigo,
                                'ej_nombre'         => $ej_nombre,
                                'ej_fechainicio'    => $ej_fechainicio,
                                'ej_fechafin'       => $ej_fechafin
                            ], true));
                            exit;
                        } else {
                            header('Content-Type: application/json', true);
                            echo json_encode($this->ejercicio->editar($ej_id, [
                                'ej_codigo'         => $ej_codigo,
                                'ej_nombre'         => $ej_nombre,
                                'ej_fechainicio'    => $ej_fechainicio,
                                'ej_fechafin'       => $ej_fechafin
                            ]));
                            exit;
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Usted no es administrador';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function modificarEstatus(int $id_ejercicio)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_ejercicio = filter_var($id_ejercicio, FILTER_SANITIZE_NUMBER_INT);

            if ($this->ejercicio->existe('ej_id', $id_ejercicio)) {

                $data_ejercicio = $this->ejercicio->obtener($id_ejercicio);

                if ($data_ejercicio['ej_estatus'] == 1) {
                    $this->ejercicio->editar($id_ejercicio, [
                        'ej_estatus' => 0
                    ]);
                } else {
                    if ($this->ejercicio->ejerciciosActivos()) {
                        $this->array_errors[] = "Ya existe un ejercio fiscal activo porfavor cambie el estatus";
                    } else {
                        header('Content-Type: application/json', true);
                        echo json_encode($this->ejercicio->editar($id_ejercicio, [
                            'ej_estatus' => 1
                        ]));
                        exit;
                    }
                }
            } else {
                $this->array_errors[] = 'Usted no es administrador';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }
}
