<?php

namespace App\Controladores;

use Core\Controller;
use App\Modelos\Documentos;
use Core\Vista;

final class DocumentosControlador extends Controller
{
    private $documentos;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->documentos = new Documentos();
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            return Vista::viewAJAX('documentos/index');
        }
    }

    public function documentosActivos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->documentos->todos());
            exit;
        }
    }

    public function obtenerDocumentos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->documentos->todos());
            exit;
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $doc_codigo         = filter_input(INPUT_POST, 'codigo', FILTER_SANITIZE_STRING);
            $doc_prefijo        = filter_input(INPUT_POST, 'prefijo', FILTER_SANITIZE_STRING);
            $doc_descripcion    = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);

            if (empty($doc_codigo))
                $this->array_errors[] = "El campo Codigo es obligatorio.";
            if (empty($doc_prefijo))
                $this->array_errors[] = "El campo Prefijo es obligatorio.";
            if (empty($doc_descripcion))
                $this->array_errors[] = "El campo Nombre es obligatorio.";

            if (empty($this->array_errors)) {

                if (empty($_POST['id'])) {
                    if ($this->documentos->where(['doc_codigo' => $doc_codigo], true))
                        $this->array_errors[] = "Lo siento el codigo $doc_codigo ya se encuentra en uso";
                    if ($this->documentos->where(['doc_prefijo' => $doc_prefijo], true))
                        $this->array_errors[] = "Lo siento el codigo $doc_prefijo ya se encuentra en uso";
                } else {

                    $doc_id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);

                    if ($this->documentos->where(['doc_codigo' => $doc_codigo, 'doc_id!=', $doc_id], true))
                        $this->array_errors[] = "El código $doc_codigo ya se encuentra en uso";
                    if ($this->documentos->where(['doc_prefijo' => $doc_prefijo, 'doc_id!=', $doc_id], true))
                        $this->array_errors[] = "El código $doc_prefijo ya se encuentra en uso";
                }

                if (empty($this->array_errors)) {
                    if (empty($_POST['id'])) {
                        header('Content-Type: application/json', true);
                        echo json_encode($this->documentos->guardar([
                            'doc_codigo'       => $doc_codigo,
                            'doc_prefijo'      => $doc_prefijo,
                            'doc_descripcion'  => $doc_descripcion
                        ], true));
                        exit;
                    } else {
                        header('Content-Type: application/json', true);
                        echo json_encode($this->documentos->editar($doc_id, [
                            'doc_codigo'       => $doc_codigo,
                            'doc_prefijo'      => $doc_prefijo,
                            'doc_descripcion'  => $doc_descripcion
                        ], true));
                        exit;
                    }
                }
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function modificarEstatus(int $id_documento)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_documento  = filter_var($id_documento, FILTER_SANITIZE_NUMBER_INT);

            if ($this->documentos->existe('doc_id', $id_documento)) {
                $estatus = $this->documentos->obtener($id_documento);
                header('Content-Type: application/json', true);
                echo json_encode($this->documentos->editar($id_documento, [
                    'doc_estatus' => $estatus['doc_estatus'] == 1 ? 0 : 1
                ]));
                exit;
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }
}
