<div class="card" id="appDivisas" v-cloak>
    <div class="card-header">
        <div class="card-head-row">
            <div class="card-title">Listado de Divisas</div>
            <div class="card-tools">
                <a href="#" class="btn btn-light" style="box-shadow: 2px 6px 15px 0px #ddd;" @click.prevent="modalDivisa">
                    <span class="btn-label">
                        <i class="fa fa-plus"></i>
                    </span>
                    Agregar
                </a>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover table-sm" id="tabla_divisas">
                <thead>
                    <tr>
                        <th>Divisa</th>
                        <th>Descripción</th>
                        <th class="text-center">Decimal</th>
                        <th class="text-center">Factor</th>
                        <th class="text-center">Predeterminado</th>
                        <th class="text-center">Facturar</th>
                        <th class="text-center">Estatus</th>
                        <th class="text-center">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="row in divisas">
                        <td>{{ row.simbolo }} - {{ row.nombre }}</td>
                        <td>{{ row.descripcion }}</td>
                        <td class="text-center">{{ row.decimal }}</td>
                        <td class="text-center">
                            <a href="#" title="Factor de conversion" @click.prevent="modalFactor(row.id, row.nombre, row.descripcion)" class="text-secondary">
                                <i class="fa fa-calculator"></i>
                            </a>
                        </td>
                        <td class="text-center">
                            <select id="predeterminado" v-model="row.predeterminado" @change.prevent="prederterminado(row.id)" class="custom-select" style="width: 65%;">
                                <option value="0">NO</option>
                                <option value="1">SI</option>
                            </select>
                        </td>
                        <td class="text-center">
                            <select id="facturar" v-model="row.facturar" @change.prevent="facturar(row.id)" class="custom-select" style="width: 110%;">
                                <option value="0">NO</option>
                                <option value="1">SI</option>
                            </select>
                        </td>
                        <td class="text-center">
                            <a href="#" title="Modificar estatus" @click.prevent="modificarEstatus(row)">
                                <i :class="row.estatus == 1 ? 'fa fa-check text-success' : 'fa fa-times text-danger'"></i>
                            </a>
                        </td>
                        <td class="text-center">
                            <div class="form-button-action">
                                <button type="button" title="Editar" class="btn btn-link btn-primary" @click="ver(row)">
                                    <i class="fa fa-edit"></i>
                                </button>
                                <button type="button" title="Eliminar" class="btn btn-link text-dark" @click="eliminar(row.id, row.descripcion)">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <?php include 'modaleditarguardar.php'; ?>
    <?php include 'modalfactor.php'; ?>
</div>
<script src="<?= asset('assetsvuejs/divisas/divisas.js') ?>"></script>
