<?php

namespace App\Modelos;

use Core\Database;

class Divisa extends Database
{
    protected $table = 'app_divisas';
    protected $id = 'div_id';

    public function modificarEstatus(int $id_divisa, int $estatus)
    {
        return $this->consultar("UPDATE app_divisas SET div_status = $estatus WHERE div_id = $id_divisa")->run();
    }

    public function chueqearPredeterminados()
    {
        return $this->consultar("SELECT div_predeterminado FROM app_divisas WHERE div_predeterminado = 1")->row();
    }

    public function chueqearPredeterminadoFacturaDiferente(int $id_divisa)
    {
        return $this->consultar("SELECT div_predeterminado FROM app_divisas WHERE div_facturar = 1 and div_id != $id_divisa")->row();
    }

    public function establecerPredeterminadoFacturar(int $id_divisa, int $estatus)
    {
        if (0 == $estatus) {
            return $this->consultar("UPDATE app_divisas SET div_facturar = 0 WHERE div_id = $id_divisa")->run();
        } else {
            $this->consultar("UPDATE app_divisas SET div_facturar = 1 WHERE div_id = $id_divisa")->run();
            return $this->consultar("UPDATE app_divisas SET div_facturar = 0 WHERE div_id != $id_divisa")->run();
        }
    }

    public function chueqearPredeterminadosDiferente(int $id_divisa)
    {
        return $this->consultar("SELECT div_predeterminado FROM app_divisas WHERE div_predeterminado = 1 and div_id != $id_divisa")->row();
    }

    public function establecerPredeterminado(int $id_divisa, int $estatus)
    {
        if (0 == $estatus) {
            return $this->consultar("UPDATE app_divisas SET div_predeterminado = 0 WHERE div_id = $id_divisa")->run();
        } else {
            $this->consultar("UPDATE app_divisas SET div_predeterminado = 1 WHERE div_id = $id_divisa")->run();
            return $this->consultar("UPDATE app_divisas SET div_predeterminado = 0 WHERE div_id != $id_divisa")->run();
        }
    }

    public function divisaForanea(int $id_divisa)
    {
        return $this->consultar("SELECT * FROM app_metodopago_divisa WHERE md_divid=$id_divisa")->row();
    }

    public function divisaFactor(int $id_master, int $id)
    {
        return $this->consultar("SELECT * 
        FROM app_divisas_factor df
        JOIN app_divisas d ON d.div_id = df.df_divid 
        WHERE df.df_divid_master=$id_master and df.df_divid=$id")->row();
    }

    public function obtenerDivisa($id_divisa)
    {
        return $this->consultar("SELECT * FROM app_divisas  WHERE div_id=$id_divisa")->row();
    }
}
