<?php

namespace App\Modelos;

use Core\Database;

class Cuentasmd extends Database
{
    protected $table = 'app_cuentas_metodopago';
    protected $id = 'cmp_id';

    public function cmd()
    {
        return $this->consultar('SELECT cmp.cmp_id, cmp.cmp_cueid, cmp.cmp_mdid, ban.ban_descripcion, bc.bc_cuenta, mp.mp_nombre, d.div_nombre
        FROM app_cuentas_metodopago cmp
        JOIN app_bancos_cuentas bc ON bc.bc_id = cmp.cmp_cueid
        JOIN app_bancos ban ON bc.bc_banid=ban.ban_id
        JOIN app_metodopago_divisa md ON md.md_id = cmp.cmp_mdid
        JOIN app_metodopago mp ON mp.mp_id = md.md_mpid
        JOIN app_divisas d ON d.div_id = md.md_divid')->all();
    }

    public function cmdexiste($id_cuenta, $id_metodo_divisa)
    {
        return $this->consultar("SELECT cmp_id FROM app_cuentas_metodopago WHERE cmp_cueid=$id_cuenta and cmp_mdid=$id_metodo_divisa")->row();
    }

    public function eliminarCMD($id)
    {
        return $this->consultar("DELETE FROM app_cuentas_metodopago WHERE cmp_id=$id")->run();
    }

    public function obtenerMetodoDivisa($id_metodo_divisa)
    {
        return $this->consultar("SELECT * FROM app_metodopago_divisa WHERE md_id=$id_metodo_divisa")->row();
    }

    public function obtenerCuenta($id_cuenta)
    {
        return $this->consultar("SELECT amd.md_divid 
        FROM app_cuentas_metodopago c
        JOIN app_metodopago_divisa amd ON amd.md_id = c.cmp_mdid 
        WHERE cmp_cueid=$id_cuenta")->all();
    }
}
