<?php

namespace App\Controladores;

use App\Modelos\ProductoCategoria;
use App\Modelos\Productos;
use App\Modelos\ProductosImagen;
use Automattic\WooCommerce\Client;
use Automattic\WooCommerce\HttpClient\HttpClientException;
use Core\Controller;
use Core\Librerias\Http;

final class CronControlador extends Controller
{
    public $productos;
    private $woocommerce;

    public function __construct()
    {
        parent::__construct();

        $this->productos        = new Productos();
    }

    public function cronProductosWoocommerce($pro_id)
    {
        $array_mensajes = [];

        $this->woocommerce = new Client(
            constant('WCURL'),
            constant('WCKEY'),
            constant('WCSECRECT'),
            [
                'wp_api'    => true,
                'version'   => 'wc/v3',
                'timeout'   => 30
            ]
        );

        $productoImagen     = new ProductosImagen();
        $productoCategoria  = new ProductoCategoria();
        $woocor = $this->productos->consultar("SELECT * FROM app_wc")->row();

        $producto       = $this->productos->obtenerproImp($pro_id);
       // $pro_imagenes   = $productoImagen->obtenerProductoImagenes($pro_id);
        $pro_categorias = $productoCategoria->obtenerCategoriasProducto($pro_id);

        $data_form = [
            'slug'          => $producto['pro_descripcion'],
            'sku'           => $producto['pro_id'],
            'name'          => $producto['pro_descripcion'],
          //  'type'          => 'simple',
            'price'         => ($woocor['wc_precio'] == 1) ? float_a_string($producto['pro_precio'] + ($producto['pro_precio'] * ($producto['imp_valor'] / 100))) : $producto['pro_precio'],
            'regular_price' => ($woocor['wc_precio'] == 1) ? float_a_string($producto['pro_precio'] + ($producto['pro_precio'] * ($producto['imp_valor'] / 100))) : $producto['pro_precio'],
            'status'        => 'private'
            
        ];
        // 'description'   => '[wcm_product_discount]',
        if (defined('WCDESCRIPTION') && constant('WCDESCRIPTION') == 0) {
            $data_form['short_description'] = '[wcm_product_discount]';
        }

        if (is_countable($pro_categorias) && count($pro_categorias)) {
            foreach ($pro_categorias as $row) {
                $data_form['categories'][] = [
                    'id' => $row['cat_wooc']
                ];
            }
        }

       /* if (is_countable($pro_imagenes) && count($pro_imagenes)) {
            $i = 0;
            foreach ($pro_imagenes as $item) {
                $i++;
                $img = constant('WCIMG') . $item['pi_imagen'];
                $data_form['images'][] = [
                    "src" => $img,
                    "position" => $i
                ];
            }
        }
*/
        if ($producto['pro_nostock'] == 1 && $producto['pro_publico'] == 1) {
            $data_form['status'] = 'publish';
        } elseif ($producto['pro_nostock'] == 0 && $producto['pro_publico'] == 1) {
            $total_stock = $this->productos->obtenerTotalStockProducto($pro_id);
            if ($total_stock['total_stock'] > 0) {
                $data_form['status'] = 'publish';
            } else {
                $data_form['status'] = 'private';
            }
        }

        try {
            $wcproducto = $this->woocommerce->get('products', ['sku' => $pro_id]);

            if ($wcproducto !== []) {

                //ACTUALIZA
                try {
                    //unset($data_form['slug']);
                    $this->woocommerce->put('products/' . $wcproducto[0]->id, $data_form);
                    if ($data_form['status'] == 'publish') {
                        $array_mensajes[] = 'Producto publicado en woocommerce';
                    } else {
                        $array_mensajes[] = 'Producto no publicado en woocommerce ya que no cuenta con stock o el status ha sido modificado a privado';
                    }
                } catch (HttpClientException $e) {
                    $array_mensajes[] = $e->getMessage();
                }
                Http::json_response($array_mensajes);
            } else {
                //CREA if ($data_form['status'] == 'publish' && is_countable($pro_imagenes) && count($pro_imagenes) && is_countable($pro_categorias) && count($pro_categorias)) {
                 
                
                if ($data_form['status'] == 'publish'  && is_countable($pro_categorias) && count($pro_categorias)) {
                    try {
                        $this->woocommerce->post('products', $data_form);
                        $array_mensajes[] = 'Producto publicado en woocommerce';
                    } catch (HttpClientException $e) {
                        $array_mensajes[] = $e->getMessage();
                    }
                    Http::json_response($array_mensajes);
                } else {
                    $array_mensajes[] = 'Lo siento el producto debe tener precio, imagen, categoria y stock para poder subirlo a woocommerce';
                    Http::json_response($array_mensajes);
                }
            }
        } catch (HttpClientException $e) {
            $array_mensajes[] = $e->getMessage();
        }
        
        session_start([
            'cookie_lifetime' => 86400,
            'gc_maxlifetime' => 86400,
        ]);

        Http::json_response($array_mensajes);
    }
}
