<?php

namespace App\Controladores;

use Core\Controller;
use App\Modelos\Correlativos;
use Core\Vista;

final class CorrelativosControlador extends Controller
{
    private $correlativos;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->correlativos = new Correlativos();
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            return Vista::viewAJAX('correlativos/index');
        }
    }

    public function correlativos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->correlativos->correlativos());
            exit;
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($_SESSION['user_data']['emp_id'] == 1) {

                $cor_serid = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_NUMBER_INT);
                $cor_docid = filter_input(INPUT_POST, 'documento', FILTER_SANITIZE_NUMBER_INT);
                $correlativo = filter_input(INPUT_POST, 'correlativo', FILTER_SANITIZE_NUMBER_INT) ?? 0;

                if (empty($cor_serid))
                    $this->array_errors[] = "El campo Serie es obligatorio.";
                if (empty($cor_docid))
                    $this->array_errors[] = "El campo Documento es obligatorio.";

                $correlativo = filter_input(INPUT_POST, 'correlativo', FILTER_SANITIZE_NUMBER_INT);

                if (!is_numeric($correlativo) || $correlativo < 0) {
                    $this->array_errors[] = "El campo Debe ser numerico";
                }

                if (empty($this->array_errors)) {

                    if (empty($_POST['id'])) {
                        if ($this->correlativos->where(['cor_serid' => $cor_serid, 'cor_docid' => $cor_docid]))
                            $this->array_errors[] = "La relacion que intenta crear ya existe";
                    } else {
                        $cor_id = filter_var($_POST['id'], FILTER_SANITIZE_NUMBER_INT);
                        if ($this->correlativos->correlativosExiteNumero($cor_id, $correlativo)) {
                            $this->array_errors[] = "Lo siento debe crear un correlativo mayor a $correlativo";
                        }
                    }

                    if (empty($this->array_errors)) {
                        if (empty($_POST['id'])) {
                            header('Content-Type: application/json', true);
                            echo json_encode($this->correlativos->guardar([
                                'cor_serid'          => $cor_serid,
                                'cor_docid'          => $cor_docid,
                                'cor_correlativo'    => $correlativo,
                            ], true));
                            exit;
                        } else {
                            header('Content-Type: application/json', true);
                            echo json_encode($this->correlativos->editar($cor_id, [
                                'cor_serid'          => $cor_serid,
                                'cor_docid'          => $cor_docid,
                                'cor_correlativo'    => $correlativo,
                            ], true));
                            exit;
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Usted no es administrador';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function eliminar(int $id_correlativo)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_correlativo = filter_var($id_correlativo, FILTER_SANITIZE_NUMBER_INT);

            if ($this->correlativos->existe('cor_id', $id_correlativo)) {
                header('Content-Type: application/json', true);
                echo json_encode($this->correlativos->eliminar($id_correlativo));
                exit;
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }
}
