<?php

namespace App\Modelos;

use Core\Database;

class Convertirdocumento extends Database
{
    protected $table    = 'app_ruta_documento';
    protected $id       = 'rd_id';

    public function documentos()
    {
        return $this->consultar("SELECT * FROM app_documentos WHERE doc_estatus=1")->all();
    }

    public function Divisas()
    {
        return $this->consultar("SELECT * FROM app_divisas")->all();
    }

    public function sucursales()
    {
        return $this->consultar("SELECT * FROM app_empleados_sucursales s 
        JOIN app_sucursales su ON s.sucursal_id = su.su_id
        WHERE s.empleado_id={$_SESSION['user_data']['emp_id']}")->all();
    }

    public function Series($sucursal)
    {
        return $this->consultar("SELECT * FROM app_empleados_serie es 
        JOIN app_series s ON s.ser_id = es.empser_serid 
        JOIN app_sucursales su ON s.ser_sucursal = su.su_id
        WHERE es.empser_empid={$_SESSION['user_data']['emp_id']} AND s.ser_sucursal=$sucursal")->all();
    }

    public function almacenes($sucursal)
    {
        return $this->consultar("SELECT * 
        FROM app_empleados_almacen ea
        JOIN app_almacenes a ON a.alm_id = ea.empalm_almid 
        JOIN app_almacen_sucursal alms ON alms.alsu_almid = a.alm_id 
        JOIN app_sucursales su ON su.su_id = alms.alsu_suid 
        WHERE empalm_empid={$_SESSION['user_data']['emp_id']} AND alms.alsu_suid =$sucursal")->all();
    }

    public function obtenerAlmacen(int $id_almacen)
    {
        return $this->consultar("SELECT * FROM app_almacenes WHERE alm_id = $id_almacen")->row();
    }

    public function obtenerSerie($id_serie)
    {
        return $this->consultar("SELECT * FROM app_series WHERE ser_id=$id_serie")->row();
    }

    public function obtenerDivisa($id_divisa)
    {
        return $this->consultar("SELECT * FROM app_divisas WHERE div_id=$id_divisa")->row();
    }

    public function obtenerDocumento($id_documento)
    {
        return $this->consultar("SELECT * FROM app_documentos WHERE doc_id=$id_documento")->row();
    }

    public function chequearDocumentoVenta($id, $tabla, $id_valor)
    {
        return $this->consultar("SELECT * FROM $tabla WHERE $id = $id_valor")->row();
    }

    public function chuequearCorrelativo($id_serie, $id_documento)
    {
        return $this->consultar("SELECT * FROM app_correlativos WHERE cor_serid = $id_serie AND cor_docid = $id_documento")->row();
    }

    public function desontardeStock($id_producto, $id_alamcen, $cantidad)
    {
        return $this->consultar("UPDATE app_productos_stocks SET ps_cantidad = ps_cantidad - $cantidad WHERE ps_proid=$id_producto AND ps_almid=$id_alamcen")->run();
    }

    public function agregardeStock($id_producto, $id_alamcen, $cantidad)
    {
        return $this->consultar("UPDATE app_productos_stocks SET ps_cantidad = ps_cantidad + $cantidad WHERE ps_proid=$id_producto AND ps_almid=$id_alamcen")->run();
    }

    public function actualizarCorrelativo(int $id_serie, $id_documento, int $correlartivo)
    {
        return $this->consultar("UPDATE app_correlativos SET cor_correlativo = $correlartivo WHERE cor_serid = $id_serie AND cor_docid=$id_documento")->run();
    }

    public function chuequearStock($id_producto, $id_almacen)
    {
        return $this->consultar("SELECT * FROM app_productos_stocks WHERE ps_proid = $id_producto AND ps_almid = $id_almacen")->row();
    }

    public function obtenerDivisaMaster()
    {
        return $this->consultar("SELECT * FROM app_divisas WHERE div_predeterminado = 1")->row();
    }

    public function obtenerDivisaAlCambio(int $id_divisa_master, int $id_divisa_buscada)
    {
        return $this->consultar("SELECT * FROM app_divisas_factor WHERE df_divid_master=$id_divisa_master and df_divid=$id_divisa_buscada")->row();
    }

    public function obtenerProducto(int $id_producto)
    {
        return $this->consultar("SELECT p.pro_id, p.pro_codigo, p.pro_descripcion, p.pro_costo, p.pro_precio, 
        p.pro_tipo, pro_nostock, p.pro_impid, i.imp_descripcion, i.imp_valor 
        FROM app_productos p 
        LEFT JOIN app_impuestos i ON p.pro_impid = i.imp_id WHERE p.pro_id=$id_producto")->row();
    }
}
