<div id="appWC">
    <form @submit.prevent="editarGuardar" id="form-wc-modal">
        <div class="modal fade" id="modal-wc" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header mh">
                        <h5 class="modal-title">Woocommerce</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body" style="padding-top: 0px;">
                        <div class="form-group">
                            <label for="wc-url">url</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="flaticon-internet"></i>
                                    </span>
                                </div>
                                <input type="text" class="form-control" v-model="dataForm.url">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="wc-key">consumer_key</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="fas fa-key"></i>
                                    </span>
                                </div>
                                <input type="text" class="form-control" v-model="dataForm.key">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="wc-secret">consumer_secret</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="fas fa-question-circle"></i>
                                    </span>
                                </div>
                                <input type="text" class="form-control" v-model="dataForm.secret">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="wc-img">url-img</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="fas fa-image"></i>
                                    </span>
                                </div>
                                <input type="text" class="form-control" v-model="dataForm.img">
                            </div>
                        </div>                         
                        <div class="suiche" style="margin-top: 20px; justify-content: initial;">
                            <label for="switch" class="etiqueta">Descripción corta</label>
                            <input type="checkbox" v-model="dataForm.pro" id="switch">
                            <label for="switch" class="lbl"></label>
                            <label for="switch" class="etiqueta">Descripción larga</label>
                        </div>
                        <div class="suiche2" style="margin-top: 20px; justify-content: initial;">
                            <label for="switch2" class="etiqueta2">Precio</label>
                            <input type="checkbox" v-model="dataForm.prec" id="switch2">
                            <label for="switch2" class="lbl2"></label>
                            <label for="switch2" class="etiqueta2">Precio+Iva</label>
                        </div>
                        <div class="form-group">
                            <div class="alert alert-warning" v-for="row in errorForm">{{ row }}</div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-primary btn-round" disabled v-if="cargando">
                            <i class="loader loader-info"></i>
                        </button>
                        <button type="submit" class="btn btn-light" style="box-shadow: 2px 6px 15px 0px #ddd;" v-else>
                            <span class="far fa-save"></span> Guardar
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script>
    new Vue({
        el: '#appWC',
        data: {
            categorias: [],
            dataForm: {
                url: '',
                key: '',
                secret: '',
                img: '',
                pro: false,
                prec:false
            },
            errorForm: [],
            cargando: false
        },
        created() {
            this.obtenerDatosWC();
        },
        methods: {
            obtenerDatosWC() {
                axios.get('configuracion/obtenerDatosWC').then(response => {
                    this.dataForm = response.data;
                }).catch(e => notificacion());
            },
            resetearFormulario() {
                document.getElementById('form-wc-modal').reset();
                this.dataForm.url = '';
                this.dataForm.key = '';
                this.dataForm.secret = '';
                this.dataForm.pro = false;
                this.dataForm.prec = false;
                this.errorForm = [];
            },
            editarGuardar() {

                this.errorForm = [];

                if (!this.dataForm.url)
                    this.errorForm.push('El campo URL obligatorio.');
                if (!this.dataForm.key)
                    this.errorForm.push('El campo Key obligatorio.');
                if (!this.dataForm.secret)
                    this.errorForm.push('El campo Secret obligatorio.');
                if (!this.dataForm.img)
                    this.errorForm.push('El campo IMG obligatorio.');

                if (this.errorForm.length == 0) {
                    axios({
                        method: 'post',
                        url: 'configuracion/guardarWC',
                        data: this.dataForm,
                        transformRequest: serializar(),
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerDatosWC();
                                this.resetearFormulario();
                                notificacion('fa fa-check', 'Correcto', 'Operación realizada exitosamente', 'success');
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Error en operación', 'danger');
                            }
                        } else {
                            this.errorForm = response.data.errors;
                        }
                    }).catch(e => notificacion());
                }
            }
        }
    });
</script>