<div id="appCategoriasIE">
    <div class="modal fade" id="modal-categorias" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header mh">
                    <h5 class="modal-title">Categorías</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" style="padding-top: 0px;">
                    <form @submit.prevent="editarGuardar" id="form-catie-modal">
                        <div class="form-group">
                            <label for="catie-descripcion">Descripción</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="fas fa-pencil-alt"></i>
                                    </span>
                                </div>
                                <input type="text" class="form-control" v-model="dataForm.descripcion">
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="alert alert-warning" v-for="row in errorForm">{{ row }}</div>
                        </div>
                        <div class="form-group d-flex justify-content-end">
                            <button class="btn-light btn btn-sm " style="box-shadow: #ddd 2px 6px 15px 0px;">Registrar</button>
                        </div>
                    </form>
                    <div class="card-category text-primary pb-2" style="padding-left: 10px;"> <i class="fas fa-list-ul"></i> Lista de Categorías</div>
                    <div class="form-row">
                        <div class="col-12">
                            <ul class="list-group">
                                <li class="list-group-item d-flex justify-content-between align-items-center" title="Eliminar Categoría" v-for="row in categorias" :key="row.id" @click="ver(row)" style="cursor: pointer; padding: .25rem 1.25rem;">
                                    {{ row.categoria }}
                                    <button class="btn btn-icon btn-sm btn-light" @click="eliminar(row)" style="box-shadow: #ddd 2px 6px 15px 0px;">
                                        <span class="fa fa-trash"></span>
                                    </button>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#appCategoriasIE',
        data: {
            categorias: [],
            dataForm: {
                id: '',
                descripcion: ''
            },
            errorForm: [],
            cargando: false
        },
        created() {
            this.obtenerCategorias();
        },
        methods: {
            obtenerCategorias() {
                axios.get('configuracion/obtenerCategorias').then(response => {
                    this.categorias = response.data;
                }).catch(e => notificacion());
            },
            resetearFormulario() {
                document.getElementById('form-catie-modal').reset();
                this.dataForm.id = '';
                this.dataForm.descripcion = '';
                this.errorForm = [];
            },
            ver(categoria) {
                this.errorForm = [];
                this.dataForm.id = categoria.id;
                this.dataForm.descripcion = categoria.categoria;
            },
            editarGuardar() {

                this.errorForm = [];

                if (!this.dataForm.descripcion)
                    this.errorForm.push('El campo Descripción obligatorio.');

                if (this.errorForm.length == 0) {
                    axios({
                        method: 'post',
                        url: 'configuracion/guardar',
                        data: this.dataForm,
                        transformRequest: serializar(),
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerCategorias();
                                this.resetearFormulario();
                                notificacion('fa fa-check', 'Correcto', 'Operación realizada exitosamente', 'success');
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Error en operación', 'danger');
                            }
                        } else {
                            this.errorForm = response.data.errors;
                        }
                    }).catch(e => notificacion());
                }
            },
            eliminar(categoria) {

                this.errorForm = [];

                Swal.fire({
                    title: 'Eliminar Categoría',
                    text: "¿Estás seguro que deseas eliminar la categoria " + categoria.categoria + " ?",
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#aaa',
                    cancelButtonText: 'Cancelar',
                    confirmButtonText: 'Eliminar'
                }).then((result) => {
                    if (result.value) {
                        axios.get('configuracion/eliminar/' + categoria.id).then(response => {
                            if (response.data.errors == null) {
                                if (response.data == true) {
                                    let posicion = this.categorias.findIndex(item => item.id == categoria.id);
                                    this.categorias.splice(posicion, 1);
                                    notificacion('fa fa-trash', 'Categoria eliminada', categoria.categoria.toUpperCase(), 'danger');
                                } else {
                                    notificacion('fa fa-ban', 'Error al eliminar', categoria.categoria.toUpperCase(), 'danger');
                                }
                            } else {
                                this.errorForm = response.data.errors;
                            }
                        }).catch(e => notificacion()).finally(() => {
                            this.dataForm.id = '';
                            this.dataForm.descripcion = '';
                        })
                    }
                });
            }
        }
    });
</script>