<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form @submit.prevent="buscarProveedoresmasfrecuentes($event)" id="form_dia_busquedah">
                    <div class="form-row">
                        <div class="col-sm-2">
                            <div class="form-group form-floating-label">
                                <input id="dia_anio" type="date" class="form-control input-border-bottom" v-model="fecha_desdep">
                                <label for="dia_anio" class="placeholder">Fecha desde</label>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group input-group form-floating-label">
                                <input id="dia_anio" type="date" class="form-control input-border-bottom" v-model="fecha_hastap">
                                <label for="dia_meses" class="placeholder">Fecha hasta</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="proveedor" class="form-control input-border-bottom" v-model="proveedor">
                                    <option value="0">Todos</option>
                                    <?php foreach ($proveedores as $row) : ?>
                                        <option value="<?= $row['prov_id'] ?>"><?= $row['prov_nombre'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="mes_divisasc" class="placeholder">Proveedores</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="divisa_prov" class="form-control input-border-bottom" v-model="divisa_prov">
                                    <option value="0">Todos</option>
                                    <?php foreach ($divisas as $row) : ?>
                                        <option value="<?= $row['div_id'] ?>" <?= ($row['div_facturar'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="divisa_prov" class="placeholder">Divisa</label>
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-border btn-info btn-sm ml-2">Buscar</button>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-12">
        <div class="invoice-top text-center" style="background-color: rgba(222, 222, 222, 0.4);">
            <h3 class="title"><strong>PROVEEDORES</strong></h3>
        </div>
        <div class="row row-card-no-pd">
            <div class="col-sm-3 col-md-3" v-for="row in compra_prov">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-4">
                                <div class="fa-2x text-center"><i class="fa fa-user-tie text-success"></i></div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers">
                                    <p class="card-category" style="font-size: 9px;">{{ row.proveedor }}</p>
                                    <h4 id="count_productos"  style="font-size: 16px;" class="card-title">
                                        {{ moneda(row.venta, row.div_locale, row.div_simbolo) }}
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body" :cargando="cargando_tabla">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_compras_frecuentes">
                        <thead>
                            <tr>
                                <th class="text-center">Fecha</th>
                                <th class="text-center">Proveedor</th>
                                <th class="text-center">Monto</th>
                                <th class="text-center">Documento</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in mov_proveedor">
                                <td class="text-center">{{ row.fecha }}</td>
                                <td class="text-center">{{ row.proveedor }}</td>
                                <td class="text-center">{{ moneda(row.venta, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-center">
                                                        <a :href="row.ruta_documento">
                                                            {{row.correlativo}}
                                                        </a>
                                </td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>Total:</th>
                                <th></th>
                                <th class="text-right"></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>