<?php

use Core\Helpers\Moneda;

?>
<div class="row">
    <div class="col-12">
        <div class="row row-card-no-pd">
            <?php foreach ($cmppp['divisas_totales'] as $row) : ?>
                <div class="col-sm-6 col-md-3">
                    <div class="card card-stats card-round">
                        <div class="card-body ">
                            <div class="row">
                                <div class="col-4">
                                    <div class="icon-big text-center">
                                        <i class="flaticon-coins text-success"></i>
                                    </div>
                                </div>
                                <div class="col-8 col-stats">
                                    <div class="numbers">
                                        <p class="card-category">Total pendiente</p>
                                        <h4 class="card-title">
                                            <?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?>
                                        </h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="card-head-row">
                    <div class="card-title">Notas de entrega pendientes</div>
                    <?php foreach ($cmppp['totales_divisas_not'] as $row) : ?>
                    <div class="card-tools">
                        <div class="text-right">
                            <h6 class="fw-bold text-uppercase text-success op-8"><?=$row['div_nombre']; ?></h6>
                            <h3 class="fw-bold"><?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?></h3>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tcmpnp">
                        <thead>
                            <tr>
                                <th class="text-left">Proveedor</th>
                                <th class="text-left">Divisa</th>
                                <th class="text-right">Total</th>
                                <th class="text-right">Acumulado</th>
                                <th class="text-right">Pendiente</th>
                                <th>Fecha</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($cmppp['notas_pendiente'] as $row) : ?>
                                <tr>
                                    <td class="text-left"><?= $row['prov_nombre'] ?></td>
                                    <td class="text-left"><?= $row['divisa'] ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['acumulado'], $row['div_locale'], $row['div_simbolo'])  ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['pendiente'], $row['div_locale'], $row['div_simbolo'])  ?></td>
                                    <td><?= $row['fecha'] ?></td>
                                    <td class="text-center">
                                        <div class="form-button-action">
                                            <div class="input-group-append">
                                                <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>cmpnotaseditar/verFactura/<?= $row['id'] ?>" target="_blank">ver</a>
                                                    <div role="separator" class="dropdown-divider"></div>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>cmpnotaseditar/pdf/<?= $row['id'] ?>" target="_blank">PDF completo</a>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>cmpnotaseditar/pdfMP/<?= $row['id'] ?>" target="_blank">PDF media pagina</a>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>cmpnotaseditar/pdfFMP/<?= $row['id'] ?>" target="_blank">PDF pagos</a>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="card-head-row">
                <div class="card-title">Facturas pendientes</div>
                <?php foreach ($cmppp['totales_divisas_fac'] as $row) : ?>
                    <div class="card-tools">
                        <div class="text-right">
                            <h6 class="fw-bold text-uppercase text-success op-8"><?=$row['div_nombre']; ?></h6>
                            <h3 class="fw-bold"><?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?></h3>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tcmpfp">
                        <thead>
                            <tr>
                                <th class="text-left">Proveedor</th>
                                <th class="text-left">Divisa</th>
                                <th class="text-right">Total</th>
                                <th class="text-right">Acumulado</th>
                                <th class="text-right">Pendiente</th>
                                <th>Fecha</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($cmppp['facturas_pendiente'] as $row) : ?>
                                <tr>
                                    <td class="text-left"><?= $row['prov_nombre'] ?></td>
                                    <td class="text-left"><?= $row['divisa'] ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['acumulado'], $row['div_locale'], $row['div_simbolo'])  ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['pendiente'], $row['div_locale'], $row['div_simbolo'])  ?></td>
                                    <td><?= $row['fecha'] ?></td>
                                    <td class="text-center">
                                        <div class="form-button-action">
                                            <div class="input-group-append">
                                                <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>cmpfacturaeditar/verFactura/<?= $row['id'] ?>" target="_blank">ver</a>
                                                    <div role="separator" class="dropdown-divider"></div>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>cmpfacturaeditar/pdf/<?= $row['id'] ?>" target="_blank">PDF completo</a>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>cmpfacturaeditar/pdfMP/<?= $row['id'] ?>" target="_blank">PDF media pagina</a>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>cmpfacturaeditar/pdfFMP/<?= $row['id'] ?>" target="_blank">PDF pagos</a>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>