<style>
    .card.card-statistic-1 .card-header,
    .card.card-statistic-2 .card-header {
        border-color: transparent;
        padding-bottom: 0;
        height: auto;
        min-height: auto;
        display: block;
    }

    .card.card-statistic-1 .card-header h4,
    .card.card-statistic-2 .card-header h4 {
        line-height: 1.2;
        color: #98a6ad;
    }

    .card.card-statistic-1 .card-body,
    .card.card-statistic-2 .card-body {
        padding-top: 0;
    }

    .card.card-statistic-1 .card-body,
    .card.card-statistic-2 .card-body {
        font-size: 26px;
        font-weight: 700;
        color: #34395e;
        padding-bottom: 0;
    }

    .card.card-statistic-1,
    .card.card-statistic-2 {
        display: inline-block;
        width: 100%;
    }

    .card.card-statistic-1 .card-icon,
    .card.card-statistic-2 .card-icon {
        width: 80px;
        height: 80px;
        margin: 10px;
        border-radius: 3px;
        line-height: 94px;
        text-align: center;
        float: left;
        margin-right: 15px;
    }

    .card.card-statistic-1 .card-icon .ion,
    .card.card-statistic-1 .card-icon .fas,
    .card.card-statistic-1 .card-icon .far,
    .card.card-statistic-1 .card-icon .fab,
    .card.card-statistic-1 .card-icon .fal,
    .card.card-statistic-2 .card-icon .ion,
    .card.card-statistic-2 .card-icon .fas,
    .card.card-statistic-2 .card-icon .far,
    .card.card-statistic-2 .card-icon .fab,
    .card.card-statistic-2 .card-icon .fal {
        font-size: 22px;
        color: #fff;
    }

    .card.card-statistic-1 .card-icon {
        line-height: 90px;
    }

    .card.card-statistic-2 .card-icon {
        width: 50px;
        height: 50px;
        line-height: 50px;
        font-size: 22px;
        margin: 25px;
    }

    .card.card-statistic-1 .card-header,
    .card.card-statistic-2 .card-header {
        padding-bottom: 0;
        padding-top: 25px;
    }

    .card.card-statistic-2 .card-body {
        padding-top: 20px;
    }

    .card.card-statistic-2 .card-header+.card-body,
    .card.card-statistic-2 .card-body+.card-header {
        padding-top: 0;
    }

    .card.card-statistic-1 .card-header h4,
    .card.card-statistic-2 .card-header h4 {
        font-weight: 600;
        font-size: 13px;
        letter-spacing: .5px;
    }

    .card.card-statistic-1 .card-header h4 {
        margin-bottom: 0;
    }

    .card.card-statistic-2 .card-header h4 {
        text-transform: none;
        margin-bottom: 0;
    }

    .card.card-statistic-1 .card-body {
        font-size: 20px;
    }

    .card.card-statistic-2 .card-chart {
        padding-top: 20px;
        margin-left: -9px;
        margin-right: -1px;
        margin-bottom: -15px;
    }

    .card.card-statistic-2 .card-chart canvas {
        height: 90px !important;
    }

    .card.card-statistic-2 .card-header,
    .card-light .card-header {
        padding: 1rem 1.25rem;
        padding-top: 1rem;
        padding-bottom: 1rem;
        background-color: transparent;
        border-bottom: 1px solid #fff !important;
    }

    tr.group,
    tr.group:hover {
        background-color: #c1bfba !important;
    }
</style>
<div class="container" v-cloak id="appCompras">
    <input type="hidden" v-model="ruta" id="ruta_documento">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Compras</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('facturacion') ?>">Compras</a>
                </li>
            </ul>
            <div class="ml-md-auto">
                <a href="#" class="btn btn-info btn-round btn-sm mr-2" @click.prevent="modalLineas"> <span class="flaticon-search-2"></span> Buscar en Facturas</a>
                <div class="dropdown d-inline mr-3 mr-md-2">
                    <button class="btn btn-info btn-sm btn-border btn-round dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        Acciones
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -7px, 0px); top: 0px; left: 0px; will-change: transform;">
                        <a class="dropdown-item" href="<?= url('fabricantes') ?>">Fabricantes</a>
                        <a class="dropdown-item" href="<?= url('proveedores') ?>">Proveedores</a>
                        <a class="dropdown-item" href="<?= url('categorias') ?>">Categorías</a>
                        <a class="dropdown-item" href="<?= url('tarifas') ?>">Tarifas</a>
                        <a class="dropdown-item" href="<?= url('almacenes') ?>">Almacenes</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 mt-2">
                <div class="d-flex align-items-left flex-column">
                    <div class="nav-scroller d-flex">
                        <div class="nav nav-line d-flex align-items-center justify-contents-center">
                            <a class="nav-link active" data-toggle="pill" href="#ventas_documentos" role="tab" aria-controls="ventas_documentos" aria-selected="true" style="padding: 0px 0px 20px 0 !important;">Documentos</a>
                            <a class="nav-link " data-toggle="pill" href="#reportes_venta" role="tab" aria-controls="reportes_venta" aria-selected="false" style="padding: 0px 0px 20px 0 !important;" onclick="obtenerComprastodos()">Reportes</a>
                        </div>
                    </div>
                </div>
                <div class="tab-content mt-4">
                    <div class="tab-pane fade show active" id="ventas_documentos">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="card card-statistic-2">
                                            <div class="card-icon shadow-primary bg-primary">
                                                <i class="fas fa-file-invoice-dollar"></i>
                                            </div>
                                            <div class="card-wrap">
                                                <div class="card-header">
                                                    <h4>Facturas pendientes</h4>
                                                </div>
                                                <div class="card-body">
                                                    {{ facturasPendientes.length }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="card card-statistic-2">
                                            <div class="card-icon shadow-primary bg-primary">
                                                <i class="fas fa-file-invoice"></i>
                                            </div>
                                            <div class="card-wrap">
                                                <div class="card-header">
                                                    <h4>Notas de entregas pendientes</h4>
                                                </div>
                                                <div class="card-body">
                                                    {{ notasdeentregaPendientes.length }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="card card-statistic-2">
                                            <div class="card-icon shadow-primary bg-primary">
                                                <i class="fas fa-file-signature"></i>
                                            </div>
                                            <div class="card-wrap">
                                                <div class="card-header">
                                                    <h4>Pedidos pendientes</h4>
                                                </div>
                                                <div class="card-body">
                                                    {{pedidosPendientes.length}}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="card card-statistic-2">
                                            <div class="card-icon shadow-success bg-success">
                                                <i class="fas fa-file-invoice-dollar"></i>
                                            </div>
                                            <div class="card-wrap">
                                                <div class="card-header">
                                                    <h4>Facturas pagadas</h4>
                                                </div>
                                                <div class="card-body">
                                                    {{ facturas.length }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <canvas id="ventasSemanales" height="230"></canvas>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="row row-card-no-pd">
                                    <div class="col-12 col-md-2">
                                        <div class="nav flex-column nav-pills nav-secondary nav-pills-no-bd nav-pills-icons" id="v-pills-tab-with-icon" role="tablist" aria-orientation="vertical">
                                            <?php if ($cmpnotasentrega) : ?>
                                                <a class="<?= ($cmpnotasentrega) ? 'nav-link active' : 'nav-link'; ?>" id="v-pills-profile-tab-icons" data-toggle="pill" href="#Notasentrega" role="tab" aria-controls="Notasentrega" aria-selected="true" @click.prevent="obtenerNotasdeEntrega()">
                                                    Notas de Entrega
                                                </a>
                                            <?php endif; ?>
                                            <?php if ($cmpfacturas) : ?>
                                                <a class="nav-link" id="v-pills-home-tab-icons" data-toggle="pill" href="#Facturas" role="tab" aria-controls="Facturas" aria-selected="false" @click.prevent="obtenerFacturas()">
                                                    Facturas
                                                </a>
                                            <?php endif; ?>
                                            <?php if ($cmppedido) : ?>
                                                <a class="<?= ($cmpnotasentrega) ? 'nav-link' : 'nav-link active'; ?>" id="v-pills-home-tab-icons" data-toggle="pill" href="#Pedidos" role="tab" aria-controls="Pedidos" aria-selected="false">
                                                    Pedidos
                                                </a>
                                            <?php endif; ?>
                                            <?php if ($cmpnotascreditos) : ?>
                                                <a class="nav-link" id="v-pills-profile-tab-icons" data-toggle="pill" href="#NotasCredito" role="tab" aria-controls="NotasCredito" aria-selected="false" @click.prevent="obtenerNotasdeCredito()">
                                                    Notas de Crédito
                                                </a>
                                            <?php endif; ?>
                                            <a class="nav-link" id="v-pills-profile-tab-icons" data-toggle="pill" href="#sugerencias" role="tab" aria-controls="Sugerencias" aria-selected="false">Sugerencias</a>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-10">
                                        <div class="tab-content">
                                            <?php if ($cmpnotasentrega) : ?>
                                                <div class="<?= ($cmpnotasentrega) ? 'tab-pane fade show active' : 'tab-pane fade'; ?>" id="Notasentrega">
                                                    <div class="card">
                                                        <div class="card-body" style="padding-top: 5px;">
                                                            <div class="d-flex align-items-left flex-column">
                                                                <div class="nav-scroller d-flex">
                                                                    <div class="nav nav-line d-flex align-items-center justify-contents-center">
                                                                        <a class="nav-link active" data-toggle="pill" href="#notas_pendientes" role="tab" aria-controls="notas_pendientes" aria-selected="true" style="padding: 0px 0px 20px 0 !important;">Pendientes ({{ notasdeentregaPendientes.length }})</a>
                                                                        <a class="nav-link" data-toggle="pill" href="#notas_pagas" role="tab" aria-controls="notas_pagas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;">Pagas ({{ notasdeentrega.length }})</a>
                                                                        <a class="nav-link" data-toggle="pill" href="#notas_anuladas" role="tab" aria-controls="notas_anuladas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;">Anuladas ({{ notasdeentregaAnuladas.length }})</a>
                                                                    </div>
                                                                    <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">
                                                                        <a href="#" class="btn btn-info btn-border btn-sm btn-round" @click.prevent="ruta='cmpnotas'" data-toggle="modal" data-target="#modal_buscar_proveedor"> <span class="btn-label"> <i class="fa fa-plus"></i></span> Nueva nota de entrega</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12">
                                                                    <form>
                                                                        <div class="form-row">
                                                                            <div class="col-md-8">
                                                                                <!--<input type="text"> -->
                                                                            </div>
                                                                            <div class="col-md-2">
                                                                                <div class="form-group">
                                                                                    <label>Filtrar por Mes</label>
                                                                                    <select name="mes" class="form-control custom-select" v-model="mes" @change="obtenerNotasdeEntrega()">
                                                                                        <option value="0">Todos los meses</option>
                                                                                        <option value="01">Enero</option>
                                                                                        <option value="02">Febrero</option>
                                                                                        <option value="03">Marzo</option>
                                                                                        <option value="04">Abril</option>
                                                                                        <option value="05">Mayo</option>
                                                                                        <option value="06">Junio</option>
                                                                                        <option value="07">Julio</option>
                                                                                        <option value="08">Agosto</option>
                                                                                        <option value="09">Septiembre</option>
                                                                                        <option value="10">Octubre</option>
                                                                                        <option value="11">Noviembre</option>
                                                                                        <option value="12">Diciembre</option>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-2">
                                                                                <div class="form-group">
                                                                                    <label>Filtrar por Año</label>
                                                                                    <select name="anio" class="form-control custom-select" v-model="anio" @change="obtenerNotasdeEntrega()">
                                                                                        <?php for ($m = date('o'); $m >= 2019; $m--) {
                                                                                            if ($m == date('o')) {
                                                                                                echo '<option value="' . $m . '" selected>' . $m . '</option>';
                                                                                            } else {
                                                                                                echo '<option value="' . $m . '">' . $m . '</option>';
                                                                                            }
                                                                                        }
                                                                                        ?>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                            <div class="tab-content mt-4">
                                                                <div class="tab-pane fade show active" id="notas_pendientes">
                                                                    <div class="table-responsive" :class="cargando_tabla">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_notasdeentrega_pendientes">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th>Proveedor</th>
                                                                                    <th>#Factura</th>
                                                                                    <th>Acumulado</th>
                                                                                    <th>Pendiente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                    <th>Cambiar Estado</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tbody>
                                                                                <tr v-for="row in notasdeentregaPendientes">
                                                                                    <td class="text-center" style="width: 10%; font-size: 12px;"><a :href="'cmpnotaseditar/verFactura/'+row.id">NEC{{ row.correlativo }}</a></td>
                                                                                    <td class="text-left" style="width: 34%; font-size: 11px;">{{ row.cliente }}</td>
                                                                                    <td class="text-left" style="width: 34%; font-size: 11px;">{{ row.factura }}</td>
                                                                                    <td class="text-right" style="width: 12%; font-size: 11px;">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-right" style="width: 12%; font-size: 11px;">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-right" style="width: 12%; font-size: 11px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-right" style="width: 10%; font-size: 11px;">{{ fechaNormal(row.fecha) }}</td>
                                                                                    <td class="text-center" style="width: 10%;">
                                                                                        <div class="form-button-action">
                                                                                            <div class="input-group-append">
                                                                                                <a href="" @click.prevent="finalizarNota(row, '1')" title="Finalizar"><i class="fas fa-check text-success btn" style="padding: .65rem;"></i></a>
                                                                                            </div>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade" id="notas_pagas">
                                                                    <div class="table-responsive" :class="cargando_tabla">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_notasdeentrega_pagadas">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th>Proveedor</th>
                                                                                    <th>#Factura</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                    <th>Cambiar Estado</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tbody>
                                                                                <tr v-for="row in notasdeentrega">
                                                                                    <td class="text-center" style="width: 10%; font-size:12px;"><a :href="'cmpnotaseditar/verFactura/'+row.id">NEC{{ row.correlativo }}</a></td>
                                                                                    <td class="text-left" style="width: 50%; font-size:11px;">{{ row.cliente }}</td>
                                                                                    <td class="text-left" style="width: 34%; font-size: 11px;">{{ row.factura }}</td>
                                                                                    <td class="text-right" style="width: 20%; font-size:12px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-center" style="width: 10%; font-size:11px;">{{ fechaNormal(row.fecha) }}</td>
                                                                                    <td class="text-center" style="width: 10%;">
                                                                                        <div class="form-button-action">
                                                                                            <div class="input-group-append">
                                                                                                <a href="" @click.prevent="finalizarNota(row, '2')" title="Cambiar a Pendiente"><i class="fas fa-highlighter text-warning btn" style="padding: .65rem;"></i></a>
                                                                                            </div>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade" id="notas_anuladas">
                                                                    <div class="table-responsive" :class="cargando_tabla">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_notasdeentrega_anuladas">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th>Proveedor</th>
                                                                                    <th>#Factura</th>
                                                                                    <th>Acumulado</th>
                                                                                    <th>Pendiente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tbody>
                                                                                <tr v-for="row in notasdeentregaAnuladas">
                                                                                    <td class="text-center" style="width: 10%; font-size: 12px;"><a :href="'cmpnotaseditar/verFactura/'+row.id">NEC{{ row.correlativo }}</a></td>
                                                                                    <td class="text-left" style="width: 35%; font-size: 11px;">{{ row.cliente }}</td>
                                                                                    <td class="text-left" style="width: 34%; font-size: 11px;">{{ row.factura }}</td>
                                                                                    <td class="text-right" style="width: 15%; font-size: 11px;">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-right" style="width: 15%; font-size: 11px;">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-right" style="width: 15%; font-size: 11px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-right" style="width: 10%; font-size: 11px;">{{ fechaNormal(row.fecha) }}</td>
                                                                                </tr>
                                                                            </tbody>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($cmpfacturas) : ?>
                                                <div class="tab-pane fade" id="Facturas">
                                                    <div class="card">
                                                        <div class="card-body" style="padding-top: 5px;">
                                                            <div class="d-flex align-items-left flex-column">
                                                                <div class="nav-scroller d-flex">
                                                                    <div class="nav nav-line d-flex align-items-center justify-contents-center">
                                                                        <a class="nav-link active" data-toggle="pill" href="#fac_pendientes" role="tab" aria-controls="fac_pendientes" aria-selected="true" style="padding: 0px 0px 20px 0 !important;">Pendientes ({{ facturasPendientes.length }})</a>
                                                                        <a class="nav-link" data-toggle="pill" href="#fac_pagas" role="tab" aria-controls="fac_pagas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;">Pagas ({{ facturas.length }})</a>
                                                                        <a class="nav-link" data-toggle="pill" href="#fac_anuladas" role="tab" aria-controls="fac_anuladas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;">Anuladas ({{ facturasAnuladas.length }})</a>
                                                                    </div>
                                                                    <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">
                                                                        <a href="#" class="btn btn-info btn-border btn-round btn-sm" @click.prevent="ruta='cmpfactura'" data-toggle="modal" data-target="#modal_buscar_proveedor"> <span class="btn-label"> <i class="fa fa-plus"></i></span> Nueva factura</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12">
                                                                    <form>
                                                                        <div class="form-row">
                                                                            <div class="col-md-8">
                                                                                <!--<input type="text"> -->
                                                                            </div>
                                                                            <div class="col-md-2">
                                                                                <div class="form-group">
                                                                                    <label>Filtrar por Mes</label>
                                                                                    <select name="mes" class="form-control custom-select" v-model="mes" @change="obtenerFacturas()">
                                                                                        <option value="0">Todos los meses</option>
                                                                                        <option value="01">Enero</option>
                                                                                        <option value="02">Febrero</option>
                                                                                        <option value="03">Marzo</option>
                                                                                        <option value="04">Abril</option>
                                                                                        <option value="05">Mayo</option>
                                                                                        <option value="06">Junio</option>
                                                                                        <option value="07">Julio</option>
                                                                                        <option value="08">Agosto</option>
                                                                                        <option value="09">Septiembre</option>
                                                                                        <option value="10">Octubre</option>
                                                                                        <option value="11">Noviembre</option>
                                                                                        <option value="12">Diciembre</option>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-2">
                                                                                <div class="form-group">
                                                                                    <label>Filtrar por Año</label>
                                                                                    <select name="anio" class="form-control custom-select" v-model="anio" @change="obtenerFacturas()">
                                                                                        <?php for ($m = date('o'); $m >= 2019; $m--) {
                                                                                            if ($m == date('o')) {
                                                                                                echo '<option value="' . $m . '" selected>' . $m . '</option>';
                                                                                            } else {
                                                                                                echo '<option value="' . $m . '">' . $m . '</option>';
                                                                                            }
                                                                                        }
                                                                                        ?>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                            <div class="tab-content mt-4">
                                                                <div class="tab-pane fade show active" id="fac_pendientes">
                                                                    <div class="table-responsive" :class="cargando_tabla">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_facturas_pendientes">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th>Proveedor</th>
                                                                                    <th>#Factura</th>
                                                                                    <th>Acumulado</th>
                                                                                    <th>Pendiente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                    <th>Cambiar Estado</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tbody>
                                                                                <tr v-for="row in facturasPendientes">
                                                                                    <td class="text-center" style="width: 10%; font-size: 12px;"><a :href="'cmpfacturaeditar/verFactura/'+row.id">FACC{{ row.correlativo }}</a></td>
                                                                                    <td class="text-left" style="width: 34%; font-size: 11px;">{{ row.cliente }}</td>
                                                                                    <td class="text-left" style="width: 34%; font-size: 11px;">{{ row.factura }}</td>
                                                                                    <td class="text-right" style="width: 12%; font-size: 11px;">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-right" style="width: 12%; font-size: 11px;">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-right" style="width: 12%; font-size: 11px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-right" style="width: 10%; font-size: 11px;">{{ fechaNormal(row.fecha) }}</td>
                                                                                    <td class="text-center" style="width: 10%;">
                                                                                        <div class="form-button-action">
                                                                                            <div class="input-group-append">
                                                                                                <a href="" @click.prevent="finalizarFactura(row, '1')" title="Finalizar"><i class="fas fa-check text-success btn" style="padding: .65rem;"></i></a>
                                                                                            </div>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade" id="fac_pagas">
                                                                    <div class="table-responsive" :class="cargando_tabla">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_facturas_pagadas">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th>Proveedor</th>
                                                                                    <th>#Factura</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                    <th>Cambiar Estado</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tbody>
                                                                                <tr v-for="row in facturas">
                                                                                    <td class="text-center" style="width: 10%; font-size: 12px;"><a :href="'cmpfacturaeditar/verFactura/'+row.id">FACC{{ row.correlativo }}</a></td>
                                                                                    <td class="text-left" style="width: 45%; font-size: 11px;">{{ row.cliente }}</td>
                                                                                    <td class="text-left" style="width: 34%; font-size: 11px;">{{ row.factura }}</td>
                                                                                    <td class="text-right" style="width: 20%; font-size: 12px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-right" style="width: 10%; font-size: 12px;">{{ fechaNormal(row.fecha) }}</td>
                                                                                    <td class="text-center" style="width: 15%;">
                                                                                        <div class="form-button-action">
                                                                                            <div class="input-group-append">
                                                                                                <a href="" @click.prevent="finalizarFactura(row, '2')" title="Cambiar a Pendiente"><i class="fas fa-highlighter text-warning btn" style="padding: .65rem;"></i></a>
                                                                                            </div>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade" id="fac_anuladas">
                                                                    <div class="table-responsive" :class="cargando_tabla">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_facturas_anuladas">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th>Proveedor</th>
                                                                                    <th>#Factura</th>
                                                                                    <th>Acumulado</th>
                                                                                    <th>Pendiente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tbody>
                                                                                <tr v-for="row in facturasAnuladas">
                                                                                    <td class="text-center" style="width: 10%; font-size: 12px;"><a :href="'cmpfacturaeditar/verFactura/'+row.id">FACC{{ row.correlativo }}</a></td>
                                                                                    <td class="text-left" style="width: 35%; font-size: 11px;">{{ row.cliente }}</td>
                                                                                    <td class="text-left" style="width: 34%; font-size: 11px;">{{ row.factura }}</td>
                                                                                    <td class="text-right" style="width: 15%; font-size: 11px;">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-right" style="width: 15%; font-size: 11px;">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-right" style="width: 15%; font-size: 11px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                                                    <td class="text-right" style="width: 10%; font-size: 11px;">{{ fechaNormal(row.fecha) }}</td>
                                                                                </tr>
                                                                            </tbody>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($cmppedido) : ?>
                                                <div class="<?= ($cmpnotasentrega) ? 'tab-pane fade' : 'tab-pane fade show active'; ?>" id="Pedidos">
                                                    <div class="d-flex align-items-left flex-column">
                                                        <div class="nav-scroller d-flex">
                                                            <div class="nav nav-line d-flex align-items-center justify-contents-center">
                                                                <a class="nav-link active" data-toggle="pill" href="#ped_pendientes" role="tab" aria-controls="ped_pendientes" aria-selected="true" style="padding: 0px 0px 20px 0 !important;">Pendientes ({{pedidosPendientes.length}})</a>
                                                                <a class="nav-link" data-toggle="pill" href="#ped_pagas" role="tab" aria-controls="ped_pagas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;">Pagas ({{pedidos.length}})</a>
                                                                <a class="nav-link" data-toggle="pill" href="#ped_anulados" role="tab" aria-controls="ped_anulados" aria-selected="false" style="padding: 0px 0px 20px 0 !important;">Anulados ({{pedidosAnuladas.length}})</a>
                                                            </div>
                                                            <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">
                                                                <a href="#" class="btn btn-info btn-border btn-round btn-sm" @click.prevent="ruta='cmppedidos'" data-toggle="modal" data-target="#modal_buscar_proveedor"> <span class="btn-label"> <i class="fa fa-plus"></i></span> Nueva pedido</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <form>
                                                                <div class="form-row">
                                                                    <div class="col-md-8">
                                                                        <!--<input type="text"> -->
                                                                    </div>
                                                                    <div class="col-md-2">
                                                                        <div class="form-group">
                                                                            <label>Filtrar por Mes</label>
                                                                            <select name="mes" class="form-control custom-select" v-model="mes" @change="obtenerPedidos()">
                                                                                <option value="0">Todos los meses</option>
                                                                                <option value="01">Enero</option>
                                                                                <option value="02">Febrero</option>
                                                                                <option value="03">Marzo</option>
                                                                                <option value="04">Abril</option>
                                                                                <option value="05">Mayo</option>
                                                                                <option value="06">Junio</option>
                                                                                <option value="07">Julio</option>
                                                                                <option value="08">Agosto</option>
                                                                                <option value="09">Septiembre</option>
                                                                                <option value="10">Octubre</option>
                                                                                <option value="11">Noviembre</option>
                                                                                <option value="12">Diciembre</option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-2">
                                                                        <div class="form-group">
                                                                            <label>Filtrar por Año</label>
                                                                            <select name="anio" class="form-control custom-select" v-model="anio" @change="obtenerPedidos()">
                                                                                <?php for ($m = date('o'); $m >= 2019; $m--) {
                                                                                    if ($m == date('o')) {
                                                                                        echo '<option value="' . $m . '" selected>' . $m . '</option>';
                                                                                    } else {
                                                                                        echo '<option value="' . $m . '">' . $m . '</option>';
                                                                                    }
                                                                                }
                                                                                ?>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                    <div class="tab-content mt-4">
                                                        <div class="tab-pane fade show active" id="ped_pendientes">
                                                            <div class="table-responsive">
                                                                <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_pedidos_pendientes">
                                                                    <thead>
                                                                        <tr class="text-center">
                                                                            <th>Código</th>
                                                                            <th>Cliente</th>
                                                                            <th>Total</th>
                                                                            <th>Fecha</th>
                                                                            <th>Cambiar Estado</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr v-for="row in pedidosPendientes">
                                                                            <td class="text-center" style="width: 10%; font-size: 12px;"><a :href="'cmppedidoseditar/verFactura/'+row.id">PEDC{{ row.correlativo }}</a></td>
                                                                            <td class="text-left" style="width: 35%; font-size: 11px;">{{ row.cliente }}</td>
                                                                            <td class="text-right" style="width: 15%; font-size: 11px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                                            <td class="text-right" style="width: 10%; font-size: 11px;">{{ fechaNormal(row.fecha) }}</td>
                                                                            <td class="text-center" style="width: 10%;">
                                                                                <div class="form-button-action">
                                                                                    <div class="input-group-append">
                                                                                        <a href="" @click.prevent="finalizarPedido(row, '1')" title="Finalizar"><i class="fas fa-check text-success btn" style="padding: .65rem;"></i></a>
                                                                                    </div>
                                                                                    <div class="input-group-append">
                                                                                        <a href="" @click.prevent="finalizarPedido(row, '3')" title="Finalizar"><i class="fas fa-times text-danger btn" style="padding: .65rem;"></i></a>
                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                    <tfoot>
                                                                        <tr>
                                                                            <th>Total:</th>
                                                                            <th></th>
                                                                            <th class="text-right"></th>
                                                                            <th></th>
                                                                            <th></th>
                                                                        </tr>
                                                                    </tfoot>
                                                                </table>
                                                            </div>
                                                        </div>
                                                        <div class="tab-pane fade" id="ped_pagas">
                                                            <div class="table-responsive">
                                                                <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_pedidos_pagadas">
                                                                    <thead>
                                                                        <tr class="text-center">
                                                                            <th>Código</th>
                                                                            <th>Cliente</th>
                                                                            <th>Total</th>
                                                                            <th>Fecha</th>
                                                                            <th>Cambiar Estado</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr v-for="row in pedidos">
                                                                            <td class="text-center" style="width: 10%; font-size: 12px;"><a :href="'cmppedidoseditar/verFactura/'+row.id">PEDC{{ row.correlativo }}</a></td>
                                                                            <td class="text-left" style="width: 35%; font-size: 11px;">{{ row.cliente }}</td>
                                                                            <td class="text-right" style="width: 15%; font-size: 11px;">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                                            <td class="text-right" style="width: 10%; font-size: 11px;">{{ fechaNormal(row.fecha) }}</td>
                                                                            <td class="text-center" style="width: 10%;">
                                                                                <div class="form-button-action">
                                                                                    <div class="input-group-append">
                                                                                        <a href="" @click.prevent="finalizarPedido(row, '2')" title="Finalizar"><i class="fas fa-check text-success btn" style="padding: .65rem;"></i></a>
                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                    <tfoot>
                                                                        <tr>
                                                                            <th>Total:</th>
                                                                            <th></th>
                                                                            <th class="text-right"></th>
                                                                            <th></th>
                                                                            <th></th>
                                                                        </tr>
                                                                    </tfoot>
                                                                </table>
                                                            </div>
                                                        </div>
                                                        <div class="tab-pane fade" id="ped_anulados">
                                                            <div class="table-responsive">
                                                                <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_pedidos_anulados">
                                                                    <thead>
                                                                        <tr class="text-center">
                                                                            <th>Código</th>
                                                                            <th>Cliente</th>
                                                                            <th>Fecha</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr v-for="row in pedidosAnuladas">
                                                                            <td class="text-center" style="width: 10%; font-size: 12px;"><a :href="'cmppedidoseditar/verFactura/'+row.id">PEDC{{ row.correlativo }}</a></td>
                                                                            <td class="text-left" style="width: 35%; font-size: 11px;">{{ row.cliente }}</td>
                                                                            <td class="text-right" style="width: 10%; font-size: 11px;">{{ fechaNormal(row.fecha) }}</td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($cmpnotascreditos) : ?>
                                                <div class="tab-pane fade" id="NotasCredito">
                                                    <div class="card">
                                                        <div class="card-body" style="padding-top: 5px;">
                                                            <div class="d-flex align-items-left flex-column">
                                                                <div class="nav-scroller d-flex">
                                                                    <div class="nav nav-line nav-color-success d-flex align-items-center justify-contents-center">
                                                                        <a class="nav-link active" data-toggle="pill" href="#creditos_activos" role="tab" aria-controls="creditos_activos" aria-selected="true" style="padding: 0px 0px 20px 0 !important;">Activos ({{ creditosActivos.length }})</a>
                                                                        <a class="nav-link" data-toggle="pill" href="#creditos_inactivos" role="tab" aria-controls="creditos_inactivos" aria-selected="false" style="padding: 0px 0px 20px 0 !important;">Inactivos ({{ creditosInactivos.length }})</a>
                                                                    </div>
                                                                    <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">

                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12">
                                                                    <form>
                                                                        <div class="form-row">
                                                                            <div class="col-md-8">
                                                                                <!--<input type="text"> -->
                                                                            </div>
                                                                            <div class="col-md-2">
                                                                                <div class="form-group">
                                                                                    <label>Filtrar por Mes</label>
                                                                                    <select name="mes" class="form-control custom-select" v-model="mes" @change="obtenerNotasdeCredito()">
                                                                                        <option value="0">Todos los meses</option>
                                                                                        <option value="01">Enero</option>
                                                                                        <option value="02">Febrero</option>
                                                                                        <option value="03">Marzo</option>
                                                                                        <option value="04">Abril</option>
                                                                                        <option value="05">Mayo</option>
                                                                                        <option value="06">Junio</option>
                                                                                        <option value="07">Julio</option>
                                                                                        <option value="08">Agosto</option>
                                                                                        <option value="09">Septiembre</option>
                                                                                        <option value="10">Octubre</option>
                                                                                        <option value="11">Noviembre</option>
                                                                                        <option value="12">Diciembre</option>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-2">
                                                                                <div class="form-group">
                                                                                    <label>Filtrar por Año</label>
                                                                                    <select name="anio" class="form-control custom-select" v-model="anio" @change="obtenerNotasdeCredito()">
                                                                                        <?php for ($m = date('o'); $m >= 2019; $m--) {
                                                                                            if ($m == date('o')) {
                                                                                                echo '<option value="' . $m . '" selected>' . $m . '</option>';
                                                                                            } else {
                                                                                                echo '<option value="' . $m . '">' . $m . '</option>';
                                                                                            }
                                                                                        }
                                                                                        ?>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                            <div class="tab-content mt-3">
                                                                <div class="tab-pane fade show active" id="creditos_activos">
                                                                    <div class="table-responsive" :class="cargando_tabla">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_creditos_activos">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th style="width: 10%;">Código</th>
                                                                                    <th style="width: 70%;">Cliente</th>
                                                                                    <th style="width: 10%;">Fecha</th>
                                                                                    <th style="width: 10%;">Detalles</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tbody>
                                                                                <tr v-for="row in creditosActivos">
                                                                                    <td class="text-center" style="width: 10%; font-size:12px;">NCC{{ row.crecmp_id }}</td>
                                                                                    <td class="text-left" style="width: 70%; font-size:11px;">{{ row.prov_razonsocial }}</td>
                                                                                    <td class="text-right" style="width: 10%; font-size:11px;">{{ row.fecha }}</td>
                                                                                    <td class="text-center" style="width: 10%;">
                                                                                        <button type="button" title="Ver detalle" class="btn btn-icon btn-round" @click="verDetalleCredito(row.crecmp_id)">
                                                                                            <i class="fas fa-eye"></i>
                                                                                        </button>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade" id="creditos_inactivos">
                                                                    <div class="table-responsive" :class="cargando_tabla">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_creditos_inactivos">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th style="width: 10%;">Código</th>
                                                                                    <th style="width: 70%;">Cliente</th>
                                                                                    <th style="width: 10%;">Fecha</th>
                                                                                    <th style="width: 10%;">Detalles</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tbody>
                                                                                <tr v-for="row in creditosInactivos">
                                                                                    <td class="text-center" style="width: 10%; font-size:12px;">NCC{{ row.cre_id }}</td>
                                                                                    <td class="text-left" style="width: 70%; font-size:11px;">{{ row.prov_razonsocial }}</td>
                                                                                    <td class="text-right" style="width: 10%; font-size:11px;">{{ row.fecha }}</td>
                                                                                    <td class="text-center" style="width: 10%;">
                                                                                        <button type="button" title="Ver pedido" class="btn btn-icon btn-round" @click="verDetalleCredito(row.crecmp_id)">
                                                                                            <i class="fas fa-eye"></i>
                                                                                        </button>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <div class="tab-pane fade" id="sugerencias">
                                                <div class="d-flex align-items-left flex-column">
                                                    <div class="m-3 d-flex">
                                                        <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">
                                                            <a href="#" class="btn btn-primary btn-border btn-round btn-sm" @click.prevent="obtenerProductosStockBajoLists()"> <span class="btn-label"> <i class="fas fa-sync-alt"></i></span> Actualizar</a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <table id="table_sugerencias" class="display table table-striped table-hover table-head-bg-primary table-bordered-bd-primary no-footer dataTable" style="width:100%">
                                                    <thead>
                                                        <tr>
                                                            <th>Ref.</th>
                                                            <th>Producto</th>
                                                            <th>Vendidos</th>
                                                            <th>Ganancias</th>
                                                            <th>Stock disponible</th>
                                                            <th>Stock min</th>
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="row in sugerencia">
                                                            <td style="width: 10%;">{{row.pro_codigo}}</td>
                                                            <td style="width: 60%;">{{row.pro_descripcion}}</td>
                                                            <td style="width: 10%;">{{row.cantidad}}</td>
                                                             <td style="width: 10%;">{{ moneda(row.ganancias, row.div_locale, row.div_simbolo) }}</td>
                                                            <td style="width: 10%;">{{row.ps_cantidad}}</td>
                                                            <td style="width: 10%;">{{row.ps_stockmin}}</td>
                                                            <td>
                                                            <button type="button" id="proveedor" class="btn btn-icon btn-sm btn-light m-2" style="box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;" @click="modal_proveedores(row.pro_id)">
                                                                <i class="fa fa-users text-info" style="padding: 0rem;"></i>
                                                            </button>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="reportes_venta">
                        <div class="nav nav-pills nav-secondary d-flex align-items-center justify-contents-center mb-3">
                            <?php if ($reporte_general) : ?>
                                <a class="nav-link active" data-toggle="pill" href="#compGeneral" role="tab" aria-controls="compGeneral" aria-selected="true">Reporte general</a>
                            <?php endif; ?>
                            <?php if ($cuentas_pagar) : ?>
                                <a class="nav-link" data-toggle="pill" href="#cmppp" role="tab" aria-controls="cmppp" aria-selected="false">Cmp. Pendientes por pagar</a>
                            <?php endif; ?>
                            <?php if ($facturas_compras) : ?>
                                <a class="nav-link" data-toggle="pill" href="#productoscompra" role="tab" aria-controls="productoscompra" aria-selected="false">Facturas asociadas a las ventas</a>
                            <?php endif; ?>
                            <?php if ($proveedores_frecuente) : ?>
                                <a class="nav-link" data-toggle="pill" href="#proveedorespagados" role="tab" aria-controls="proveedorespagados" aria-selected="false">Pagos mas frecuentes</a>
                            <?php endif; ?>
                            <?php if ($crear_pedido) : ?>
                                <a class="nav-link" data-toggle="pill" href="#crearorden" role="tab" aria-controls="crearorden" aria-selected="false">Crear orden compra</a>
                            <?php endif; ?>
                        </div>
                        <div class="tab-content">
                            <?php if ($reporte_general) : ?>
                                <div class="tab-pane fade show active" id="compGeneral" role="tabpanel">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="card">
                                                <div class="card-title">
                                                    <div class="form-group form-group-default">
                                                        <label for="mdivisas">Año</label>
                                                        <select name="aniocompras" class="form-control custom-select" id="aniocompras" onchange="obtenerIngresosDiariosCompras()">
                                                            <option value="0">Todos</option>
                                                            <?php for ($m = date('o'); $m >= 2019; $m--) {
                                                                if ($m == date('o')) {
                                                                    echo '<option value="' . $m . '" selected>' . $m . '</option>';
                                                                } else {
                                                                    echo '<option value="' . $m . '">' . $m . '</option>';
                                                                }
                                                            }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <canvas id="comprasanualesc" height="230"></canvas>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="card">
                                                <div class="card-title">
                                                    <div class="form-group form-group-default">
                                                        <label for="mdivisas">Año</label>
                                                        <select name="aniocompras" class="form-control custom-select" id="aniocompraMes" onchange="obtenerIngresosDiariosComprasMes()">
                                                            <?php for ($m = date('o'); $m >= 2019; $m--) {
                                                                if ($m == date('o')) {
                                                                    echo '<option value="' . $m . '" selected>' . $m . '</option>';
                                                                } else {
                                                                    echo '<option value="' . $m . '">' . $m . '</option>';
                                                                }
                                                            }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="card-body">
                                                    <canvas id="ventasSemanalescompraMes" height="230"></canvas>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="tab-pane fade" id="cmppp" role="tabpanel">
                                <?php include 'tab_cmppp.php' ?>
                            </div>
                            <div class="tab-pane fade" id="productoscompra" role="tabpanel">
                                <?php include 'tab_productoscompra.php' ?>
                            </div>
                            <?php if ($proveedores_frecuente) : ?>
                                <div class="tab-pane fade" id="proveedorespagados" role="tabpanel">
                                    <?php include 'tab_proveedoresmasfrecuente.php' ?>
                                </div>
                            <?php endif; ?>
                            <div class="tab-pane fade" id="crearorden" role="tabpanel">
                                <?php include 'crear_orden.php' ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modallineas.php'; ?>
    <?php include 'modal_crear_orden.php'; ?>
    <?php include 'modal_detalle_credito.php'; ?>
    <?php include 'modal_proveedores.php'; ?>
</div>
<script src="<?= asset('assets/moment.min.js') ?>"></script>
<script src="<?= asset('assets/underscore-min.js') ?>"></script>

<script src="<?= asset('assets/js/plugin/chart.js/Chart.min.js') ?>"></script>
<script src="<?= asset('assetsvuejs/compras/index.js') ?>"></script>
<link rel="stylesheet" href="<?= asset('assets/buscadorProductos.css') ?>">
<?php include 'modalbuscarproveedor.php'; ?>
<script>
    $(function() {
        let buttonCommon = {
            exportOptions: {
                columns: [0, 1, 2, 3, 4, 5],
                format: {
                    body: function(data, row, column, node) {
                        if (column === 2 || column === 3 || column === 4) {
                            return convertir_a_float(data)
                        } else {
                            return data.replace(/<[^>]*>?/g, '');
                        }
                    }
                }
            }
        };

        $("#tcmpfp").DataTable({
            order: [],
            dom: 'Bfrtip',
            buttons: [
                $.extend(true, {}, buttonCommon, {
                    extend: 'excelHtml5',
                    title: 'Compras pendientes (FACTURAS) ' + moment().format('DD-MM-YYYY'),
                }),
            ]
        });
        $("#tcmpnp").DataTable({
            order: [],
            dom: 'Bfrtip',
            buttons: [
                $.extend(true, {}, buttonCommon, {
                    extend: 'excelHtml5',
                    title: 'Compras pendientes (NOTAS DE ENTREGA) ' + moment().format('DD-MM-YYYY'),
                }),
            ]
        });
    });
</script>