<div id="AppConvertirDocumento" v-cloak>
    <form autocomplete="off" @submit.prevent="convertir" id="modal_form_convertir">
        <div class="modal fade" id="modal_convertir" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Convertir documento</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="fecha_conv">Fecha:</label>
                                    <input type="date" class="form-control" id="fecha_conv" v-model="dataFormConvertir.fecha">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="almacen_conv">Almacen:</label>
                                    <select id="almacen_conv" class="form-control" v-model="dataFormConvertir.almacen">
                                        <option :value="0" disabled>SELECCIONE UN ELEMENTO</option>
                                        <option v-for="row in almacenes" :value="row.alm_id">{{ row.alm_nombre }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="divisa_conv">Divisa:</label>
                                    <select id="divisa_conv" class="form-control" v-model="dataFormConvertir.divisa">
                                        <option :value="0" disabled>SELECCIONE UN ELEMENTO</option>
                                        <option v-for="row in divisas" :value="row.div_id">{{ row.div_nombre }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="serie_conv">Serie:</label>
                                    <select id="serie_conv" class="form-control" v-model="dataFormConvertir.serie">
                                        <option :value="0" disabled>SELECCIONE UN ELEMENTO</option>
                                        <option v-for="row in series" :value="row.ser_id">{{ row.ser_descripcion }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="documento_conv">Documento:</label>
                            <select id="documento_conv" class="form-control" v-model="dataFormConvertir.documento">
                                <option value="1">Nota de Entrega Compra</option>
                            </select>
                        </div>
                        
                        <div class="form-check">
                            <label class="form-check-label">
                                <input class="form-check-input" type="checkbox" v-model="dataFormConvertir.descontar">
                                <span class="form-check-sign">Agregar al inventario</span>
                            </label>
                        </div>
                        <div class="alert alert-warning" v-for="row in errorForm">{{ row }}</div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary  btn-sm" data-dismiss="modal">Cerrar</button>
                        <button v-if="loader_convertir" class="btn btn-sm btn-primary" disabled>
                            <i class="loader loader-info"></i>
                        </button>
                        <button v-else type="submit" class="btn btn-primary  btn-sm">Convertir</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script src="<?= asset('assets/js/plugin/moment/moment.min.js'); ?>"></script>
<script>
    new Vue({
        el: '#AppConvertirDocumento',
        data: {
            documentos: [],
            almacenes: [],
            divisas: [],
            series: [],
            dataFormConvertir: {
                'id': '',
                'fecha': moment().format('YYYY-MM-DD'),
                'documento': '',
                'almacen': '',
                'divisa': '',
                'serie': '',
                'descontar': false,
                'modulo': 1
            },
            errorForm: [],
            loader_convertir: false
        },
        mounted() {
            this.dataFormConvertir.id = document.getElementById('id_fac').value;
        },
        created() {
            axios.get('convertirdocumento/obtenerDatos/' + 1).then(response => {
                this.documentos = response.data.documentos;
                this.almacenes = response.data.almacenes;
                this.divisas = response.data.divisas;
                this.series = response.data.series;
            });
        },
        methods: {
            convertir() {
                this.loader_convertir = true;
                axios({
                    method: 'post',
                    url: 'convertirdocumento/convertirPedidoCompraENNota',
                    data: this.dataFormConvertir,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        location.href = response.data;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => {
                    notificacion('fa fa-ban', '', 'Error al procesar pedido', 'danger');
                }).finally(() => {
                    this.loader_convertir = false;
                });
            },
        }
    });
</script>