<?php

namespace App\Controladores;

use App\Modelos\CmpPedidos;
use Core\Controller;
use Core\Librerias\CarritoCompras;
use Core\Librerias\Http;
use Core\Vista;

final class CmppedidosControlador extends Controller
{
    private $array_errors = [];
    private $carritoCompras;
    private $pedidos_model;

    public function __construct()
    {
        parent::__construct();
        $this->carritoCompras = new CarritoCompras();
        $this->pedidos_model = new CmpPedidos();
    }

    public function nuevaFactura(int $id_proveedor)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD']) {

            $id_proveedor = filter_var($id_proveedor, FILTER_SANITIZE_NUMBER_INT);
            $proveedor = $this->pedidos_model->obtenerProveedor($id_proveedor);
         
            if ($proveedor) {
                $_SESSION["cmpped$proveedor[prov_id]"] = null;
                return Vista::view('cmppedidos/index', [
                    'proveedor'               => $proveedor,
                    'empresa'               => $this->carritoCompras->obtenerDatosEmpresa(),
                    'tipos_de_documentos'   => $this->carritoCompras->obternerTiposDeDocumentos(),
                    'impuestos'             => $this->carritoCompras->obtenerImpuestos(),
                    'paises'                => $this->carritoCompras->obtenerPaises(),
                    'almacenes'             => $this->carritoCompras->obtenerAlmacenesEmpleado(),
                    'series'                => $this->carritoCompras->obtenerSeriesEmpleado(),
                    'divisas'               => $this->carritoCompras->obtenerDivisasParaFacturar()
                ]);
            } else {
                header('Location: ' . ruta_base() . 'compras');
            }
        }
    }
    
    public function buscarProducto()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';
            if (empty($_GET['almacen']))
                $this->array_errors[] = 'El almacen es obligatorio';

            if (empty($this->array_errors)) {

                $id_divisa      = filter_input(INPUT_GET, 'divisa', FILTER_VALIDATE_INT);
                $id_almacen     = filter_input(INPUT_GET, 'almacen', FILTER_VALIDATE_INT);
                $producto       = $this->solicitud->sanitize($_GET['buscar'], FILTER_SANITIZE_STRING);

                $result = $this->carritoCompras->buscarProducto($producto, $id_divisa, $id_almacen, false);
                if (isset($result['errors'])) {
                    return Http::json_response(['errors' => $result['errors']]);
                } else {
                    return Http::json_response($result);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function predeterminarDivisa()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['id_proveedor']))
                $this->array_errors[] = 'El Proveedor es obligatorio';
            if (empty($_GET['id_divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';

            if (empty($this->array_errors)) {

                $id_divisa          = filter_input(INPUT_GET, 'id_divisa', FILTER_VALIDATE_INT);
                $id_proveedor         = filter_input(INPUT_GET, 'id_proveedor', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_GET, 'descuento', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_proveedor && $id_divisa) {
                    $result = $this->carritoCompras->predeterminarDivisa('cmpn', $id_proveedor, $id_divisa, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function cambiarAlmacen(int $id_proveedor)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $_SESSION["cmpped$id_proveedor"] = null;
            Http::json_response(true);
        } else {
            Http::json_response(false);
        }
    }
    public function agregarProducto()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_proveedor']))
                $this->array_errors[] = 'El Proveedor es obligatorio';
            if (empty($_POST['id_producto']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['id_almacen']))
                $this->array_errors[] = 'El Almacen es obligatorio';
            if (empty($_POST['id_divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';

            if (empty($this->array_errors)) {

                $id_proveedor       = filter_input(INPUT_POST, 'id_proveedor', FILTER_VALIDATE_INT);
                $id_producto        = filter_input(INPUT_POST, 'id_producto', FILTER_VALIDATE_INT);
                $id_almacen         = filter_input(INPUT_POST, 'id_almacen', FILTER_VALIDATE_INT);
                $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_proveedor && $id_producto && $id_almacen && $id_divisa) {
                    $result = $this->carritoCompras->agregarProducto('cmpped', $id_proveedor, $id_producto, $id_almacen, $id_divisa, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function actualizarPrecio()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_proveedor']))
                $this->array_errors[] = 'El Proveedor es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';

            if (empty($this->array_errors)) {

                $id_proveedor       = filter_input(INPUT_POST, 'id_proveedor', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRIPPED);
                $precio             = filter_input(INPUT_POST, 'precio', FILTER_SANITIZE_STRING) ?? 0;
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_proveedor) {
                    $result = $this->carritoCompras->actualizarPrecio('cmpped', $id_proveedor, $unique, $precio, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    
    public function actualizarCantidad()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_proveedor']))
                $this->array_errors[] = 'El Proveedor es obligatorio';
            if (empty($_POST['id_producto']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['cantidad']))
                $this->array_errors[] = 'El Cantidad es obligatorio';

            if (empty($this->array_errors)) {

                $id_proveedor       = filter_input(INPUT_POST, 'id_proveedor', FILTER_VALIDATE_INT);
                $id_producto        = filter_input(INPUT_POST, 'id_producto', FILTER_VALIDATE_INT);
                $cantidad           = filter_input(INPUT_POST, 'cantidad', FILTER_VALIDATE_FLOAT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_proveedor && $id_producto && $cantidad) {
                    $result = $this->carritoCompras->actualizarCantidad('cmpped', $id_proveedor, $id_producto, $cantidad, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function actualizarDescripcion()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_proveedor']))
                $this->array_errors[] = 'El Proveedor es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['descripcion']))
                $this->array_errors[] = 'La Descripción es obligatorio';

            if (empty($this->array_errors)) {

                $id_proveedor       = filter_input(INPUT_POST, 'id_proveedor', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRING);
                $descripcion        = $this->solicitud->sanitize($_POST['descripcion'], FILTER_SANITIZE_STRING);

                if ($id_proveedor) {
                    $result = $this->carritoCompras->actualizarDescripcion('cmpped', $id_proveedor, $unique, $descripcion);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function aplicarNuevoIva()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_proveedor']))
                $this->array_errors[] = 'El Proveedor es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['id_iva']))
                $this->array_errors[] = 'El IVA es obligatorio';

            if (empty($this->array_errors)) {

                $id_proveedor       = filter_input(INPUT_POST, 'id_proveedor', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRIPPED);
                $id_iva             = filter_input(INPUT_POST, 'id_iva', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_proveedor && $id_iva) {
                    $result = $this->carritoCompras->aplicarNuevoIva('cmpped', $id_proveedor, $unique, $id_iva, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function aplicarDescuentoProducto()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_proveedor']))
                $this->array_errors[] = 'El Proveedor es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';

            if (empty($this->array_errors)) {

                $id_proveedor       = filter_input(INPUT_POST, 'id_proveedor', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRIPPED);
                $descuento          = filter_input(INPUT_POST, 'descuento', FILTER_SANITIZE_STRING) ?? 0;
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_proveedor) {
                    $result = $this->carritoCompras->aplicarDescuentoProducto('cmpped', $id_proveedor, $unique, $descuento, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function aplicarDescuentoAdicional()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_proveedor'])) {
                $this->array_errors[] = 'El Proveedor es obligatorio';
            } else {

                $id_proveedor = filter_input(INPUT_POST, 'id_proveedor', FILTER_VALIDATE_INT);
                $descuento_global = filter_input(INPUT_POST, 'descuento', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_proveedor) {
                    $result = $this->carritoCompras->aplicarDescuentoAdicional('cmpped', $id_proveedor, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarProducto()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_proveedor']))
                $this->array_errors[] = 'El Proveedor es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';

            if (empty($this->array_errors)) {

                $id_proveedor       = filter_input(INPUT_POST, 'id_proveedor', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRING);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_proveedor) {
                    $result = $this->carritoCompras->eliminarProducto('cmpped', $id_proveedor, $unique, $descuento_global);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function guardarDetallesCliente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['prov_tipoidfiscal']))
                $this->array_errors[] = 'El campo Cedula de identidad es obligatorio';
            if (empty($_POST['prov_cifnif']))
                $this->array_errors[] = 'El campo Tipo de documento es obligatorio';
            if (empty($_POST['prov_razonsocial']))
                $this->array_errors[] = 'El campo Razón social es obligatorio';
            if (empty($_POST['prov_direccion']))
                $this->array_errors[] = 'El campo Dirección es obligatorio';

            if (empty($this->array_errors)) {

                $prov_id                = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                $prov_tipoidfiscal      = filter_input(INPUT_POST, 'prov_tipoidfiscal', FILTER_SANITIZE_NUMBER_INT);
                $prov_cifnif            = filter_input(INPUT_POST, 'prov_cifnif', FILTER_SANITIZE_STRING);
                $prov_razonsocial       = $this->solicitud->sanitize($_POST['prov_razonsocial'], FILTER_SANITIZE_STRING);
                $prov_direccion         = $this->solicitud->sanitize($_POST['prov_direccion'], FILTER_SANITIZE_STRING);
                $prov_paisid            = filter_input(INPUT_POST, 'prov_paisid', FILTER_SANITIZE_NUMBER_INT);
                $prov_estado            = $this->solicitud->sanitize($_POST['prov_estado'], FILTER_SANITIZE_STRING);
                $prov_ciudad            = $this->solicitud->sanitize($_POST['prov_ciudad'], FILTER_SANITIZE_STRING);
                $prov_codigo_postal     = filter_input(INPUT_POST, 'prov_codigo_postal', FILTER_SANITIZE_STRING);

                $result = $this->carritoCompras->editarDetallesCliente($prov_id, [
                    'prov_tipoidfiscal'     => $prov_tipoidfiscal,
                    'prov_cifnif'           => $prov_cifnif,
                    'prov_razonsocial'      => $prov_razonsocial,
                    'prov_direccion'        => $prov_direccion,
                    'prov_paisid'           => $prov_paisid,
                    'prov_estado'           => $prov_estado,
                    'prov_ciudad'           => $prov_ciudad,
                    'prov_codigo_postal'    => $prov_codigo_postal
                ]);

                if (isset($result['errors'])) {
                    return Http::json_response(['errors' => $result['errors']]);
                } else {
                    return Http::json_response($result);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function ventaEnEspera()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            if (empty($_POST['id_proveedor']))
                $this->array_errors[] = 'Acción prohibida';
            if (empty($_POST['id_serie']))
                $this->array_errors[] = 'El campo Serie es obligatorio.';
            if (empty($_POST['fecha']))
                $this->array_errors[] = 'El campo fecha es obligatorio.';

            if (empty($this->array_errors)) {

                $id_proveedor   = filter_input(INPUT_POST, 'id_proveedor', FILTER_VALIDATE_INT);
                $id_serie       = filter_input(INPUT_POST, 'id_serie', FILTER_VALIDATE_INT);
                $fecha          = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
                $observaciones  = filter_input(INPUT_POST, 'observaciones', FILTER_SANITIZE_STRING) ?? '';
                $descuento_global = 0;

                if (!$id_proveedor || !$id_serie)
                    $this->array_errors[] = 'Datos incorrectos';

                if (empty($this->array_errors)) {

                    $result = $this->carritoCompras->guardarCompra('app_cmppedidos', 'cmpped', $id_proveedor, $id_serie, $fecha, $observaciones, $descuento_global,false, false);

                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        $_SESSION["cmpped$id_proveedor"] = null;
                        return Http::json_response($result);
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }
}
