<form autocomplete="off" id="modal_form_pagar" @submit.prevent="pagar">
    <div class="modal fade" id="modal_pagar" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header border-top-0 border-bottom-0">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body border-top-0">
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group form-floating-label">
                                <select class="form-control input-border-bottom" v-model="divisa_pagar" id="pagardivisa" @change="obtenerMetodosSegunDivisa">
                                    <option disabled value="">&nbsp;</option>
                                    <?php foreach ($divisas as $row) : ?>
                                        <option value="<?= $row['div_id'] ?>"><?= $row['div_nombre'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="pagardivisa" class="placeholder">Divisa</label>
                            </div>
                            <div class="form-group form-floating-label">
                                <select class="form-control input-border-bottom" v-model="metodo_pagar" id="pagarmetodo" @change="obtenerCuentasSegunMetodo">
                                    <option disabled value="">&nbsp;</option>
                                    <option v-for="row in metodos_de_pagos" :value="row.md_id">{{ row.mp_nombre }}</option>
                                </select>
                                <label for="pagarmetodo" class="placeholder">Metodo de pago</label>
                            </div>
                            <div class="form-group form-floating-label">
                                <select class="form-control input-border-bottom" v-model="cuenta_pagar" id="pagarcuenta" @change="obtenerSaldoSegunCuenta">
                                    <option disabled value="">&nbsp;</option>
                                    <option v-for="row in cuentas" :value="row.cmp_id">{{ row.bc_alias }} - {{ row.bc_tipo }} - {{ row.ban_codigo }}</option>
                                </select>
                                <label for="pagarcuenta" class="placeholder">Cuenta</label>
                            </div>
                            <div class="form-group">
                                <label for="saldo" class="placeholder">Saldo</label>
                                <input id="saldo" type="text" class="form-control text-right" v-model="saldo_balance" disabled>
                            </div>
                            <div class="form-group form-floating-label">
                                <input id="pagarmonto" type="text" class="form-control input-border-bottom" v-money="moneyPagar" v-model="monto" required>
                                <label for="pagarmonto" class="placeholder">Monto</label>
                            </div>
                            <div class="form-group">
                                <input id="referencia" type="text" class="form-control input-border-bottom" v-model="referencia">
                                <label for="referencia" class="placeholder">#Referencia Operación</label>
                            </div>
                            <div class="col mt-3">
                                <button class="btn btn-primary btn-round btn-block" disabled v-if="cargando">
                                    <i class="loader loader-info"></i>
                                </button>
                                <button type="submit" class="btn btn-primary btn-round btn-block" v-else>pagar</button>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <?php if ($cambiar_factor) : ?>
                                <div class="card card-pricing p-0 m-2" v-if="divisa_predeterminada!=divisa_pagar && divisa_pagar==1">
                                    <b class="text-left text-primary m-2">Factor</b>
                                    <div class="form-group">
                                        <input type="text" class="form-control text-right" id="monto_factor" v-money="moneyPagar" v-model="div_conv_factor" @keyup="factor_b">
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="card card-pricing">
                                <div class="card-header">
                                    <h4 class="card-title">Total</h4>
                                    <div class="card-price">
                                        <span class="price">{{ moneda(total, div_locale, div_simbolo) }}</span>
                                        <br>
                                        <span class="text text-danger">{{ moneda(restante_original, div_locale, div_simbolo) }}</span>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <ul class="specification-list">
                                        <li class="text-danger" @click.prevent="monto=restante" style="cursor:pointer">
                                            <span class="name-specification">Total restante</span>
                                            <span class="status-specification" style="font-size: 20px;">{{ moneda(restante, moneyPagar.locale, moneyPagar.prefix, moneyPagar.precision) }}</span>
                                        </li>
                                        <li>
                                            <span class="name-specification">Monto</span>
                                            <span class="status-specification" style="font-size: 20px;">{{ moneda(monto, moneyPagar.locale, moneyPagar.prefix, moneyPagar.precision) }}</span>
                                        </li>
                                        <li>
                                            <span class="name-specification">Balance</span>
                                            <span class="status-specification" style="font-size: 20px;">{{ balance }}</span>
                                        </li>
                                        <li class="text-warning">
                                            <span class="name-specification">Diferencia</span>
                                            <span class="status-specification" style="font-size: 20px;">{{ diferencia }}</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
