<?php

namespace App\Modelos;

use Core\Database;

class CmpfacturaArticulos extends Database
{
    protected $table = 'app_compras_articulos';
    protected $id = 'cmpart_id';

    public function articulos($id_factura)
    {
        return $this->consultar("SELECT * FROM app_compras_articulos WHERE cmpart_cmpid=$id_factura")->all();
    }

    public function eliminarArticulos($id_factura)
    {
        return $this->consultar("DELETE FROM app_compras_articulos WHERE cmpart_cmpid=$id_factura")->run();
    }

    public function eliminarArticulo($id_factura, $id_producto)
    {
        return $this->consultar("DELETE FROM app_compras_articulos WHERE cmpart_cmpid=$id_factura AND cmpart_proid=$id_producto")->run();
    }

    public function obtenerDetalleProductoFacturado($id_factura, $id_producto, $id_alamcen)
    {
        return $this->consultar("SELECT * FROM app_compras_articulos WHERE cmpart_cmpid=$id_factura AND (cmpart_proid=$id_producto AND cmpart_almid=$id_alamcen)")->row();
    }
}
