<?php

namespace App\Controladores;

use App\Modelos\Cliente;
use App\Modelos\ClienteContactos;
use App\Modelos\Clientedireccionenvios;
use App\Modelos\Documentos;
use App\Modelos\Pais;
use App\Modelos\EmpleadoInfo;
use App\Modelos\EmpleadoAgente;
use App\Modelos\Clienteintereses;
use App\Modelos\Compras;
use App\Modelos\ProductoCategoria;
use App\Modelos\Ingresosegresos;
use App\Modelos\Grupos;
use App\Modelos\Proveedor;
use App\Modelos\Tarifas;
use App\Modelos\Tipodocumentos;
use Core\Controller;
use Core\Helpers\Moneda;
use Core\Helpers\Notifica;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Vista;
use DateTime;

final class ClientesControlador extends Controller
{
    private $clientes;
    private $array_errors = [];
    private $module;
    private $div_master;
    private $ingresosegresos_model;

    public function __construct()
    {
        parent::__construct();
        $this->module   = new Module('clientes');
        $this->clientes = new Cliente();
        $this->div_master = $this->clientes->obtenerDivisaMaster();
        $this->ingresosegresos_model    = new Ingresosegresos();
    }

    public function index()
    {
        return Vista::view('clientes/index', [
            'divisas'               => $this->clientes->obtenerDivisas(),
        ]);
    }

    public function obtenerClientesGrupoT()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response([
                'clientes' => count($this->clientes->obtenerClientes()),
                'grupos' => $this->clientes->totalClientesGrupos(),
            ]);
        }
    }

    public function  obtenerClientes()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $draw = $_POST['draw'];
            $row = $_POST['start'];
            $rowperpage = $_POST['length']; // Rows display per page
            $columnIndex = $_POST['order'][0]['column']; // Column index
            $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
            $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
            $searchValue = $_POST['search']['value'];

            $totalRecordwithFilter = "";
            ## Search 
            $searchQuery = " ";
            if ($searchValue != '') {
                $searchQuery = "WHERE (ac.cli_dni LIKE '%" . $searchValue . "%' OR ac.cli_razon_social LIKE '%" . $searchValue . "%' OR ac.cli_telefono LIKE '%" . $searchValue . "%' OR ac.cli_email LIKE '%" . $searchValue . "%' OR 
            ac.cli_estatus LIKE '%" . $searchValue . "%') ";
            }

            $clientes_simples =  $this->clientes->consultar("SELECT cli_dni, cli_id, cli_razon_social, cli_telefono, cli_email, cli_estatus 
           FROM app_clientes ac 
           LEFT JOIN app_tipo_documentos tp ON tp.tipodoc_id = ac.cli_tipodocid GROUP BY ac.cli_id ORDER BY cli_id ASC")->count();
            $totalRecords = $clientes_simples;

            $searc =  $this->clientes->consultar("SELECT cli_dni, cli_id, cli_razon_social, cli_telefono, cli_email, cli_estatus 
            FROM app_clientes ac 
            LEFT JOIN app_tipo_documentos tp ON tp.tipodoc_id = ac.cli_tipodocid 
            $searchQuery GROUP BY ac.cli_id ORDER BY cli_id ASC")->count();

            $totalRecordwithFilter = $searc;

            ## Fetch records
            if ($rowperpage > 0) {
                $clientes =  $this->clientes->consultar("SELECT cli_dni, cli_id, cli_razon_social, cli_telefono, cli_email, cli_estatus 
                FROM app_clientes ac 
                LEFT JOIN app_tipo_documentos tp ON tp.tipodoc_id = ac.cli_tipodocid  
                 $searchQuery GROUP BY " . $columnName . " ORDER BY cli_id " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();
            } else {
                $clientes =  $this->clientes->consultar("SELECT cli_dni, cli_id, cli_razon_social, cli_telefono, cli_email, cli_estatus 
                FROM app_clientes ac 
                LEFT JOIN app_tipo_documentos tp ON tp.tipodoc_id = ac.cli_tipodocid  
                 $searchQuery GROUP BY " . $columnName . " ORDER BY cli_id " . $columnSortOrder . " ")->all();
            }

            echo json_encode([
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordwithFilter,
                "aaData" => $clientes
            ]);
        }
    }

    public function txt_clientes()
    {
        // $archivo=fopen('archivo.txt','w') or die ('error');
        //fwrite($archivo,'Probangggdo');
        // fwrite($archivo,'fsfsfs');
        //  fclose($archivo);
        //$cliCont = new ClienteContactos();
        //$clientes = $cliCont->obtenerClientestxt();
        $clientes =  $this->clientes->obtenerClientes();
        $texto = '';
        $n = 0;
        if (is_countable($clientes) && count($clientes)) {

            foreach ($clientes as $row) {
                $tele = str_replace('(', '', $row['cli_telefono']);
                $tele = str_replace(')', '', $tele);
                $tele = str_replace(' ', '', $tele);
                $tele = extraer_numero_de_cadena($tele);
                $tele1 = substr($tele, 0, 3);
                $tele2 = substr($tele, 3, 2);
                $tele3 = substr($tele, 5, 2);
                $tele4 = substr($tele, 7, 3);
                $tele = '+58 ' . $tele1 . ' ' . $tele2 . ' ' . $tele3 . ' ' . $tele4;

                $n + 1;
                if ($n == count($clientes)) {
                    if ($row['cli_email'] != '' and $row['cli_telefono'] != '') {
                        $texto .= $row['cli_email'] . ' ' . $tele;
                    }
                } else {
                    if ($row['cli_email'] != '' and $row['cli_telefono'] != '') {
                        $texto .= $row['cli_email'] . ', ' . $tele . "\r\n";
                    }
                }
            }

            // header("Content-Disposition: attachment; filename=texto.txt");
            header("Pragma:public");
            header("Content-Type: application/force-download");
            header("Content-Disposition: attachment; filename=texto.txt");
            echo ($texto);
            //readfile("texto.txt");
            exit;
        } else {
            Http::json_response('error');
        }
    }

    //OBTIENE LOS PRODUCTOS DE DOCUEMENTOS GENERADOS VENIDOS
    public function obtenerClientesCompran()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $fecha_desde    = filter_input(INPUT_GET, 'fecha_desde', FILTER_SANITIZE_STRING);
            $fecha_hasta    = filter_input(INPUT_GET, 'fecha_hasta', FILTER_SANITIZE_STRING);
            $div_id = filter_input(INPUT_GET, 'divisa', FILTER_SANITIZE_NUMBER_INT);

            if (empty($fecha_desde))
                $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');

            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (empty($this->array_errors)) {

                if (!validateDate($fecha_desde, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha desde es incorrecta.';
                if (!validateDate($fecha_hasta, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha hasta es incorrecta.';

                if (empty($this->array_errors)) {

                    $artic_total        = 0;
                    $documento_total        = 0;
                    $venta_total        = 0;
                    $totales_productos  = [];
                    $total_productos_id = [];

                    $clients =  $this->clientes->obtenerClientes();

                    if (is_countable($clients) && count($clients)) {

                        foreach ($clients as $pro) {

                            $total_notas = $this->clientes->obtenerClientesDeNEV($pro['cli_id'], $fecha_desde, $fecha_hasta, $div_id);
                            $total_ordenes = $this->clientes->obtenerClientesDeOrd($pro['cli_id'], $fecha_desde, $fecha_hasta, $div_id);
                            $total_facv = $this->clientes->obtenerClientesDeFACV($pro['cli_id'], $fecha_desde, $fecha_hasta, $div_id);
                            $divisa = $this->clientes->obtenerDivisa($div_id);

                            if (is_countable($total_notas) && count($total_notas)) {

                                foreach ($total_notas as $row) {

                                    $ganancia = 0;
                                    $ganancia_porct = 0;

                                    if ($row['total'] > 0 && $row['total_costo'] > 0) {
                                        $ganancia_porct = round(((($row['total'] - $row['total_costo'])) * 100 / $row['total']), 2);
                                    }

                                    $articulos = $this->clientes->obtenerClientesDeNEVart($row['ne_id']);
                                    $cantidad = 0;

                                    foreach ($articulos as $articulo) {
                                        $cantidad = $articulo['cantidad'];
                                    }

                                    if (!in_array($pro['cli_id'], $total_productos_id)) {
                                        $totales_productos[$pro['cli_id']] = [
                                            'div_locale'        => $divisa['div_locale'],
                                            'div_simbolo'       => $divisa['div_simbolo'],
                                            'div_nombre'        => $divisa['div_nombre'],
                                            'cli_id'            => $pro['cli_id'],
                                            'cli_razon_social'  => $pro['cli_razon_social'],
                                            'cantidad'          =>   $cantidad,
                                            'cantidad_documento' => 1,
                                            'total'             => $row['total'],
                                            'costo'             => $row['total_costo'],
                                            'ganancia'          => $row['total'] - $row['total_costo'],
                                            'ganancia_porct'    => $ganancia_porct,
                                        ];
                                        $total_productos_id[] = $pro['cli_id'];
                                    } else {

                                        $totales_productos[$pro['cli_id']]['costo']          += $row['total_costo'];
                                        $totales_productos[$pro['cli_id']]['cantidad']          +=  $cantidad;
                                        $totales_productos[$pro['cli_id']]['cantidad_documento']          += 1;
                                        $totales_productos[$pro['cli_id']]['total']             += $row['total'];
                                        $totales_productos[$pro['cli_id']]['ganancia']             += $row['total'] - $row['total_costo'];
                                        $totales_productos[$pro['cli_id']]['ganancia_porct'] =  round((($totales_productos[$pro['cli_id']]['total'] - $totales_productos[$pro['cli_id']]['costo']) * 100 / $totales_productos[$pro['cli_id']]['total']), 2);
                                    }
                                }
                            }

                            if (is_countable($total_facv) && count($total_facv)) {

                                foreach ($total_facv as $row_dos) {

                                    $ganancia = 0;
                                    $ganancia_porct = 0;

                                    if ($row['total'] > 0 && $row['total_costo'] > 0) {
                                        $ganancia_porct = round(((($row['total'] - $row['total_costo'])) * 100 / $row['total']), 2);
                                    }
                                    $articulos = $this->clientes->obtenerClientesDeFACVart($row['fm_id']);
                                    $cantidad = 0;
                                    foreach ($articulos as $articulo) {
                                        $cantidad = $articulo['cantidad'];
                                    }

                                    if (!in_array($pro['cli_id'], $total_productos_id)) {
                                        $totales_productos[$pro['cli_id']] = [
                                            'div_locale'        => $divisa['div_locale'],
                                            'div_simbolo'       => $divisa['div_simbolo'],
                                            'div_nombre'        => $divisa['div_nombre'],
                                            'cli_id'            => $pro['cli_id'],
                                            'cli_razon_social'  => $pro['cli_razon_social'],
                                            'cantidad'          => $row['cantidad'],
                                            'cantidad_documento' => $cantidad,
                                            'total'             => $row['total'],
                                            'costo'             => $row['total_costo'],
                                            'ganancia'          => $row['total'] - $row['total_costo'],
                                            'ganancia_porct'    => $ganancia_porct,
                                        ];
                                        $total_productos_id[] = $pro['cli_id'];
                                    } else {

                                        $totales_productos[$pro['cli_id']]['costo']          += $row['total_costo'];
                                        $totales_productos[$pro['cli_id']]['cantidad']          += $cantidad;
                                        $totales_productos[$pro['cli_id']]['total']             += $row['total'];
                                        $totales_productos[$pro['cli_id']]['cantidad_documento']          += 1;
                                        $totales_productos[$pro['cli_id']]['ganancia']             += $row['total'] - $row['total_costo'];
                                        $totales_productos[$pro['cli_id']]['ganancia_porct'] =  round((($totales_productos[$pro['cli_id']]['total'] - $totales_productos[$pro['cli_id']]['costo']) * 100 / $totales_productos[$pro['cli_id']]['total']), 2);
                                    }
                                }
                            }

                            if (is_countable($total_ordenes) && count($total_ordenes)) {

                                foreach ($total_ordenes as $row) {

                                    $ganancia = 0;
                                    $ganancia_porct = 0;

                                    if ($row['total'] > 0 && $row['total_costo'] > 0) {
                                        $ganancia_porct = round(((($row['total'] - $row['total_costo'])) * 100 / $row['total']), 2);
                                    }

                                    $articulos = $this->clientes->obtenerClientesDeOrdart($row['n_id']);

                                    $cantidad = 0;
                                    foreach ($articulos as $articulo) {
                                        $cantidad = $articulo['cantidad'];
                                    }

                                    if (!in_array($pro['cli_id'], $total_productos_id)) {
                                        $totales_productos[$pro['cli_id']] = [
                                            'div_locale'        => $divisa['div_locale'],
                                            'div_simbolo'       => $divisa['div_simbolo'],
                                            'div_nombre'        => $divisa['div_nombre'],
                                            'cli_id'            => $pro['cli_id'],
                                            'cli_razon_social'  => $pro['cli_razon_social'],
                                            'cantidad'          => $row['cantidad'],
                                            'cantidad_documento' => $cantidad,
                                            'total'             => $row['total'],
                                            'costo'             => $row['total_costo'],
                                            'ganancia'          => $row['total'] - $row['total_costo'],
                                            'ganancia_porct'    => $ganancia_porct,
                                        ];
                                        $total_productos_id[] = $pro['cli_id'];
                                    } else {

                                        $totales_productos[$pro['cli_id']]['costo']          += $row['total_costo'];
                                        $totales_productos[$pro['cli_id']]['cantidad']          += $cantidad;
                                        $totales_productos[$pro['cli_id']]['total']             += $row['total'];
                                        $totales_productos[$pro['cli_id']]['cantidad_documento']          += 1;
                                        $totales_productos[$pro['cli_id']]['ganancia']             += $row['total'] - $row['total_costo'];

                                        $totales_productos[$pro['cli_id']]['ganancia_porct'] =  round((($totales_productos[$pro['cli_id']]['total'] - $totales_productos[$pro['cli_id']]['costo']) * 100 / $totales_productos[$pro['cli_id']]['total']), 2);
                                    }
                                }
                            }
                        }
                    }

                    Http::json_response([
                        'ganancia_porc' => 0,
                        'clientes'     => $totales_productos,
                        'cantidad_articulos' =>  count($totales_productos)
                    ]);
                }
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }

    public function obtenerClientesActivosInactivos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response([
                'activos' => $this->clientes->totalClientesActivos(),
                'inactivos' => $this->clientes->totalClientesInactivos(),
            ]);
        }
    }

    public function crear()
    {
        $new_grupos = new Grupos();
        $new_pais   = new Pais();
        $newTipoDoc = new Tipodocumentos();

        return Vista::view('clientes/crear', [
            'paises' => $new_pais->todos(),
            'grupos' => $new_grupos->todos(),
            'tipos_de_documento' => $newTipoDoc->todos()
        ]);
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newCliContacto = new ClienteContactos();
            $cliente_direccion_envio_model = new Clientedireccionenvios();

            if (empty($_POST['cli_tipodoc']))
                $this->array_errors[] = "El campo Tipo de documento es obligatorio.";
            if (empty($_POST['cli_dni']))
                $this->array_errors[] = "El campo DNI obligatorio.";
            if (empty($_POST['cli_razon_social']))
                $this->array_errors[] = "El campo Nombre es obligatorio.";
            if (empty($_POST['cli_telefono']))
                $this->array_errors[] = "El campo Teléfono es obligatorio.";
            if (empty($_POST['cli_paisid']))
                $this->array_errors[] = "El campo Pais es obligatorio.";
            if (empty($_POST['cli_direccion']))
                $this->array_errors[] = "El campo Direccion es obligatorio.";

            if (empty($this->array_errors)) {

                $cli_tipodoc        = filter_input(INPUT_POST, 'cli_tipodoc', FILTER_VALIDATE_INT);
                $cli_dni            = $this->solicitud->sanitize($_POST['cli_dni']);
                $cli_razon_social   = $this->solicitud->sanitize($_POST['cli_razon_social']);
                $cli_fecha_nac      = $this->solicitud->sanitize($_POST['cli_fecha_nac']);
                $cli_telefono       = $this->solicitud->sanitize($_POST['cli_telefono']);
                $cli_telefono_2     = $this->solicitud->sanitize($_POST['cli_telefono_2']);
                $cli_direccion      = $this->solicitud->sanitize($_POST['cli_direccion']);
                $cli_paisid         = filter_input(INPUT_POST, 'cli_paisid', FILTER_VALIDATE_INT);
                $cli_estado         = $this->solicitud->sanitize($_POST['cli_estado']);
                $cli_ciudad         = $this->solicitud->sanitize($_POST['cli_ciudad']);
                $cli_codpostal      = $this->solicitud->sanitize($_POST['cli_codpostal']);
                $cli_grupid         = $_POST['cli_grupid'];
                $cli_natural        = ('true' == filter_input(INPUT_POST, 'cli_natural')) ? 1 : 0;

                if ($cli_tipodoc && $cli_paisid) {

                    if (!empty($_POST['cli_email'])) {
                        $cli_email = $this->solicitud->sanitize($_POST['cli_email'], FILTER_VALIDATE_EMAIL);
                        if (!$cli_email)
                            $this->array_errors[] = 'Correo invalido';
                        if ($this->clientes->existe('cli_email', $cli_email))
                            $this->array_errors[] = "El Correo electronico $cli_email ya se encuentra en uso";
                    } else {
                        $cli_email = NULL;
                    }

                    if ($this->clientes->existe('cli_dni', $cli_dni))
                        $this->array_errors[] = "La Cedula de identidad $cli_dni ya se encuentra en uso";

                    if (empty($cli_telefono)) {
                        $cli_telefono = NULL;
                    } else {
                        if (strlen($cli_telefono) < 15 || strlen($cli_telefono) > 50)
                            $this->array_errors[] = 'El número de telefono es incorrecto';
                    }

                    if (empty($this->array_errors)) {

                        $data_form = [
                            'cli_tipodocid'      => $cli_tipodoc,
                            'cli_dni'            => $cli_dni,
                            'cli_razon_social'   => $cli_razon_social,
                            'cli_email'          => $cli_email,
                            'cli_telefono'       => $cli_telefono,
                            'cli_telefono_2'     => $cli_telefono_2,
                            'cli_direccion'      => $cli_direccion,
                            'cli_paisid'         => $cli_paisid,
                            'cli_estado'         => $cli_estado,
                            'cli_ciudad'         => $cli_ciudad,
                            'cli_codpostal'      => $cli_codpostal,
                            'cli_contribuyente'  => 1,
                            'cli_natural'        => $cli_natural
                        ];

                        if (!empty($cli_fecha_nac)) {
                            if (validateDate($cli_fecha_nac, 'Y-m-d')) {
                                $data_form['cli_fecha_nac'] = $cli_fecha_nac;
                            } else {
                                $this->array_errors[] = "La fecha de nacimiento es incorrecta";
                            }
                        }

                        if (!empty($cli_grupid)) {
                            $data_form['cli_grupid'] = $cli_grupid;
                        }

                        if (empty($this->array_errors)) {

                            $data_id = $this->clientes->guardar($data_form);

                            if (empty($cli_telefono)) $cli_telefono = NULL;

                            if ($data_id) {

                                Notifica::crearNotificacion(3, "Ha creado el cliente <strong>$cli_razon_social</strong>");

                                $newCliContacto->guardar([
                                    'ccon_cliid'    => $data_id,
                                    'ccon_nombre'   => $cli_razon_social,
                                    'ccon_cargo'    => 'Personal',
                                    'ccon_telefono' => $cli_telefono,
                                    'ccon_email'    => $cli_email,
                                ], true);

                                if (empty($_POST['contactoID'])) {
                                } else {
                                    $id = filter_input(INPUT_POST, 'contactoID', FILTER_SANITIZE_NUMBER_INT);
                                    Http::json_response($newCliContacto->editar($id, $data_form));
                                }

                                $cliente_direccion_envio_model->guardar([
                                    'cde_cliid'                 => $data_id,
                                    'cde_direccion'             => $cli_direccion,
                                    'cde_pais'                  => $cli_paisid,
                                    'cde_estado'                => $cli_estado,
                                    'cde_ciudad'                => $cli_ciudad,
                                    'cde_codigo_postal'         => $cli_codpostal
                                ]);

                                Http::json_response(true);
                            } else {
                                Http::json_response(false);
                            }
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function ver(int $cli_id)
    {
        $id = filter_var($cli_id, FILTER_SANITIZE_NUMBER_INT);

        if (!$this->clientes->existe('cli_id', $id)) {
            Http::notFound();
        }

        $documentos_model       = new Documentos();
        $tipodocumentos_model   = new Tipodocumentos();
        $pais_model             = new Pais();
        $grupos                 = new Grupos();
        $empleadov              = new EmpleadoInfo();
        $tarifas                = new Tarifas();

        return Vista::view('clientes/ver', [
            'grupos'                => $grupos->todos(),
            'tarifas'               => $tarifas->consultar("SELECT * FROM app_tarifas")->all(),
            'documentos'            => $documentos_model->documentosActivos(),
            'tipo_de_documentos'    => $tipodocumentos_model->todos(),
            'paises'                => $pais_model->todos(),
            'cliente'               => $this->clientes->obtenerClienteID($id),
            'empleado'              => $empleadov->agentesventa()
        ]);
    }

    public function editar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax() && !empty($_POST['id'])) {
            $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
            if ($id) {

                if ($this->clientes->existe('cli_id', $id)) {

                    if (empty($_POST['tipo_documento']))
                        $this->array_errors[] = "El campo Tipo de documento es obligatorio.";
                    if (empty($_POST['dni']))
                        $this->array_errors[] = "El campo DNI obligatorio.";
                    if (empty($_POST['razon_social']))
                        $this->array_errors[] = "El campo Razón social es obligatorio.";
                    if (empty($_POST['telefono']))
                        $this->array_errors[] = "El campo Teléfono es obligatorio.";

                    if (empty($this->array_errors)) {

                        $cli_tipodocid      = filter_input(INPUT_POST, 'tipo_documento', FILTER_VALIDATE_INT);
                        $cli_dni            = $this->solicitud->sanitize($_POST['dni']);
                        $cli_razon_social   = $this->solicitud->sanitize($_POST['razon_social']);
                        $cli_fecha_nac      = $this->solicitud->sanitize($_POST['fecha_nac']);
                        $cli_telefono       = $this->solicitud->sanitize($_POST['telefono']);
                        $cli_telefono_2     = $this->solicitud->sanitize($_POST['telefono_2']);
                        $cli_tarpid         = $_POST['tarifa'] ? $_POST['tarifa'] : NULL;
                        $cli_grupid         = $_POST['grupo'] ? $_POST['grupo'] : NULL;

                        if ($cli_tipodocid) {

                            if (!empty($_POST['correo'])) {
                                $cli_email = $this->solicitud->sanitize($_POST['correo'], FILTER_VALIDATE_EMAIL);
                                if (!$cli_email)
                                    $this->array_errors[] = 'Correo invalido';
                                if ($this->clientes->correoExiste($id, $cli_email))
                                    $this->array_errors[] = "El correo $cli_email ya esta siendo usado por otro cliente";
                            } else {
                                $cli_email = NULL;
                            }

                            //if (valida_email($cli_email) == false)
                            //array_push($this->array_errors, "El correo no es correcto");

                            if ($this->clientes->cedulaExiste($id, $cli_dni))
                                $this->array_errors[] = "El DNI $cli_dni ya esta siendo usado por otro cliente";

                            if (empty($this->array_errors)) {

                                $data_form = [
                                    'cli_tipodocid'     => $cli_tipodocid,
                                    'cli_dni'           => $cli_dni,
                                    'cli_razon_social'  => $cli_razon_social,
                                    'cli_email'         => $cli_email,
                                    'cli_telefono'      => $cli_telefono,
                                    'cli_telefono_2'    => $cli_telefono_2,
                                    'cli_grupid'        => $cli_grupid,
                                    'cli_gruptarid'     => $cli_tarpid
                                ];

                                if (!empty($cli_fecha_nac)) {
                                    if (validateDate($cli_fecha_nac, 'Y-m-d')) {
                                        $data_form['cli_fecha_nac'] = $cli_fecha_nac;
                                    } else {
                                        $this->array_errors[] = "La fecha de nacimiento es incorrecta";
                                    }
                                }

                                if (empty($this->array_errors)) {
                                    if ($this->clientes->editar($id, $data_form)) {
                                        Notifica::crearNotificacion(3, "Ha actualizado los datos de el cliente <strong>$cli_razon_social</strong>");
                                        Http::json_response(true);
                                    } else {
                                        Http::json_response(false);
                                    }
                                }
                            }
                        }
                    }

                    Http::json_response(['errors' => $this->array_errors]);
                } else {
                    Http::json_response(false);
                }
            }
        }

        Http::json_response(false);
    }

    public function editarDireccion()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_POST['id'])) {

                $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);

                if ($id) {

                    if ($this->clientes->existe('cli_id', $id)) {

                        if (empty($_POST['direccion']))
                            $this->array_errors[] = "El campo Dirección es obligatorio.";
                        if (empty($_POST['pais']))
                            $this->array_errors[] = "El campo Pís es obligatorio.";
                        if (empty($_POST['estado']))
                            $this->array_errors[] = "El campo Estado es obligatorio.";
                        if (empty($_POST['ciudad']))
                            $this->array_errors[] = "El campo Ciudad es obligatorio.";
                        if (empty($_POST['codigo_postal']))
                            $this->array_errors[] = "El campo Código postal es obligatorio.";

                        if (empty($this->array_errors)) {

                            $data_cliente = $this->clientes->obtener($id);

                            if ($data_cliente) {

                                $direccion      = $this->solicitud->sanitize($_POST['direccion']);
                                $pais           = filter_input(INPUT_POST, 'pais', FILTER_VALIDATE_INT);
                                $estado         = $this->solicitud->sanitize($_POST['estado']);
                                $ciudad         = $this->solicitud->sanitize($_POST['ciudad']);
                                $codigo_postal  = $this->solicitud->sanitize($_POST['codigo_postal']);
                                $lat  = $this->solicitud->sanitize($_POST['lat']);
                                $lng  = $this->solicitud->sanitize($_POST['lng']);

                                if ($this->clientes->editar($id, [
                                    'cli_direccion'  => $direccion,
                                    'cli_paisid'     => $pais,
                                    'cli_estado'     => $estado,
                                    'cli_ciudad'     => $ciudad,
                                    'cli_codpostal'  => $codigo_postal,
                                    'cli_lat'  => $lat,
                                    'cli_lng'  => $lng,

                                ])) {
                                    Notifica::crearNotificacion(3, "Ha actualizado la dirección de el cliente <strong>{$data_cliente['cli_razon_social']}</strong>");
                                    Http::json_response(true);
                                } else {
                                    Http::json_response(false);
                                }
                            }
                        }
                    } else {
                        Http::json_response(false);
                    }

                    Http::json_response(['errors' => $this->array_errors]);
                }
            }

            Http::json_response(false);
        }
    }

    public function modificarEstatus(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->clientes->existe('cli_id', $id)) {

                $data_cliente = $this->clientes->obtener($id);

                $estatus_nombre = $data_cliente['cli_estatus'] ? 'Inactivo' : 'Activo';

                $res = $this->clientes->editar($id, [
                    'cli_estatus' => $data_cliente['cli_estatus'] ? 0 : 1
                ]);

                if ($res) {
                    Notifica::crearNotificacion(3, "Ha cambiado el estatus del cliente <strong>{$data_cliente['cli_razon_social']}</strong> a <strong>$estatus_nombre</strong>");
                }

                Http::json_response($res);
            } else {
                Http::json_response(false);
            }
        }
    }

    public function eliminarCliente(int $id_cliente)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->clientes->existe('cli_id', $id_cliente)) {

                $data = $this->clientes->consultar("SELECT fm_id FROM app_factura_master WHERE fm_cliid = $id_cliente")->row();
                $data = $this->clientes->consultar("SELECT ne_id FROM app_notas_de_entrega WHERE ne_cliid = $id_cliente")->row();
                $data = $this->clientes->consultar("SELECT pe_id FROM app_pedidos WHERE pe_cliid = $id_cliente")->row();
                $data = $this->clientes->consultar("SELECT cre_id FROM app_nota_de_credito WHERE cre_cliid = $id_cliente")->row();
                $data = $this->clientes->consultar("SELECT pre_id FROM app_presupuesto WHERE pre_cliid = $id_cliente")->row();

                if ($data) {
                    Http::json_response(['errors' => ['Lo siento no puede eliminar el cliente ya que tiene documentos asociados']]);
                } else {

                    $data_cliente = $this->clientes->obtener($id_cliente);

                    $res = $this->clientes->eliminar($id_cliente);

                    if ($res) {
                        Notifica::crearNotificacion(3, "Ha eliminado el cliente <strong>{$data_cliente['cli_razon_social']}</strong>");
                    }

                    Http::json_response($res);
                }
            } else {
                Http::json_response(false);
            }
        }
    }

    public function proveedor($id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id     = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            $cliente = $this->clientes->obtener($id);

            $new_proveedor = new Proveedor();

            if ($cliente) {

                if (
                    $this->clientes->chuequearProveedor("prov_codigo = '{$cliente['cli_dni']}'") ||
                    $this->clientes->chuequearProveedor("prov_razonsocial = '{$cliente['cli_razon_social']}'") ||
                    $this->clientes->chuequearProveedor("prov_cifnif = '{$cliente['cli_dni']}'")
                ) {
                    $this->array_errors[] = 'El cliente ya se encuentra como proveedor.';
                }

                if (empty($this->array_errors)) {
                    if ($new_proveedor->guardar([
                        'prov_codigo'           => $cliente['cli_dni'],
                        'prov_nombre'           => $cliente['cli_razon_social'],
                        'prov_razonsocial'      => $cliente['cli_razon_social'],
                        'prov_tipoidfiscal'     => $cliente['cli_tipodocid'],
                        'prov_cifnif'           => $cliente['cli_dni'],
                        'prov_personafisica'    => 0,
                        'prov_telefono1'        => $cliente['cli_telefono'],
                        'prov_telefono2'        => $cliente['cli_telefono_2'],
                        'prov_email'            => $cliente['cli_email'],
                        'prov_paisid'           => $cliente['cli_paisid'],
                        'prov_estado'           => $cliente['cli_estado'],
                        'prov_ciudad'           => $cliente['cli_ciudad'],
                        'prov_codigo_postal'    => $cliente['cli_codpostal'],
                        'prov_direccion'        => $cliente['cli_direccion'],
                        'prov_observaciones'    => $cliente['cli_observaciones'],
                    ], true)) {
                        Notifica::crearNotificacion(3, "Ha convertido al cliente <strong>{$cliente['cli_razon_social']}</strong> como proveedor");
                        Http::json_response(true);
                    } else {
                        Http::json_response(false);
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function verCliente($id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($this->clientes->existe('cli_id', $id)) {
                Http::json_response($this->clientes->obtenerClienteID($id));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function guardarDireccionEnvio()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_POST['id'])) {

                if (empty($_POST['pais']))
                    $this->array_errors[] = "El campo País es obligatorio.";
                if (empty($_POST['estado']))
                    $this->array_errors[] = "El campo Estado es obligatorio.";
                if (empty($_POST['ciudad']))
                    $this->array_errors[] = "El campo Ciudad es obligatorio.";
                if (empty($_POST['codigo_postal']))
                    $this->array_errors[] = "El campo Código postal es obligatorio.";
                if (empty($_POST['direccion']))
                    $this->array_errors[] = "El campo Dirección es obligatorio.";

                $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);

                if ($id) {

                    if ($this->clientes->existe('cli_id', $id)) {

                        if (empty($this->array_errors)) {

                            $id_envio = filter_input(INPUT_POST, 'id_envio', FILTER_SANITIZE_NUMBER_INT);
                            $pais = filter_input(INPUT_POST, 'pais', FILTER_SANITIZE_NUMBER_INT);
                            $estado = $this->solicitud->sanitize($_POST['estado']);
                            $ciudad = $this->solicitud->sanitize($_POST['ciudad']);
                            $codigo_postal = $this->solicitud->sanitize($_POST['codigo_postal']);
                            $direccion = $this->solicitud->sanitize($_POST['direccion']);
                            $lat = $this->solicitud->sanitize($_POST['lat']);
                            $long = $this->solicitud->sanitize($_POST['long']);

                            $cliente_direccion_envio_model = new Clientedireccionenvios();

                            $data_cliente = $this->clientes->obtener($id);

                            if (empty($id_envio)) {
                                if ($cliente_direccion_envio_model->guardar([
                                    'cde_cliid'                 => $id,
                                    'cde_direccion'             => $direccion,
                                    'cde_pais'                  => $pais,
                                    'cde_estado'                => $estado,
                                    'cde_ciudad'                => $ciudad,
                                    'cde_codigo_postal'         => $codigo_postal,
                                    'cde_lat'                   => $lat,
                                    'cde_lng'                   => $long
                                ], true)) {
                                    Notifica::crearNotificacion(3, "Ha registrado una nueva direccion de envio al cliente <strong>{$data_cliente['cli_razon_social']}</strong>");
                                    Http::json_response(true);
                                } else {
                                    Http::json_response(false);
                                }
                            } else {
                                if ($cliente_direccion_envio_model->editar($id_envio, [
                                    'cde_cliid'                 => $id,
                                    'cde_direccion'             => $direccion,
                                    'cde_pais'                  => $pais,
                                    'cde_estado'                => $estado,
                                    'cde_ciudad'                => $ciudad,
                                    'cde_codigo_postal'         => $codigo_postal,
                                    'cde_lat'                   => $lat,
                                    'cde_lng'                   => $long
                                ])) {
                                    Notifica::crearNotificacion(3, "Ha actualizado la direccion de envio al cliente <strong>{$data_cliente['cli_razon_social']}</strong>");
                                    Http::json_response(true);
                                } else {
                                    Http::json_response(false);
                                }
                            }
                        } else {
                            Http::json_response(['errors' => $this->array_errors]);
                        }
                    } else {
                        Http::json_response(false);
                    }
                }
            }

            Http::json_response(false);
        }
    }

    public function obtenerDireccionesEnvios(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->clientes->existe('cli_id', $id_cliente)) {
                $cliente_direccion_envio_model = new Clientedireccionenvios();
                Http::json_response($cliente_direccion_envio_model->direcciones($id_cliente));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function obtenerNotasdeCredito(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_cliente = filter_var($id_cliente, FILTER_SANITIZE_NUMBER_INT);
            if ($this->clientes->existe('cli_id', $id_cliente)) {
                Http::json_response($this->clientes->obtenerCreditos($id_cliente));
            }
        }
    }

    public function eliminarDireccionEnvio(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $cliente_direccion_envio_model = new Clientedireccionenvios();

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($cliente_direccion_envio_model->existe('cde_id', $id)) {
                Http::json_response($cliente_direccion_envio_model->eliminarDireccionEnvio($id));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function obtenerFacturas(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id_cliente, FILTER_SANITIZE_NUMBER_INT);

            $acumulado_total = 0;
            $array_facturas = [];

            $facturas = $this->clientes->obtenerFacturas($id);

            if (is_countable($facturas) && count($facturas)) {
                foreach ($facturas as $row) {
                    $acumulado = $this->clientes->obtenerAcumulado($row['fm_id'], 2);
                    $acumulado_total = ($acumulado['total']) ?? 0;
                    $array_facturas[] = [
                        'id'            => $row['fm_id'],
                        'correlativo'   => $row['fm_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'  => $row['div_simbolo'],
                        'total'         => $row['fm_total'],
                        'estatus'       => $row['fm_estatus'],
                        'fecha'         => $row['fecha'],
                        'acumulado'     => $acumulado_total,
                        'pendiente'     => $row['fm_total'] - $acumulado_total,
                        'su_nombre'     => $row['su_nombre'],
                    ];
                }
            }

            Http::json_response(['facturas' => $array_facturas]);
        }
    }

    public function obtenerNotasdeentrega(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id_cliente, FILTER_SANITIZE_NUMBER_INT);

            $acumulado_total = 0;
            $array_facturas = [];

            $facturas = $this->clientes->obtenerNotasdeentrega($id);

            if (is_countable($facturas) && count($facturas)) {
                foreach ($facturas as $row) {
                    $acumulado = $this->clientes->obtenerAcumulado($row['ne_id'], 1);
                    $acumulado_total = ($acumulado['total']) ?? 0;
                    $array_facturas[] = [
                        'id'            => $row['ne_id'],
                        'correlativo'   => $row['ne_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'  => $row['div_simbolo'],
                        'total'         => $row['ne_total'],
                        'estatus'       => $row['ne_estatus'],
                        'fecha'         => $row['fecha'],
                        'acumulado'     => $acumulado_total,
                        'pendiente'     => $row['ne_total'] - $acumulado_total,
                        'su_nombre'     => $row['su_nombre'],

                    ];
                }
            }

            Http::json_response(['notasdeentrega' => $array_facturas]);
        }
    }

    public function obtenerOrdenesdeentrega(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id_cliente, FILTER_SANITIZE_NUMBER_INT);

            $acumulado_total = 0;
            $array_facturas = [];

            $facturas = $this->clientes->obtenerOrdendeEntrega($id);

            if (is_countable($facturas) && count($facturas)) {
                foreach ($facturas as $row) {
                    $acumulado = $this->clientes->obtenerAcumulado($row['n_id'], 12);
                    $acumulado_total = ($acumulado['total']) ?? 0;
                    $array_facturas[] = [
                        'id'            => $row['n_id'],
                        'correlativo'   => $row['n_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'  => $row['div_simbolo'],
                        'total'         => $row['n_total'],
                        'estatus'       => $row['n_estatus'],
                        'fecha'         => $row['fecha'],
                        'acumulado'     => $acumulado_total,
                        'pendiente'     => $row['n_total'] - $acumulado_total,
                        'su_nombre'     => $row['su_nombre'],

                    ];
                }
            }

            Http::json_response(['ordenesdeentrega' => $array_facturas]);
        }
    }

    public function obtenerPedidos(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id_cliente, FILTER_SANITIZE_NUMBER_INT);

            $array_facturas = [];
            $facturas = $this->clientes->obtenerPedidos($id);

            if (is_countable($facturas) && count($facturas)) {
                foreach ($facturas as $row) {
                    $array_facturas[] = [
                        'id'            => $row['pe_id'],
                        'correlativo'   => $row['pe_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'  => $row['div_simbolo'],
                        'total'         => $row['pe_total'],
                        'estatus'       => $row['pe_estatus'],
                        'fecha'         => $row['fecha'],
                        'su_nombre'     => $row['su_nombre'],
                    ];
                }
            }

            Http::json_response(['pedidos' => $array_facturas]);
        }
    }

    public function obtenerPresupuestos(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id_cliente, FILTER_SANITIZE_NUMBER_INT);

            $array_facturas = [];
            $facturas = $this->clientes->obtenerPresupuestos($id);

            if (is_countable($facturas) && count($facturas)) {
                foreach ($facturas as $row) {
                    $array_facturas[] = [
                        'id'            => $row['pre_id'],
                        'correlativo'   => $row['pre_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'  => $row['div_simbolo'],
                        'total'         => $row['pre_total'],
                        'estatus'       => $row['pre_estatus'],
                        'fecha'         => $row['fecha'],
                        'su_nombre'     => $row['su_nombre'],
                    ];
                }
            }

            Http::json_response(['presupuestos' => $array_facturas]);
        }
    }

    public function obtenerAbonos($id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $array_factura      = [];
            $totales_divisas    = [];

            $facturas = $this->clientes->obtenerFacturas($id_cliente);

            $facturas_divisas = [];

            if (count($facturas) > 0) {

                foreach ($facturas as $row) {

                    $acumulado = $this->clientes->obtenerAcumulado($row['fm_id'], 2);
                    $acumulado_total = ($acumulado['total']) ?? 0;
                    $acumulado_factura = $this->clientes->obtenerAcumuladoMovimFactura($row['fm_id']);
                    $compras = new Compras();
                    $divisa = $this->clientes->obtenerDivisa($row['fm_divid']);

                    if (count($acumulado_factura) > 0) {
                        foreach ($acumulado_factura as $row1) {

                            $divisaf = $this->clientes->obtenerDivisa($row1['fab_divisa']);
                            /*if ($row1['fab_divisa'] != $this->div_master['div_id']) {
                                $factor = $compras->divisaFactor($row1['fab_divisa'], $this->div_master['div_id']);
                                $row1['fab_monto'] = round(($row1['fab_monto'] * $factor['df_factor']), 2);
                            }*/

                            $array_factura[] = [
                                'id_documento'  => 2,
                                'id'            => $row['fm_id'],
                                'correlativo'   => 'FACV' . $row['fm_correlativo'],
                                'estatus'       => $row['fm_estatus'],
                                'fecha'         => $row1['fab_fecha'],
                                'abono'         => Moneda::moneda($row1['fab_monto'], $divisa['div_locale'], $divisa['div_simbolo']),
                                'total'         =>  Moneda::moneda($row['fm_total'], $divisaf['div_locale'], $divisaf['div_simbolo']),
                                'acumulado'     =>  Moneda::moneda($acumulado_total, $divisaf['div_locale'], $divisaf['div_simbolo']),
                                'pendiente'     =>  Moneda::moneda($row['fm_total'] - $acumulado_total, $divisaf['div_locale'], $divisaf['div_simbolo']),
                                'divisa'        => $row1['div_descripcion'],
                                'su_nombre'     => $row['su_nombre'],
                            ];
                        }
                    }
                }
            }

            $notas = $this->clientes->obtenerNotasdeentrega($id_cliente);
            $notas_divisas = [];

            if (count($notas) > 0) {

                foreach ($notas as $row) {

                    $acumulado = $this->clientes->obtenerAcumulado($row['ne_id'], 1);
                    $acumulado_total = ($acumulado['total']) ?? 0;
                    $acumulado_factura = $this->clientes->obtenerAcumuladoMovimNota($row['ne_id']);
                    $compras = new Compras();
                    $divisa = $this->clientes->obtenerDivisa($row['ne_divid']);

                    if (count($acumulado_factura) > 0) {
                        foreach ($acumulado_factura as $row1) {

                            /* if ($row1['fab_divisa'] != $this->div_master['div_id'] && $row1['fab_divisa'] > 0) {
                                $factor = $compras->divisaFactor($row1['fab_divisa'], $this->div_master['div_id']);
                                $row1['fab_monto'] = $row1['fab_monto'] * $factor['df_factor'];
                            }*/
                            $divisaf = $this->clientes->obtenerDivisa($row1['fab_divisa']);

                            $array_factura[] = [
                                'id_documento'  => 1,
                                'id'            => $row['ne_id'],
                                'correlativo'   => 'NEV' . $row['ne_correlativo'],
                                'estatus'       => $row['ne_estatus'],
                                'fecha'         => $row1['fab_fecha'],
                                'abono'         =>  Moneda::moneda($row1['fab_monto'], $divisa['div_locale'], $divisa['div_simbolo']),
                                'total'         =>  Moneda::moneda($row['ne_total'], $divisaf['div_locale'], $divisaf['div_simbolo']),
                                'acumulado'     =>  Moneda::moneda($acumulado_total, $divisaf['div_locale'], $divisaf['div_simbolo']),
                                'pendiente'     =>  Moneda::moneda($row['ne_total'] - $acumulado_total, $divisaf['div_locale'], $divisaf['div_simbolo']),
                                'divisa'        => $row1['div_descripcion'],
                                'su_nombre'     => $row['su_nombre'],
                            ];
                        }
                    }
                }
            }

            $totales_divisas = [];
            $total_divisa_id = [];

            if (count($facturas_divisas) > 0) {
                foreach ($facturas_divisas as $row) {
                    if (!in_array($row['div_id'], $total_divisa_id)) {
                        $totales_divisas[$row['div_id']] = [
                            'div_id'        => $row['div_id'],
                            'div_nombre'    => $row['div_nombre'],
                            'div_locale'    => $row['div_locale'],
                            'div_simbolo'   => $row['div_simbolo'],
                            'total'         => $row['total'],
                        ];
                        $total_divisa_id[] = $row['div_id'];
                    } else {
                        $totales_divisas[$row['div_id']]['total'] += $row['total'];
                    }
                }
            }

            if (count($notas_divisas) > 0) {
                foreach ($notas_divisas as $row) {
                    if (!in_array($row['div_id'], $total_divisa_id)) {
                        $totales_divisas[$row['div_id']] = [
                            'div_id'        => $row['div_id'],
                            'div_nombre'    => $row['div_nombre'],
                            'div_locale'    => $row['div_locale'],
                            'div_simbolo'   => $row['div_simbolo'],
                            'total'         => $row['total'],
                        ];
                        $total_divisa_id[] = $row['div_id'];
                    } else {
                        $totales_divisas[$row['div_id']]['total'] += $row['total'];
                    }
                }
            }

            Http::json_response([
                'abonos'                => $array_factura,
                'divisas_totales'       => $totales_divisas,
            ]);
        }
    }

    public function guardarAgenteVenta()
    {
        $newAgent = new EmpleadoAgente();

        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $agente = filter_input(INPUT_POST, 'agente', FILTER_SANITIZE_NUMBER_INT);
            $idcliente  = filter_input(INPUT_POST, 'idcliente', FILTER_SANITIZE_NUMBER_INT);
            $fecha = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $captado = filter_input(INPUT_POST, 'captado', FILTER_SANITIZE_STRING);

            if (empty($agente))
                $this->array_errors[] = "Debe seleccionar un agente de venta.";
            if (empty($idcliente))
                $this->array_errors[] = "Error al identificar el cliente.";

            /*if (empty($this->array_errors)) {
                if ($newAgent->existe('empagent_clientid', $idcliente)) {
                    if ($newAgent->modificarAgente($idcliente, $agente, $captado)) {
                        Http::json_response(true);
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    if ($newAgent->guardar([
                        'empagent_empid' => $agente,
                        'empagent_clientid'  => $idcliente,
                        'empagent_fecha_registro' => $fecha,
                        'empagent_captado'        => $captado
                    ], true)) {
                        Http::json_response(true);
                    } else {
                        Http::json_response(false);
                    }
                }
            }*/

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerAgente(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newAgent = new EmpleadoAgente();

            if ($newAgent->existe('empagent_clientid', $id_cliente)) {
                Http::json_response($newAgent->obtenerAgente($id_cliente));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function eliminarAgente(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newAgent = new EmpleadoAgente();

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($newAgent->existe('empagent_clientid', $id)) {
                Http::json_response($newAgent->eliminarAgente($id));
            } else {
                Http::json_response(false);
            }
        }
    }


    public function obtenerInteresesCli(int $id_cliente)
    {
        $clientesint = new Clienteintereses();

        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->clientes->existe('cli_id', $id_cliente)) {


                Http::json_response($clientesint->obtenerIntereses($id_cliente));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function guardarInteres()
    {
        $newintereses = new Clienteintereses();

        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $idcliente  = filter_input(INPUT_POST, 'idcliente', FILTER_SANITIZE_NUMBER_INT);
            $descripcion = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);


            if (empty($idcliente))
                $this->array_errors[] = "Error al identificar el cliente.";
            if (empty($descripcion))
                $this->array_errors[] = "Debe llenar el campo descripcion.";

            if (empty($this->array_errors)) {

                if ($newintereses->guardar([
                    'cliint_tipo' => 0,
                    'cliint_descripcion'  => $descripcion,
                    'cliint_cli_id' => $idcliente
                ], true)) {

                    Http::json_response(true);
                } else {
                    Http::json_response(false);
                }
            }


            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerProductos(int $id_cliente)
    {
        if ($this->clientes->existe('cli_id', $id_cliente)) {

            $new_pro_cat = new ProductoCategoria();
            $new_prod = new Clienteintereses();

            $array_top        = [];
            $array_top_id     = [];

            $notas = $new_prod->obtenerTopArtProduccionNEVDia($id_cliente);
            $top_pro_facturas = $new_prod->obtenerTopArtProduccionFACVDia($id_cliente);

            if (is_countable($notas) && count($notas)) {
                foreach ($notas as $row) {
                    $array_top[$row['pro_id']] = [
                        'cantidad'      => $row['cantidad'],
                        'fecha'         => $row['ne_fecha'],
                        'descripcion'   => $row['pro_descripcion'],
                        'id'            => $row['pro_id'],
                    ];
                }
            }

            if (is_countable($top_pro_facturas) && count($top_pro_facturas)) {
                foreach ($top_pro_facturas as $row_dos) {
                    if (!in_array($row_dos['pro_id'], $array_top_id)) {
                        $array_top[$row_dos['pro_id']] = [
                            'cantidad'      => $row_dos['cantidad'],
                            'fecha'         => $row_dos['fm_fecha'],
                            'descripcion'   => $row_dos['pro_descripcion'],
                            'id'            => $row_dos['pro_id'],
                        ];
                        $array_top_id[] = $row_dos['pro_id'];
                    } else {
                        $array_top[$row_dos['pro_id']]['cantidad'] += $row_dos['cantidad'];
                    }
                }
            }

            if ($array_top !== []) {
                rsort($array_top);
                $lista = array_slice($array_top, 0, 10);
            } else {
                $lista = [];
            }

            $list_top_pro = [];

            if (count($lista) > 0) {

                foreach ($lista as $pro) {
                    $categoria = $new_pro_cat->obtenerCategoria($pro['id']);

                    $categoria = ($categoria) ? $categoria['cat_nombre'] : null;

                    $list_top_pro[$pro['id']] = [
                        'cantidad'      => $pro['cantidad'],
                        'fecha'         => $pro['fecha'],
                        'descripcion'   => $pro['descripcion'],
                        'id'            => $pro['id'],
                        'categoria'     => $categoria,
                    ];
                }
            }
            Http::json_response($list_top_pro);
        }
    }

    public function eliminarInteres(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newInters = new Clienteintereses();

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($newInters->existe('cliint_id', $id)) {
                Http::json_response($newInters->eliminarInteres($id));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function obtenerContactos(int $id_cliente)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_cliente = filter_var($id_cliente, FILTER_SANITIZE_NUMBER_INT);
            $newCliContacto = new ClienteContactos();
            $contactos = $newCliContacto->where(['ccon_cliid' => $id_cliente]);
            $lista = [];
            if (is_countable($contactos) && count($contactos)) {
                foreach ($contactos as $row) {
                    $lista[] = [
                        'id' => $row['ccon_id'],
                        'nombre' => $row['ccon_nombre'],
                        'cargo' => $row['ccon_cargo'],
                        'telefono' => $row['ccon_telefono'],
                        'email' => $row['ccon_email']
                    ];
                }
            }
            Http::json_response($lista);
        }
    }

    public function guardarContacto()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_cliente']))
                Http::json_response(['errors' => ['Acción prohibida']]);

            if (empty($_POST['contactoNombre']))
                $this->array_errors[] = 'El campo Nombre es obligatorio';
            if (empty($_POST['contactoCargo']))
                $this->array_errors[] = 'El campo Cargo es obligatorio';
            if (empty($_POST['contactoTlf']))
                $this->array_errors[] = 'El campo Teléfono es obligatorio';
            if (empty($_POST['contactoEmail']))
                $this->array_errors[] = 'El campo Correo es obligatorio';

            if (empty($this->array_errors)) {

                $newCliContacto = new ClienteContactos();

                $data_form = [
                    'ccon_cliid'    => $this->solicitud->sanitize($_POST['id_cliente'], FILTER_SANITIZE_NUMBER_INT),
                    'ccon_nombre'   => $this->solicitud->sanitize($_POST['contactoNombre'], FILTER_SANITIZE_STRING),
                    'ccon_cargo'    => $this->solicitud->sanitize($_POST['contactoCargo'], FILTER_SANITIZE_STRING),
                    'ccon_telefono' => $this->solicitud->sanitize($_POST['contactoTlf'], FILTER_SANITIZE_STRING),
                    'ccon_email'    => $this->solicitud->sanitize($_POST['contactoEmail'], FILTER_SANITIZE_EMAIL),
                ];

                if (strlen($data_form['ccon_nombre']) > 50 || strlen($data_form['ccon_cargo']) > 50 || strlen($data_form['ccon_telefono']) < 15 || strlen($data_form['ccon_telefono']) > 50)
                    Http::json_response(false);

                if (empty($_POST['contactoID'])) {
                    Http::json_response($newCliContacto->guardar($data_form, true));
                } else {
                    $id = filter_input(INPUT_POST, 'contactoID', FILTER_SANITIZE_NUMBER_INT);
                    Http::json_response($newCliContacto->editar($id, $data_form));
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarContacto(int $id_contacto)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newCliContacto = new ClienteContactos();
            Http::json_response($newCliContacto->eliminar($id_contacto));
        }
    }

    public function obtenerLicencias(int $id_cliente)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $notas = $this->clientes->consultar("SELECT * FROM app_notas_de_entrega_articulos np 
            LEFT JOIN app_notas_de_entrega n ON n.ne_id=np.neart_neid  
            LEFT JOIN app_productos p ON p.pro_id=np.neart_proid 
            LEFT JOIN app_productos_categorias c ON c.pc_proid=p.pro_id 
            LEFT JOIN app_categorias cc ON cc.cat_id=c.pc_catid  
            WHERE (cc.cat_padre=148 OR c.pc_catid=148 OR c.pc_catid=163) AND n.ne_estatus!=3 AND n.ne_cliid=$id_cliente ORDER BY n.ne_correlativo DESC")->all();

            $facturas = $this->clientes->consultar("SELECT * FROM app_factura_articulos np 
            LEFT JOIN app_factura_master n ON n.fm_id=np.fa_fmid  
            LEFT JOIN app_productos p ON p.pro_id=np.fa_proid 
            LEFT JOIN app_productos_categorias c ON c.pc_proid=p.pro_id 
             LEFT JOIN app_categorias cc ON cc.cat_id=c.pc_catid  
            WHERE (cc.cat_padre=148 OR c.pc_catid=148 OR c.pc_catid=163) AND n.fm_estatus!=3 AND n.fm_cliid=$id_cliente ORDER BY n.fm_correlativo DESC")->all();

            $array_lista=[];
            $array_top_id=[];

            if (is_countable($notas) && count($notas)) {
                foreach ($notas as $row_dos) {
                    //if (!in_array($row_dos['ne_id'], $array_top_id)) {
                        $array_lista[] = [
                            'url'=>ruta_base().'notasdeentregaeditar/verFactura/' . $row_dos['ne_id'],
                            'serial'      => $row_dos['neart_licencia_serial'],
                            'fecha'         => $row_dos['neart_licencia_fecha_expiracion'],
                            'comentario'   => $row_dos['neart_licencia_comentario'],
                            'factura'=>"NEV".$row_dos['ne_correlativo'],
                            'codigo'=>$row_dos['pro_codigo'],
                            'producto'=>$row_dos['pro_descripcion']
                        ];
                        //$array_top_id[] = $row_dos['pro_id'];
                    //}
                }
            }

            if (is_countable($facturas) && count($facturas)) {
                foreach ($facturas as $row_dos) {
                    //if (!in_array($row_dos['ne_id'], $array_top_id)) {
                        $array_lista[] = [
                            'url'=>ruta_base().'poseditar/verFactura/' . $row_dos['fm_id'],
                            'serial'      => $row_dos['fa_licencia_serial'],
                            'fecha'         => $row_dos['fa_licencia_fecha_expiracion'],
                            'comentario'   => $row_dos['fa_licencia_comentario'],
                            'factura'=>"FACV".$row_dos['fm_correlativo'],
                            'codigo'=>$row_dos['pro_codigo'],
                            'producto'=>$row_dos['pro_descripcion']
                        ];
                        //$array_top_id[] = $row_dos['pro_id'];
                    //}
                }
            }


            Http::json_response($array_lista);
        }
    }

    public function obtenerProductosVendidos()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $anio = $this->solicitud->sanitize($_POST['anio'], FILTER_SANITIZE_NUMBER_INT);
            $mes = $this->solicitud->sanitize($_POST['mes'], FILTER_SANITIZE_NUMBER_INT);
            $id = $this->solicitud->sanitize($_POST['id'], FILTER_SANITIZE_NUMBER_INT);

            if (empty($id))
                $this->array_errors[] = 'Debe seleccionar un cliente.';

            if (empty($this->array_errors)) {

                $artic_total        = 0;
                $costo_total        = 0;
                $venta_total        = 0;
                $totales_productos  = [];
                $total_productos_id = [];

                $productos =  $this->ingresosegresos_model->obtenerProductos();

                if (is_countable($productos) && count($productos)) {

                    foreach ($productos as $pro) {

                        if ($mes == 0) {
                            $total_notas = $this->ingresosegresos_model->obtenerArticulosDeNEVCliente("YEAR(ne.ne_fecha)=$anio AND art.neart_proid ={$pro['pro_id']} AND ne.ne_cliid=$id");
                            $total_ordenes = $this->ingresosegresos_model->obtenerArticulosDeOrdCliente("YEAR(n.n_fecha)=$anio AND art.nart_proid = {$pro['pro_id']} AND n.n_cliid=$id");
                            $total_facv = $this->ingresosegresos_model->obtenerArticulosDeFACVCliente("YEAR(fm.fm_fecha)=$anio AND art.fa_proid = {$pro['pro_id']} AND fm.fm_cliid=$id");
                        } else {
                            $total_notas = $this->ingresosegresos_model->obtenerArticulosDeNEVCliente("MONTH(ne.ne_fecha)=$mes AND YEAR(ne.ne_fecha)=$anio AND art.neart_proid = {$pro['pro_id']} AND ne.ne_cliid=$id");
                            $total_ordenes = $this->ingresosegresos_model->obtenerArticulosDeOrdCliente("MONTH(n.n_fecha)=$mes AND YEAR(n.n_fecha)=$anio AND art.nart_proid  = {$pro['pro_id']} AND n.n_cliid=$id");
                            $total_facv = $this->ingresosegresos_model->obtenerArticulosDeFACVCliente("MONTH(fm.fm_fecha)=$mes AND YEAR(fm.fm_fecha)=$anio AND art.fa_proid = {$pro['pro_id']} AND fm.fm_cliid=$id");
                        }

                        if (is_countable($total_notas) && count($total_notas)) {

                            foreach ($total_notas as $row) {

                                $totales_productos[] = [
                                    'id'            => $pro['pro_id'],
                                    'descripcion'   => $pro['pro_descripcion'],
                                    'categoria'     => $this->ingresosegresos_model->obtenerCategoria($pro['pro_id']),
                                    'cantidad'      => $row['neart_procantidad'],
                                    'fecha'         => $row['ne_fecha'],
                                    'tipo'          => 1,
                                    'monto'         => $row['neart_proprecio'],
                                    'factura'       => $row['ne_id'],

                                ];
                            }
                        }

                        if (is_countable($total_facv) && count($total_facv)) {
                            foreach ($total_facv as $row) {

                                $totales_productos[] = [
                                    'id'            => $pro['pro_id'],
                                    'descripcion'   => $pro['pro_descripcion'],
                                    'categoria'     => $this->ingresosegresos_model->obtenerCategoria($pro['pro_id']),
                                    'cantidad'      => $row['fa_procantidad'],
                                    'fecha'         => $row['fm_fecha'],
                                    'tipo'          => 2,
                                    'monto'         => $row['fa_proprecio'],
                                    'factura'       => $row['fm_id'],

                                ];
                            }
                        }

                        if (is_countable($total_ordenes) && count($total_ordenes)) {

                            foreach ($total_ordenes as $row) {
                                $totales_productos[] = [
                                    'id'            => $pro['pro_id'],
                                    'descripcion'   => $pro['pro_descripcion'],
                                    'categoria'     => $this->ingresosegresos_model->obtenerCategoria($pro['pro_id']),
                                    'cantidad'      => $row['nart_procantidad'],
                                    'fecha'         => $row['n_fecha'],
                                    'tipo'          => 12,
                                    'monto'         => $row['nart_proprecio'],
                                    'factura'       => $row['n_id'],

                                ];
                            }
                        }
                    }
                }

                Http::json_response($totales_productos);
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }

    public function obtenerRedesSociales(int $id_cliente)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response($this->clientes->obtenerCliRedesSociales($id_cliente));
        }
    }

    public function guardarRedes()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_POST['descripcion']) && !empty($_POST['tipo'])) {

                $id = $this->solicitud->sanitize($_POST['id']);
                $descripcion = $this->solicitud->sanitize($_POST['descripcion']);
                $tipo = $this->solicitud->sanitize($_POST['tipo']);
                $rd = $this->solicitud->sanitize($_POST['rd']);

                if (empty($rd)) {
                    $guardarRedes = $this->clientes->consultar("INSERT INTO app_clientes_redes_sociales(clird_type, clird_descripcion, clird_cliid) VALUES ('$tipo','$descripcion',$id)")->run();
                    if ($guardarRedes) {
                        Http::json_response(true);
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    $guardarRedes = $this->clientes->consultar("UPDATE app_clientes_redes_sociales SET clird_type = '$tipo',clird_descripcion='$descripcion' WHERE clird_id= $rd")->run();
                    if ($guardarRedes) {
                        Http::json_response(true);
                    } else {
                        Http::json_response(false);
                    }
                }
            }

            Http::json_response(false);
        }
    }

    public function eliminarRedes(int $id_red)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($id_red)) {

                $id = $this->solicitud->sanitize($id_red, FILTER_VALIDATE_INT);

                if ($id) {

                    $existe = $this->clientes->consultar("SELECT * FROM app_clientes_redes_sociales WHERE clird_id = $id_red")->row();

                    if (!$existe) {
                        $this->array_errors[] = 'Lo siento no puede eliminar la red social';
                        Http::json_response(['errors' => $this->array_errors]);
                    } else {
                        Http::json_response($this->clientes->consultar("DELETE FROM app_clientes_redes_sociales WHERE clird_id=$id_red")->run());
                    }
                }
            }

            Http::json_response(false);
        }
    }
}
