<?php

namespace App\Controladores;

use App\Modelos\Caja;
use App\Modelos\Cajeros;
use Core\Controller;
use Core\Librerias\Http;
use Core\Vista;

final class CajaControlador extends Controller
{
    private $newCajas;
    private $newCajeros;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->newCajas = new Caja();
        $this->newCajeros = new Cajeros();
    }

    public function index()
    {
        Vista::viewAJAX('caja/index');
    }

    public function obtenerCajas()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $list_cajas = [];
            $cajas = $this->newCajas->obtenerCajas();

            if (is_countable($cajas) && count($cajas)) {
                foreach ($cajas as $row) {
                    $list_cajas[] = [
                        'id' => $row['caj_id'],
                        'codigo' => $row['caj_codigo'],
                        'descripcion' => $row['caj_descripcion'],
                        'metododepago_id' => $row['caj_mpid'],
                        'metododepago_descripcion' => $row['mp_codigo'],
                        'impresora_id' => $row['caj_impresora'],
                        'impresora_descripcion' => $row['imp_descripcion'],
                        'serie' => $row['ser_descripcion'],
                        'estatus' => $row['caj_estatus'] ? true : false
                    ];
                }
            }

            Http::json_response($list_cajas);
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['codigo']))
                $this->array_errors[] = "El campo Código es obligatorio.";
            if (empty($_POST['descripcion']))
                $this->array_errors[] = "El campo Descripción es obligatorio.";
            if (empty($_POST['impresora']))
                $this->array_errors[] = "El campo Impresora es obligatorio.";
            if (empty($_POST['metododepago']))
                $this->array_errors[] = "El campo Método de pago es obligatorio.";

            if (empty($this->array_errors)) {

                $caj_codigo = $this->solicitud->sanitize($_POST['codigo'], FILTER_SANITIZE_STRING);
                $caj_nombre = $this->solicitud->sanitize($_POST['descripcion'], FILTER_SANITIZE_STRING);
                $caj_impresora = $this->solicitud->sanitize($_POST['impresora'], FILTER_SANITIZE_NUMBER_INT);
                $caj_mpid = $this->solicitud->sanitize($_POST['metododepago'], FILTER_SANITIZE_NUMBER_INT);

                $data_form = [
                    'caj_codigo' => $caj_codigo,
                    'caj_descripcion' => $caj_nombre,
                    'caj_impresora' => $caj_impresora,
                    'caj_mpid' => $caj_mpid,
                    'caj_empid' => $_SESSION['user_data']['emp_id']
                ];

                if (empty($_POST['id'])) {

                    $existe = $this->newCajas->consultar("SELECT caj_id FROM app_cajas WHERE caj_codigo = '$caj_codigo'")->row();

                    if ($existe) {
                        $this->array_errors[] = "El codigo $caj_codigo ya se encuentra en uso";
                    } else {

                        if ($this->newCajas->guardar($data_form, true)) {
                            Http::json_response(true);
                        } else {
                            Http::json_response(false);
                        }
                    }
                } else {

                    $caj_id = $this->solicitud->sanitize($_POST['id'], FILTER_SANITIZE_NUMBER_INT);

                    if ($this->newCajas->existe('caj_id', $caj_id)) {

                        $repite_codigo = $this->newCajas->consultar("SELECT caj_id FROM app_cajas WHERE caj_codigo = '$caj_codigo' AND caj_id != $caj_id")->row();

                        if ($repite_codigo) {
                            $this->array_errors[] = "El codigo $caj_codigo ya se encuentra en uso";
                        } else {
                            if ($this->newCajas->editar($caj_id, $data_form)) {
                                Http::json_response(true);
                            } else {
                                Http::json_response(false);
                            }
                        }
                    } else {
                        Http::json_response(false);
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function cambiarEstatus(int $caj_id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $caj_id = $this->solicitud->sanitize($caj_id, FILTER_SANITIZE_NUMBER_INT);

            if ($this->newCajas->existe('caj_id', $caj_id)) {

                $data_caja = $this->newCajas->obtener($caj_id);

                $res = $this->newCajas->editar($caj_id, [
                    'caj_estatus' => $data_caja['caj_estatus'] ? 0 : 1
                ]);

                if ($res) {
                    Http::json_response(true);
                } else {
                    Http::json_response(false);
                }
            } else {
                Http::json_response(false);
            }
        }
    }

    public function eliminar(int $caj_id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            /*
            $caj_id = $this->solicitud->sanitize($caj_id, FILTER_SANITIZE_NUMBER_INT);

            if ($this->newImpresoras->existe('caj_id', $caj_id)) {

                $existe_foraneo = $this->newCajas->consultar("SELECT caj_id FROM app_cajas WHERE caj_impresora = $imp_id")->row();

                if ($existe_foraneo) {
                    array_push($this->array_errors, 'Lo siento no puede eliminar la impresora ya que esta asociada a un caja');
                } else {
                    Http::json_response($this->newImpresoras->eliminar($caj_id));
                }
            } else {
                Http::json_response(false);
            }

            Http::json_response(['errors' => $this->array_errors]);            
            */

            Http::json_response(false);
        }
    }

    public function buscarEmpleados()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax() && !empty($_GET['buscar'])) {
            $buscar = $this->solicitud->sanitize($_GET['buscar'], FILTER_SANITIZE_STRING);
            $buscar = strtolower($buscar);
            Http::json_response($this->newCajas->buscarEmpleados($buscar));
        }
    }

    public function agregarCajero()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['caja']) && !empty($_GET['empleado'])) {

                $cajs_cajid = $this->solicitud->sanitize($_GET['caja'], FILTER_SANITIZE_NUMBER_INT);
                $cajs_empid = $this->solicitud->sanitize($_GET['empleado'], FILTER_SANITIZE_NUMBER_INT);

                $cajero_exite = $this->newCajeros->consultar("SELECT cajs_id FROM app_cajeros WHERE cajs_cajid = $cajs_cajid AND cajs_empid = $cajs_empid")->row();

                if ($cajero_exite) {
                    Http::json_response(true);
                } else {
                    $res = $this->newCajeros->guardar([
                        'cajs_cajid' => $cajs_cajid,
                        'cajs_empid' => $cajs_empid
                    ], true);
                    Http::json_response($res);
                }
            }

            Http::json_response(false);
        }
    }

    public function obtenerCajeros(int $caja)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            if (!empty($caja)) {
                Http::json_response($this->newCajeros->obtenerCajeros($caja));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function eliminarCajero(int $cajero)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            if (!empty($cajero)) {
                if ($this->newCajeros->existe('cajs_id', $cajero)) {
                    Http::json_response($this->newCajeros->eliminar($cajero));
                } else {
                    Http::json_response(false);
                }
            } else {
                Http::json_response(false);
            }
        }
    }
}
