<div class="card" id="appCuentas" v-cloak>
    <div class="card-header">
        <div class="card-head-row">
            <div class="card-title">Listado de Cuentas</div>
            <div class="card-tools">
                <a href="#" class="btn btn-light" style="box-shadow: 2px 6px 15px 0px #ddd;" @click.prevent="modalGuardar"><span class="btn-label"><i class="fa fa-plus"></i></span>
                    Agregar
                </a>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-sm table-hover">
                <thead>
                    <tr>
                        <th>Cuenta</th>
                        <th>Tipo</th>
                        <th>Banco</th>
                        <th>Alias</th>
                        <th class="text-center">Estatus</th>
                        <th class="text-center">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="row in cuentas">
                        <td>{{ row.bc_cuenta }}</td>
                        <td>{{ row.bc_tipo }}</td>
                        <td>{{ row.ban_descripcion }}</td>
                        <td>{{ row.bc_alias }}</td>
                        <td class="text-center">
                            <a href="#" title="Modificar estatus" @click.prevent="modificarEstatus(row.bc_id, 'estatus'+row.bc_id)">
                                <i :class="row.bc_estatus == 1 ? 'fa fa-check text-success' : 'fa fa-times text-danger'" :id="'estatus'+row.bc_id"></i>
                            </a>
                        </td>
                        <td>
                            <div class="form-button-action">
                                <button type="button" title="Editar" class="btn btn-link btn-primary" @click="ver(row.bc_id, row.bc_banid, row.bc_tipo, row.bc_cuenta, row.bc_alias)">
                                    <i class="fa fa-edit"></i>
                                </button>
                                <button type="button" title="Eliminar" class="btn btn-link text-dark" @click="eliminar(row.bc_id, row.bc_cuenta)">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <?php include 'modaleditarguardar.php'; ?>
</div>
<script src="<?php asset('assetsvuejs/bancos/cuentas.js'); ?>"></script>
