<div class="card" id="appBancos" v-cloak>
    <div class="card-header">
        <div class="card-head-row">
            <div class="card-title">Listado de Bancos</div>
            <div class="card-tools">
                <a href="#" class="btn btn-light" style="box-shadow: 2px 6px 15px 0px #ddd;" @click.prevent="modalGuardar"><span class="btn-label"><i class="fa fa-plus"></i></span>
                    Agregar
                </a>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-sm table-hover">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Descripción</th>
                        <th>País</th>
                        <th class="text-center">Estatus</th>
                        <th class="text-center">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="row in bancos">
                        <td>{{ row.ban_codigo }}</td>
                        <td>{{ row.ban_descripcion }}</td>
                        <td>{{ row.pa_nombre }}</td>
                        <td class="text-center">
                            <a href="#" title="Modificar estatus" @click.prevent="modificarEstatus(row.ban_id, 'estatus'+row.ban_id)">
                                <i :class="row.ban_estatus == 1 ? 'fa fa-check text-success' : 'fa fa-times text-danger'" :id="'estatus'+row.ban_id"></i>
                            </a>
                        </td>
                        <td class="text-center">
                            <div class="form-button-action">
                                <button type="button" title="Editar" class="btn btn-link btn-primary" @click="ver(row.ban_id, row.ban_codigo, row.ban_descripcion, row.ban_paid)">
                                    <i class="fa fa-edit"></i>
                                </button>
                                <button type="button" title="Eliminar" class="btn btn-link text-dark" @click="eliminar(row.ban_id, row.ban_descripcion)">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <?php include 'modaleditarguardar.php'; ?>
</div>
<script src="<?php asset('assetsvuejs/bancos/banco.js'); ?>"></script>
