<?php

namespace App\Controladores;

use Core\Controller;
use App\Modelos\Banco;
use App\Modelos\Pais;
use Core\Vista;

final class BancoControlador extends Controller
{
    private $banco;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->banco = new Banco();
    }

    public function index()
    {
        $new_pais = new Pais();
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            return Vista::viewAJAX('banco/index', [
                'paises' => $new_pais->todos(),
            ]);
        }
    }

    public function bancosActivos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->banco->bancosActivos());
            exit;
        }
    }

    public function bancos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->banco->bancos());
            exit;
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $ban_codigo      = filter_input(INPUT_POST, 'codigo', FILTER_SANITIZE_STRING);
            $ban_descripcion = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
            $ban_paid        = filter_input(INPUT_POST, 'pais', FILTER_SANITIZE_NUMBER_INT);

            if (empty($ban_codigo))
                $this->array_errors[] = "El campo Código es requerido";
            if (empty($ban_descripcion))
                $this->array_errors[] = "El campo Descripción es requerido";
            if (empty($ban_paid))
                $this->array_errors[] = "El campo País es requerido";

            if (empty($this->array_errors)) {

                if (empty($_POST['id'])) {
                    if ($this->banco->where(['ban_codigo' => $ban_codigo], true))
                        $this->array_errors[] = "El codigo $ban_codigo ya se encuentra en uso";
                } else {
                    $ban_id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                    if ($this->banco->where(['ban_codigo' => $ban_codigo, 'ban_id!=' => $ban_id], true))
                        $this->array_errors[] = "El codigo $ban_codigo ya se encuentra en uso";
                }

                if (empty($this->array_errors)) {

                    if (empty($_POST['id'])) {
                        header('Content-Type: application/json', true);
                        echo json_encode($this->banco->guardar([
                            'ban_codigo' => $ban_codigo,
                            'ban_descripcion' => $ban_descripcion,
                            'ban_paid' => $ban_paid
                        ], true));
                        exit;
                    } else {
                        header('Content-Type: application/json', true);
                        echo json_encode($this->banco->editar($ban_id, [
                            'ban_codigo' => $ban_codigo,
                            'ban_descripcion' => $ban_descripcion,
                            'ban_paid' => $ban_paid
                        ]));
                        exit;
                    }
                }
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function modificarEstatus(int $id_banco)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_banco = filter_var($id_banco, FILTER_SANITIZE_NUMBER_INT);

            if ($this->banco->existe('ban_id', $id_banco)) {

                $estatus = $this->banco->obtener($id_banco);

                header('Content-Type: application/json', true);
                echo json_encode($this->banco->editar($id_banco, [
                    'ban_estatus' => $estatus['ban_estatus'] == 1 ? 0 : 1
                ]));
                exit;
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function eliminar(int $id_banco)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_banco = filter_var($id_banco, FILTER_SANITIZE_NUMBER_INT);

            if ($this->banco->existe('ban_id', $id_banco)) {
                if ($this->banco->bancoForaneo($id_banco)) {
                    $this->array_errors[] = "El banco no puede ser eliminado ya que se encuentra relacionado con una cuenta";
                } else {
                    header('Content-Type: application/json', true);
                    echo json_encode($this->banco->eliminar($id_banco));
                    exit;
                }
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }
}
