<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= constant('DEFAULT_TITLE') ?></title>
    <link rel="icon" href="<?= asset('assets/img/icon.ico'); ?>" type="image/x-icon" />
    <script src="<?= asset('assets/js/plugin/webfont/webfont.min.js') ?>"></script>
    <link rel="stylesheet" href="<?= asset('assets/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="<?= asset('assets/css/atlantis.css') ?>">
    <style>
        @font-face {
            font-family: Lato;
            src: url(<?= asset("assets/Lato/Lato-Regular.ttf") ?>);
            font-weight: 400;
            font-style: normal;

        }

        @font-face {
            font-family: Lato;
            src: url(<?= asset("assets/Lato/Lato-Bold.ttf") ?>);
            font-weight: 700;
            font-style: normal;
        }

        body {
            font-family: Lato;
            font-style: normal;
            line-height: 1;
            text-decoration: inherit;
            text-rendering: optimizeLegibility;
            text-transform: none;
        }

        [v-cloak]>* {
            display: none
        }
    </style>
    <script>
        WebFont.load({
            custom: {
                "families": ["Font Awesome 5 Regular"],
                urls: ['<?= asset("assets/css/fonts.min.css") ?>']
            },
            active: function() {
                sessionStorage.fonts = true;
            }
        });
    </script>
</head>

<body>
    <div class="wrapper overlay-sidebar">
        <div class="main-header">
            <div class="logo-header" data-background-color="blue">
                <a href="<?= ruta_base() ?>" class="logo">
                    <img src="<?= asset('assets/img/logo.jpg') ?>" alt="navbar brand" class="navbar-brand" height="35">
                </a>
            </div>
            <nav class="navbar navbar-header navbar-expand-lg" data-background-color="blue">
            </nav>
        </div>
        <div class="main-panel">
            <div class="container container-full" id="AppVerProductos" v-cloak>
                <input type="hidden" id="cat_principal" value="<?= $categorias[0]['cat_id'] ?>">
                <div class="page-inner">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="d-flex justify-content-between">
                                <div class="d-md-inline-block">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text bg-white">
                                                <i class="fa fa-search search-icon"></i>
                                            </span>
                                        </div>
                                        <input type="text" class="form-control" v-model="buscador">
                                       
                                    </div>
                                </div>
                            </div>
                            <section class="card mt-4" :class="cargando">
                                <div class="list-group list-group-messages list-group-flush">
                                    <div class="list-group-item unread" v-for="row in searchProductos" @click="verDetalles(row)">
                                        <div class="list-group-item-figure">
                                            <a href="#" class="user-avatar">
                                                <div class="avatar">
                                                    <img v-if="row.imagen !== ''" :src="row.imagen" alt="Producto" class="avatar-img rounded-circle">
                                                    <span v-else class="avatar-title rounded-circle border border-white bg-info">{{ row.nombre.charAt() }}</span>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="list-group-item-body pl-3 pl-md-4">
                                            <div class="row">
                                                <div class="col-12 col-lg-10">
                                                    <h5 class="list-group-item-title">
                                                        {{ row.nombre }}
                                                    </h5>
                                                    <p class="list-group-item-text text-truncate"> {{ row.precio }}</p>
                                                </div>
                                                <div class="col-12 col-lg-2 text-lg-right">
                                                    <p class="list-group-item-text"> stock: {{ row.stock }} </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </section>
                        </div>
                    </div>
                    <div class="row">
                        <div class="modal fade" id="modalPro" tabindex="-1" role="dialog" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header border-0">
                                        <h5 class="modal-title" id="titulo"></h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body" id="contenido"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="<?= asset('assets/axios.min.js'); ?>"></script>
    <script>
        axios.defaults.baseURL = '<?= ruta_base() ?>';
        axios.defaults.timeout = 20000;
        axios.defaults.headers = {
            'X-Requested-With': 'XMLHttpRequest',
        };
    </script>
    <script src="<?= asset('assets/vue.min.js'); ?>"></script>
    <script src="<?= asset('assets/js/core/jquery.3.2.1.min.js'); ?>"></script>
    <script src="<?= asset('assets/js/core/popper.min.js'); ?>"></script>
    <script src="<?= asset('assets/js/core/bootstrap.min.js'); ?>"></script>

    <script>
        new Vue({
            el: '#AppVerProductos',
            data: {
                productos: [],
                cargando: '',
                categoria: document.getElementById('cat_principal').value,
                buscador: '',
            },
            created() {
                this.obtenerProductosPorCategorias();
            },
            methods: {
                obtenerProductosPorCategorias(event) {
                    if (event) {
                        this.categoria = event.target.attributes.href.value;
                    }
                    this.cargando = 'is-loading is-loading-lg';
                    axios.get('apiproductos/obtenerProductosPorCategorias/' + escape(this.categoria)).then(response => {
                        this.productos = response.data;
                    }).catch(e => {
                        alert('Error en tiempo de respuesta');
                    }).finally(() => {
                        this.cargando = '';
                    });
                },
                verDetalles(producto) {
                    $('#modalPro').modal('show');
                    document.getElementById('titulo').innerText = producto.nombre
                    document.getElementById('contenido').innerHTML = '<strong>OBSERVACIÓNES:</strong> <br><br>' + producto.observaciones
                }
            },
            computed: {
                searchProductos: function() {
                    return this.productos.filter((item) => {
                        return item.nombre.toLowerCase().includes(this.buscador.toLowerCase());
                    });
                }
            }
        })
    </script>
</body>

</html>
