<?php

namespace App\Controladores;

use App\Modelos\Productos;
use Core\Helpers\Moneda;

final class ApiproductosControlador
{
    private $productos_model;
    private $div_master;

    public function __construct()
    {
        $this->productos_model = new Productos();
        $this->div_master = $this->productos_model->obtenerDivisaMaster();
    }

    public function index()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD']) {

            $_ruta = 'app/apiproductos/vista/index.php';

            $_vars['categorias'] = $this->productos_model->obtenerCategorias();

            if (file_exists($_ruta)) {

                if (is_array($_vars))
                    extract($_vars);

                require $_ruta;
            } else {
                echo 'No se puede cargar el archivo solicitado: ' . $_file;
            }

            return;
        }
    }

    public function obtenerProductosPorCategorias($id_categoria)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_categoria   = filter_var($id_categoria, FILTER_SANITIZE_NUMBER_INT);
            $list_pro       = [];


            $productos = $this->productos_model->consultar("SELECT pro_descripcion, pro_precio, pro_observaciones, SUM(ps_cantidad) stock, pi_imagen
                FROM app_productos 
                LEFT JOIN app_productos_stocks ON ps_proid = pro_id
                LEFT JOIN app_productos_imagen ON pro_id = pi_proid
               
                GROUP BY pro_id ORDER BY pro_descripcion")->all();


            if (count($productos) > 0) {
                foreach ($productos as $row) {
                    if ($row['stock'] > 0) {
                        $list_pro[] = [
                            'nombre' => ucfirst(strtolower($row['pro_descripcion'])),
                            'precio' => Moneda::moneda($row['pro_precio'] ?? 0, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'imagen' => ruta_base() . '../gestion_uploads/productos/' .  $row['pi_imagen'],
                            'observaciones' => $row['pro_observaciones'],
                            'stock' =>  $row['stock'] ?? 0
                        ];
                    }
                }
            }

            header('Content-Type: application/json');
            echo json_encode($list_pro);
            exit();
        }
    }
}
