<?php

namespace App\Modelos;

use Core\Database;

class AlmacenUbicacion extends Database
{
    protected $table = 'app_almacen_ubicacion';
    protected $id = 'au_id';

    public function obtenerZonas(int $id_almacen)
    {
        return $this->consultar("SELECT au_id id, au_descripcion descripcion 
        FROM app_almacen_ubicacion 
        WHERE au_padre = 0 AND au_almid = $id_almacen
        ORDER BY au_descripcion")->all();
    }

    public function obtenerCombo(int $id)
    {
        return $this->consultar("SELECT au_id id, au_descripcion descripcion, au_tipo tipo 
        FROM app_almacen_ubicacion WHERE au_padre = $id
        ORDER BY au_descripcion")->all();
    }

    public function obtenerZonasAlmacen($id_almacen)
    {
        return $this->consultar("SELECT au_id id, au_descripcion descripcion 
        FROM app_almacen_ubicacion WHERE au_padre = 0 AND au_almid = $id_almacen
        ORDER BY au_descripcion")->all();
    }

    public function obtenerComboTipo(int $id, string $tipo)
    {
        return $this->consultar("SELECT au_id id, au_descripcion descripcion 
        FROM app_almacen_ubicacion WHERE au_padre = $id AND au_tipo = '$tipo'
        ORDER BY au_descripcion")->all();
    }

    public function obtenerUbicaciones(int $id)
    {
        return $this->consultar("SELECT au_id id, au_descripcion descripcion, au_tipo tipo 
        FROM app_almacen_ubicacion WHERE au_padre = $id
        ORDER BY au_descripcion")->all();
    }

    public function obtenerUbicacion(int $id)
    {
        return $this->consultar("SELECT *
        FROM app_almacen_ubicacion 
        WHERE au_id = $id")->row();
    }
}
