<div class="container" id="appAgencias" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Agencias</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('tarifas') ?>">Agencias de envio</a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
                <div class="dropdown d-inline mr-3 mr-md-2">
                    <button class="btn btn-info btn-border btn-round dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        Acciones
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -7px, 0px); top: 0px; left: 0px; will-change: transform;">
                        <a class="dropdown-item" href="<?= url('productos') ?>">Productos</a>
                        <a class="dropdown-item" href="<?= url('fabricantes') ?>">Fabricantes</a>
                        <a class="dropdown-item" href="<?= url('proveedores') ?>">Proveedores</a>
                        <a class="dropdown-item" href="<?= url('categorias') ?>">Categorias</a>
                        <a class="dropdown-item" href="<?= url('tarifas') ?>">Tarifas</a>
                        <a class="dropdown-item" href="<?= url('almacenes') ?>">Almacenes</a>
                        <a class="dropdown-item" href="<?= url('agencias') ?>">Agencias</a>
                    </div>
                </div>
                <a href="#" class="btn btn-info btn-border btn-round" @click.prevent="modalAgencias()"> <span class="fa fa-plus"></span> Nueva agencia</a>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th class="text-left">#</th>
                                <th class="text-left">Descripción</th>
                                <th>Tarifa min</th>
                                <th>Aplicar a</th>
                                <th>% min ganancia</th>
                                <th>Retiro</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in agencias">
                                <td>{{row.ag_id}}</td>
                                <td>{{row.ag_descripcion}}</td>
                                <td>{{row.ag_tarifa}}</td>
                                <td>
                                    <span v-if="row.ag_aplicar==0">Peso</span>
                                    <span v-if="row.ag_aplicar==1">Largo+ancho</span>
                                    <span v-if="row.ag_aplicar==2">Peso+largo+ancho</span>
                                </td>
                                <td>{{row.ag_porcentaje}} %</td>
                                <td>
                                    <span v-if="row.ag_servicio==0">En la oficina</span>
                                    <span v-if="row.ag_servicio==1">Puerta a puerta</span>
                                </td>
                                <td>
                                    <div class="form-button-action">
                                        <button type="button" title="Editar" class="btn btn-link btn-primary" @click="ver(row.ag_id, row.ag_descripcion, row.ag_aplicar, row.ag_servicio, row.ag_porcentaje,row.ag_tarifa)">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click="eliminar(row.ag_id, row.ag_descripcion)">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modaleditarguardar.php' ?>
</div>

<script src="<?= ruta_base() ?>public/assetsvuejs/agencias/index.js"></script>