<?php

namespace App\Modelos;

use Core\Database;

class MovimientoModel extends Database
{
    protected $table = 'app_movimientos';
    protected $id = 'fab_id';

    public function totalPagos(int $id_factura, int $documento, int $categoria)
    {
        return $this->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico=$id_factura AND fab_doc = $documento AND fab_categoria=$categoria")->row();
    }

    public function obtenerMovimientosDocumento($id_factura, $id_documento, $retiro = false)
    {
        if ($retiro) {
            return $this->consultar("SELECT * FROM app_movimientos WHERE fab_idgenerico=$id_factura AND fab_doc = $id_documento AND fab_retiro = 1")->all();
        } else {
            return $this->consultar("SELECT * FROM app_movimientos WHERE fab_idgenerico=$id_factura AND fab_doc = $id_documento AND fab_retiro = 0")->all();
        }
    }

    public function abtenerMovimiento($id)
    {
        return $this->consultar("SELECT * FROM app_movimientos WHERE fab_id=$id")->row();
    }

    public function abtenerMovimientoNegativo($id)
    {
        return $this->consultar("SELECT * FROM app_movimientos WHERE fab_idretiro=$id")->row();
    }

    public function saldo($id_cuenta_metodo)
    {
        return $this->consultar("SELECT SUM(fab_monto) as total 
        FROM app_movimientos m
        JOIN app_cuentas_metodopago cm ON m.fab_cmpid = cm.cmp_id
        WHERE m.fab_cmpid = $id_cuenta_metodo")->row();
    }

    public function pagarCuenta(int $id_cuenta, float $monto)
    {
        return $this->consultar("UPDATE app_bancos_cuentas SET bc_saldo = $monto WHERE bc_id = $id_cuenta")->run();
    }

    public function pagarCuentaMetodo(int $id_cuenta_metodo, float $monto)
    {
        return $this->consultar("UPDATE app_cuentas_metodopago SET cmp_saldo = $monto WHERE cmp_id = $id_cuenta_metodo")->run();
    }
}
